/*
 * Decompiled with CFR 0.152.
 */
package com.xeli.createcclogistics.peripheral.itemhandling;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.xeli.createcclogistics.peripheral.AssertBetweenKt;
import dan200.computercraft.api.lua.LuaException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a2\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b0\t2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a,\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\t*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a#\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00140\t\"\u0006\b\u0000\u0010\u0014\u0018\u0001*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0086\b\"\u0014\u0010\u0006\u001a\u00020\u0002X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0014\u0010\u0010\u001a\u00020\u0002X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\b\u00a8\u0006\u0015"}, d2={"reinterpret", "Lnet/minecraft/world/item/ItemStack;", "", "holderLookup", "Lnet/minecraft/core/HolderLookup$Provider;", "reinterpretAsID", "expectedFormat", "getExpectedFormat", "()Ljava/lang/String;", "", "Lcom/simibubi/create/content/logistics/BigItemStack;", "", "registryAccess", "Lnet/minecraft/core/RegistryAccess;", "indexable", "Lcom/simibubi/create/content/logistics/packager/InventorySummary;", "expectedCraftingFormat", "getExpectedCraftingFormat", "reinterpretAsCraft", "coerceList", "T", "createcclogistics-1.21.1"})
@SourceDebugExtension(value={"SMAP\nReinterpretItemTag.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReinterpretItemTag.kt\ncom/xeli/createcclogistics/peripheral/itemhandling/ReinterpretItemTagKt\n+ 2 Optionals.kt\nkotlin/jvm/optionals/OptionalsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n122#1,2:136\n124#1:142\n126#1,2:144\n34#2:130\n34#2:131\n1557#3:132\n1628#3,3:133\n1053#3:138\n1557#3:139\n1628#3,2:140\n1630#3:143\n1557#3:146\n1628#3,3:147\n1053#3:150\n1557#3:151\n1628#3,3:152\n*S KotlinDebug\n*F\n+ 1 ReinterpretItemTag.kt\ncom/xeli/createcclogistics/peripheral/itemhandling/ReinterpretItemTagKt\n*L\n110#1:136,2\n110#1:142\n110#1:144,2\n21#1:130\n33#1:131\n46#1:132\n46#1:133,3\n110#1:138\n110#1:139\n110#1:140,2\n110#1:143\n112#1:146\n112#1:147,3\n123#1:150\n123#1:151\n123#1:152,3\n*E\n"})
public final class ReinterpretItemTagKt {
    @NotNull
    private static final String expectedFormat = "Expected table format: {count = [int], item = [string]} or {count = [int], id = [string]} or {count = [int], index = [int]}";
    @NotNull
    private static final String expectedCraftingFormat = "Expected crafting format: {item = [string]} or {id = [string]} or {index = [int]} or \"empty\"";

    @NotNull
    public static final ItemStack reinterpret(@NotNull String $this$reinterpret, @NotNull HolderLookup.Provider holderLookup) {
        Intrinsics.checkNotNullParameter((Object)$this$reinterpret, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)holderLookup, (String)"holderLookup");
        JsonElement json = JsonParser.parseString((String)$this$reinterpret);
        RegistryOps context = holderLookup.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        Optional result = ItemStack.CODEC.decode((DynamicOps)context, (Object)json).result();
        Intrinsics.checkNotNull((Object)result);
        Optional $this$getOrElse$iv = result;
        boolean $i$f$getOrElse = false;
        if (!$this$getOrElse$iv.isPresent()) {
            boolean bl = false;
            throw new LuaException("Item not parseable from \"" + $this$reinterpret + "\" or non-existent");
        }
        Object object = ((Pair)$this$getOrElse$iv.get()).getFirst();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getFirst(...)");
        return (ItemStack)object;
    }

    @NotNull
    public static final ItemStack reinterpretAsID(@NotNull String $this$reinterpretAsID, @NotNull HolderLookup.Provider holderLookup) {
        JsonObject jsonObject;
        Intrinsics.checkNotNullParameter((Object)$this$reinterpretAsID, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)holderLookup, (String)"holderLookup");
        JsonObject it = jsonObject = new JsonObject();
        boolean bl = false;
        it.add("id", (JsonElement)new JsonPrimitive($this$reinterpretAsID));
        it.add("count", (JsonElement)new JsonPrimitive((Number)1));
        JsonObject json = jsonObject;
        RegistryOps context = holderLookup.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        Optional result = ItemStack.CODEC.decode((DynamicOps)context, (Object)json).result();
        Intrinsics.checkNotNull((Object)result);
        Optional $this$getOrElse$iv = result;
        boolean $i$f$getOrElse = false;
        if (!$this$getOrElse$iv.isPresent()) {
            boolean bl2 = false;
            throw new LuaException("Item not parseable from \"" + $this$reinterpretAsID + "\" or non-existent");
        }
        Object object = ((Pair)$this$getOrElse$iv.get()).getFirst();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getFirst(...)");
        return (ItemStack)object;
    }

    @NotNull
    public static final String getExpectedFormat() {
        return expectedFormat;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<BigItemStack> reinterpret(@NotNull List<? extends Map<?, ?>> $this$reinterpret, @NotNull RegistryAccess registryAccess, @Nullable InventorySummary indexable) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$reinterpret, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        Iterable $this$map$iv = $this$reinterpret;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            BigItemStack bigItemStack;
            int n;
            void dict;
            Map map = (Map)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object v = dict.get("count");
            Integer n2 = v instanceof Integer ? (Integer)v : null;
            if (n2 != null) {
                n = n2;
            } else {
                Object v2 = dict.get("count");
                Double d = v2 instanceof Double ? (Double)v2 : null;
                Integer n3 = d != null ? Integer.valueOf((int)d.doubleValue()) : null;
                if (n3 != null) {
                    n = n3;
                } else {
                    throw new LuaException(expectedFormat);
                }
            }
            int count = n;
            if (dict.get("item") != null) {
                String itemStackTag;
                var15_15 = dict.get("item");
                if ((var15_15 instanceof String ? (String)var15_15 : null) == null) {
                    throw new LuaException(expectedFormat);
                }
                itemStackTag = itemStackTag;
                bigItemStack = new BigItemStack(ReinterpretItemTagKt.reinterpret(itemStackTag, (HolderLookup.Provider)registryAccess), count);
            } else if (dict.get("id") != null) {
                String itemId;
                var15_15 = dict.get("id");
                if ((var15_15 instanceof String ? (String)var15_15 : null) == null) {
                    throw new LuaException(expectedFormat);
                }
                itemId = itemId;
                bigItemStack = new BigItemStack(ReinterpretItemTagKt.reinterpretAsID(itemId, (HolderLookup.Provider)registryAccess), count);
            } else if (dict.get("index") != null) {
                var15_15 = dict.get("index");
                Double d = var15_15 instanceof Double ? (Double)var15_15 : null;
                if (d == null) {
                    throw new LuaException(expectedFormat);
                }
                int index = (int)d.doubleValue();
                if (indexable == null) {
                    throw new LuaException("No inventory summary available");
                }
                AssertBetweenKt.assertBetween(index, 1, indexable.getStacks().size(), "Index out of range (%s)");
                bigItemStack = new BigItemStack(((BigItemStack)indexable.getStacks().get((int)(index - 1))).stack, count);
            } else {
                throw new LuaException(expectedFormat);
            }
            collection.add(bigItemStack);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List reinterpret$default(List list, RegistryAccess registryAccess, InventorySummary inventorySummary, int n, Object object) {
        if ((n & 2) != 0) {
            inventorySummary = null;
        }
        return ReinterpretItemTagKt.reinterpret(list, registryAccess, inventorySummary);
    }

    @NotNull
    public static final String getExpectedCraftingFormat() {
        return expectedCraftingFormat;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<BigItemStack> reinterpretAsCraft(@NotNull Map<?, ?> $this$reinterpretAsCraft, @NotNull RegistryAccess registryAccess, @Nullable InventorySummary indexable) {
        void $this$mapTo$iv$iv;
        List list;
        Collection collection;
        Intrinsics.checkNotNullParameter($this$reinterpretAsCraft, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        Map<?, ?> $this$coerceList$iv = $this$reinterpretAsCraft;
        boolean $i$f$coerceList = false;
        try {
            void $this$mapTo$iv$iv$iv;
            void $this$map$iv$iv;
            Iterable $this$sortedBy$iv$iv = $this$coerceList$iv.entrySet();
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    K k = it.getKey();
                    Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type kotlin.Double");
                    it = (Map.Entry)b;
                    Comparable comparable = (Double)k;
                    bl = false;
                    K k2 = it.getKey();
                    Intrinsics.checkNotNull(k2, (String)"null cannot be cast to non-null type kotlin.Double");
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Double)k2));
                }
            });
            boolean $i$f$map = false;
            void var8_11 = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void it$iv;
                Map.Entry entry = (Map.Entry)item$iv$iv$iv;
                collection = destination$iv$iv$iv;
                boolean bl = false;
                Object v = it$iv.getValue();
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
                }
                collection.add(v);
            }
            list = (List)destination$iv$iv$iv;
        }
        catch (ClassCastException e$iv) {
            throw new LuaException(e$iv.getMessage());
        }
        List list2 = list;
        BigItemStack emptyIngredient = new BigItemStack(ItemStack.EMPTY, 1);
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable e$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            BigItemStack bigItemStack;
            void it;
            Object item$iv$iv;
            Object item$iv$iv$iv;
            item$iv$iv$iv = item$iv$iv = iterator.next();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection = it;
            if (Intrinsics.areEqual((Object)collection, (Object)"empty")) {
                bigItemStack = emptyIngredient;
            } else if (collection instanceof Map) {
                bigItemStack = ReinterpretItemTagKt.reinterpretAsCraft$parseDict(registryAccess, indexable, (Map)it);
            } else {
                throw new LuaException(expectedCraftingFormat + ", got " + it);
            }
            collection2.add(bigItemStack);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List reinterpretAsCraft$default(Map map, RegistryAccess registryAccess, InventorySummary inventorySummary, int n, Object object) {
        if ((n & 2) != 0) {
            inventorySummary = null;
        }
        return ReinterpretItemTagKt.reinterpretAsCraft(map, registryAccess, inventorySummary);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T> List<T> coerceList(Map<?, ?> $this$coerceList) {
        Intrinsics.checkNotNullParameter($this$coerceList, (String)"<this>");
        boolean $i$f$coerceList = false;
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$sortedBy$iv = $this$coerceList.entrySet();
            boolean $i$f$sortedBy = false;
            Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new /* invalid duplicate definition of identical inner class */);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Map.Entry entry = (Map.Entry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object v = it.getValue();
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                collection.add(v);
            }
            return (List)destination$iv$iv;
        }
        catch (ClassCastException e) {
            throw new LuaException(e.getMessage());
        }
    }

    private static final BigItemStack reinterpretAsCraft$parseDict(RegistryAccess $registryAccess, InventorySummary $indexable, Map<?, ?> dict) {
        BigItemStack bigItemStack;
        if (dict.get("item") != null) {
            Object obj = dict.get("item");
            String string = obj instanceof String ? (String)obj : null;
            if (string == null) {
                throw new LuaException(expectedCraftingFormat);
            }
            String itemStackTag = string;
            bigItemStack = new BigItemStack(ReinterpretItemTagKt.reinterpret(itemStackTag, (HolderLookup.Provider)$registryAccess), 1);
        } else if (dict.get("id") != null) {
            Object obj = dict.get("id");
            String string = obj instanceof String ? (String)obj : null;
            if (string == null) {
                throw new LuaException(expectedCraftingFormat);
            }
            String itemId = string;
            bigItemStack = new BigItemStack(ReinterpretItemTagKt.reinterpretAsID(itemId, (HolderLookup.Provider)$registryAccess), 1);
        } else if (dict.get("index") != null) {
            Object obj = dict.get("index");
            Double d = obj instanceof Double ? (Double)obj : null;
            if (d == null) {
                throw new LuaException(expectedFormat);
            }
            int index = (int)d.doubleValue();
            if ($indexable == null) {
                throw new LuaException("No inventory summary available");
            }
            AssertBetweenKt.assertBetween(index, 1, $indexable.getStacks().size(), "Index out of range (%s)");
            bigItemStack = new BigItemStack(((BigItemStack)$indexable.getStacks().get((int)(index - 1))).stack, 1);
        } else {
            throw new LuaException(expectedFormat);
        }
        return bigItemStack;
    }
}

