/*
 * Decompiled with CFR 0.152.
 */
package com.xeli.createcclogistics.peripheral;

import com.simibubi.create.AllDataComponents;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.xeli.createcclogistics.peripheral.AssertBetweenKt;
import com.xeli.createcclogistics.peripheral.itemhandling.ItemDetailsKt;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u001e\u0010\u0015\u001a\u0018\u0012\u0004\u0012\u00020\u0017\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0010\u0012\u0002\b\u00030\u00160\u0016H\u0007J\b\u0010\u0018\u001a\u00020\u0017H\u0007J \u0010\u0019\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0010\u0012\u0002\b\u00030\u00160\u001a2\u0006\u0010\u001b\u001a\u00020\u0017H\u0007J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0010H\u0007J\b\u0010\u001f\u001a\u00020\rH\u0007J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\rH\u0007J\b\u0010\"\u001a\u00020\u0010H\u0007J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u0010H\u0007J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006'"}, d2={"Lcom/xeli/createcclogistics/peripheral/PackagePortPeripheral;", "Ldan200/computercraft/api/peripheral/IPeripheral;", "be", "Lcom/simibubi/create/content/logistics/packagePort/PackagePortBlockEntity;", "direction", "Lnet/minecraft/core/Direction;", "<init>", "(Lcom/simibubi/create/content/logistics/packagePort/PackagePortBlockEntity;Lnet/minecraft/core/Direction;)V", "getBe", "()Lcom/simibubi/create/content/logistics/packagePort/PackagePortBlockEntity;", "getDirection", "()Lnet/minecraft/core/Direction;", "equals", "", "other", "getType", "", "getAdditionalTypes", "", "getTarget", "", "listPackages", "", "", "capacity", "getPackageContentDetails", "", "index", "renamePackageAddress", "", "name", "getAcceptsPackages", "setAcceptsPackages", "accept", "getAddressFilter", "setAddressFilter", "filter", "getPackageAtIndex", "Lnet/minecraft/world/item/ItemStack;", "createcclogistics-1.21.1"})
@SourceDebugExtension(value={"SMAP\nPackagePortPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackagePortPeripheral.kt\ncom/xeli/createcclogistics/peripheral/PackagePortPeripheral\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,108:1\n662#2:109\n743#2,4:110\n*S KotlinDebug\n*F\n+ 1 PackagePortPeripheral.kt\ncom/xeli/createcclogistics/peripheral/PackagePortPeripheral\n*L\n41#1:109\n41#1:110,4\n*E\n"})
public final class PackagePortPeripheral
implements IPeripheral {
    @NotNull
    private final PackagePortBlockEntity be;
    @NotNull
    private final Direction direction;

    public PackagePortPeripheral(@NotNull PackagePortBlockEntity be, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        this.be = be;
        this.direction = direction;
    }

    @NotNull
    public final PackagePortBlockEntity getBe() {
        return this.be;
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other instanceof PackagePortPeripheral && Intrinsics.areEqual((Object)this.be, (Object)((PackagePortPeripheral)other).be);
    }

    @NotNull
    public String getType() {
        return "packageport";
    }

    @NotNull
    public Set<String> getAdditionalTypes() {
        Set set = super.getAdditionalTypes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAdditionalTypes(...)");
        return SetsKt.plus((Set)set, (Object)"inventory");
    }

    @Nullable
    public Object getTarget() {
        return this.be;
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction(mainThread=true)
    @NotNull
    public final Map<Integer, Map<String, ?>> listPackages() {
        void $this$associateTo$iv$iv;
        Sequence $this$associate$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)0, (int)this.be.inventory.getSlots()))), arg_0 -> PackagePortPeripheral.listPackages$lambda$0(this, arg_0)), PackagePortPeripheral::listPackages$lambda$1);
        boolean $i$f$associate = false;
        Sequence sequence = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            PackageItem.PackageOrderData data;
            Map map = destination$iv$iv;
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            int index = ((Number)pair.component1()).intValue();
            ItemStack box = (ItemStack)pair.component2();
            PackageItem.PackageOrderData packageOrderData = data = (PackageItem.PackageOrderData)box.get(AllDataComponents.PACKAGE_ORDER_DATA);
            boolean isFinal = packageOrderData != null ? packageOrderData.isFinal() : true;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"address", (Object)PackageItem.getAddress((ItemStack)box)), TuplesKt.to((Object)"orderIsComplete", (Object)isFinal)};
            pair = TuplesKt.to((Object)index, (Object)MapsKt.mapOf((Pair[])pairArray));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @LuaFunction(mainThread=true)
    public final int capacity() {
        return this.be.inventory.getSlots();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, ?>> getPackageContentDetails(int index) {
        List list;
        AssertBetweenKt.assertBetween(index, 1, this.be.inventory.getSlots(), "Index out of range (%s)");
        ItemStack box = this.getPackageAtIndex(index - 1);
        ItemStackHandler itemStackHandler = PackageItem.getContents((ItemStack)box);
        Level level = this.be.getLevel();
        Intrinsics.checkNotNull((Object)level);
        RegistryAccess registryAccess = level.registryAccess();
        List $this$getPackageContentDetails_u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        int n = itemStackHandler.getSlots();
        for (int slot = 0; slot < n; ++slot) {
            if (itemStackHandler.getStackInSlot(slot).isEmpty()) continue;
            ItemStack itemStack = itemStackHandler.getStackInSlot(slot);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
            Intrinsics.checkNotNull((Object)registryAccess);
            $this$getPackageContentDetails_u24lambda_u243.add(ItemDetailsKt.itemDetails(itemStack, registryAccess));
        }
        return CollectionsKt.build((List)list);
    }

    @LuaFunction(mainThread=true)
    public final void renamePackageAddress(int index, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        AssertBetweenKt.assertBetween(index, 1, this.be.inventory.getSlots(), "Index out of range (%s)");
        ItemStack box = this.getPackageAtIndex(index - 1);
        PackageItem.addAddress((ItemStack)box, (String)name);
        this.be.inventory.setChanged();
    }

    @LuaFunction(mainThread=true)
    public final boolean getAcceptsPackages() {
        return this.be.acceptsPackages;
    }

    @LuaFunction(mainThread=true)
    public final void setAcceptsPackages(boolean accept) {
        this.be.acceptsPackages = accept;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final String getAddressFilter() {
        String string = this.be.addressFilter;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"addressFilter");
        return string;
    }

    @LuaFunction(mainThread=true)
    public final void setAddressFilter(@NotNull String filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (Intrinsics.areEqual((Object)filter, (Object)this.be.addressFilter)) {
            return;
        }
        this.be.addressFilter = filter;
        this.be.filterChanged();
        this.be.notifyUpdate();
    }

    private final ItemStack getPackageAtIndex(int index) {
        ItemStack itemStack;
        ItemStack $this$getPackageAtIndex_u24lambda_u244 = itemStack = this.be.inventory.getItem(index);
        boolean bl = false;
        if ($this$getPackageAtIndex_u24lambda_u244.isEmpty()) {
            throw new LuaException("Targeted index is empty");
        }
        if (!PackageItem.isPackage((ItemStack)$this$getPackageAtIndex_u24lambda_u244)) {
            throw new LuaException("Targeted index does not contain a package");
        }
        ItemStack itemStack2 = itemStack;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"apply(...)");
        return itemStack2;
    }

    private static final Pair listPackages$lambda$0(PackagePortPeripheral this$0, int index) {
        return TuplesKt.to((Object)(index + 1), (Object)this$0.be.inventory.getItem(index));
    }

    private static final boolean listPackages$lambda$1(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        ItemStack item = (ItemStack)pair.component2();
        return !item.isEmpty() && PackageItem.isPackage((ItemStack)item);
    }
}

