/*
 * Decompiled with CFR 0.152.
 */
package com.xeli.createcclogistics.peripheral;

import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.PackagerLinkBlockEntity;
import com.simibubi.create.content.logistics.stockTicker.StockCheckingBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.xeli.createcclogistics.peripheral.AssertBetweenKt;
import com.xeli.createcclogistics.peripheral.itemhandling.ItemDetailsKt;
import com.xeli.createcclogistics.peripheral.itemhandling.ReinterpretItemTagKt;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001#B\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0007J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0014H\u0007J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0014H\u0007J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0012H\u0007J\b\u0010\u001c\u001a\u00020\u0014H\u0007J\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0014H\u0007J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\"\u001a\u00020 R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lcom/xeli/createcclogistics/peripheral/DigitalStockTickerPeripheral;", "T", "Lcom/simibubi/create/content/logistics/stockTicker/StockCheckingBlockEntity;", "Ldan200/computercraft/api/peripheral/IPeripheral;", "be", "d", "Lnet/minecraft/core/Direction;", "<init>", "(Lcom/simibubi/create/content/logistics/stockTicker/StockCheckingBlockEntity;Lnet/minecraft/core/Direction;)V", "getBe", "()Lcom/simibubi/create/content/logistics/stockTicker/StockCheckingBlockEntity;", "Lcom/simibubi/create/content/logistics/stockTicker/StockCheckingBlockEntity;", "getD", "()Lnet/minecraft/core/Direction;", "equals", "", "other", "getType", "", "inventorySize", "", "itemBasicDetails", "", "", "index", "itemDetails", "getCountOf", "item", "countConnectedStockLinks", "stockLinkDetails", "listPackagers", "", "Lcom/simibubi/create/content/logistics/packager/PackagerBlockEntity;", "packagerInfo", "blockEntity", "Companion", "createcclogistics-1.21.1"})
public final class DigitalStockTickerPeripheral<T extends StockCheckingBlockEntity>
implements IPeripheral {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final T be;
    @NotNull
    private final Direction d;

    public DigitalStockTickerPeripheral(@NotNull T be, @NotNull Direction d) {
        Intrinsics.checkNotNullParameter(be, (String)"be");
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        this.be = be;
        this.d = d;
    }

    @NotNull
    public final T getBe() {
        return this.be;
    }

    @NotNull
    public final Direction getD() {
        return this.d;
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other instanceof DigitalStockTickerPeripheral && Intrinsics.areEqual(this.be, ((DigitalStockTickerPeripheral)other).be);
    }

    @NotNull
    public String getType() {
        return "stockcheckingblock";
    }

    @LuaFunction(mainThread=true)
    public final int inventorySize() {
        return this.be.getAccurateSummary().getStacks().size();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final Map<String, Object> itemBasicDetails(int index) {
        InventorySummary $this$itemBasicDetails_u24lambda_u240 = this.be.getAccurateSummary();
        boolean bl = false;
        AssertBetweenKt.assertBetween(index, 1, $this$itemBasicDetails_u24lambda_u240.getStacks().size(), "Index out of range (%s)");
        Object e = $this$itemBasicDetails_u24lambda_u240.getStacks().get(index - 1);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        return ItemDetailsKt.basicItemDetails((BigItemStack)e);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final Map<String, Object> itemDetails(int index) {
        InventorySummary $this$itemDetails_u24lambda_u241 = this.be.getAccurateSummary();
        boolean bl = false;
        AssertBetweenKt.assertBetween(index, 1, $this$itemDetails_u24lambda_u241.getStacks().size(), "Index out of range (%s)");
        Object e = $this$itemDetails_u24lambda_u241.getStacks().get(index - 1);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        BigItemStack bigItemStack = (BigItemStack)e;
        Level level = ((BlockEntity)this.be).getLevel();
        Intrinsics.checkNotNull((Object)level);
        RegistryAccess registryAccess = level.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        return ItemDetailsKt.itemDetails(bigItemStack, registryAccess);
    }

    @LuaFunction(mainThread=true)
    public final int getCountOf(@NotNull String item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        InventorySummary $this$getCountOf_u24lambda_u242 = this.be.getAccurateSummary();
        boolean bl = false;
        Level level = ((BlockEntity)this.be).getLevel();
        Intrinsics.checkNotNull((Object)level);
        RegistryAccess registryAccess = level.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        return $this$getCountOf_u24lambda_u242.getCountOf(ReinterpretItemTagKt.reinterpret(item, (HolderLookup.Provider)registryAccess));
    }

    @LuaFunction(mainThread=true)
    public final int countConnectedStockLinks() {
        return this.listPackagers().size();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final Map<String, Object> stockLinkDetails(int index) {
        List<PackagerBlockEntity> packagers = this.listPackagers();
        AssertBetweenKt.assertBetween(index, 1, packagers.size(), "Index out of range (%s)");
        return this.packagerInfo(this.listPackagers().get(index - 1));
    }

    @NotNull
    public final List<PackagerBlockEntity> listPackagers() {
        List list;
        List $this$listPackagers_u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (LogisticallyLinkedBehaviour link : LogisticallyLinkedBehaviour.getAllPresent((UUID)((StockCheckingBlockEntity)this.be).behaviour.freqId, (boolean)false)) {
            PackagerBlockEntity packager;
            SmartBlockEntity blockEntity = link.blockEntity;
            if (!(blockEntity instanceof PackagerLinkBlockEntity) || (packager = ((PackagerLinkBlockEntity)blockEntity).getPackager()) == null) continue;
            $this$listPackagers_u24lambda_u243.add(packager);
        }
        return CollectionsKt.build((List)list);
    }

    @NotNull
    public final Map<String, Object> packagerInfo(@NotNull PackagerBlockEntity blockEntity) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Map $this$packagerInfo_u24lambda_u246 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        InvManipulationBehaviour targetInventory = blockEntity.targetInventory;
        IItemHandler inventory = (IItemHandler)targetInventory.getInventory();
        if (inventory != null) {
            $this$packagerInfo_u24lambda_u246.put("capacity", inventory.getSlots());
            $this$packagerInfo_u24lambda_u246.put("occupiedSlots", Companion.getOccupiedSlots(inventory));
        } else {
            $this$packagerInfo_u24lambda_u246.put("capacity", "unknown");
        }
        Map map2 = $this$packagerInfo_u24lambda_u246;
        String string = "type";
        Object object = Companion.targetBlock(blockEntity);
        if (object == null || (object = Companion.getId((Block)object)) == null) {
            object = "unknown";
        }
        Object object2 = object;
        map2.put(string, object2);
        DigitalStockTickerPeripheral.Companion.getFrogportFromPackager(blockEntity).ifPresent(arg_0 -> DigitalStockTickerPeripheral.packagerInfo$lambda$6$lambda$5(arg_0 -> DigitalStockTickerPeripheral.packagerInfo$lambda$6$lambda$4($this$packagerInfo_u24lambda_u246, arg_0), arg_0));
        return MapsKt.build((Map)map);
    }

    private static final Unit packagerInfo$lambda$6$lambda$4(Map $this_buildMap, FrogportBlockEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String address = it.addressFilter;
        $this_buildMap.put("frogportAddress", address);
        return Unit.INSTANCE;
    }

    private static final void packagerInfo$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0007H\u0002J\f\u0010\b\u001a\u00020\t*\u00020\u0007H\u0002J\f\u0010\u0014\u001a\u0004\u0018\u00010\u0011*\u00020\u0007R\u0015\u0010\n\u001a\u00020\u000b*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/xeli/createcclogistics/peripheral/DigitalStockTickerPeripheral$Companion;", "", "<init>", "()V", "getFrogportFromPackager", "Ljava/util/Optional;", "Lcom/simibubi/create/content/logistics/packagePort/frogport/FrogportBlockEntity;", "Lcom/simibubi/create/content/logistics/packager/PackagerBlockEntity;", "facingPos", "Lnet/minecraft/core/BlockPos;", "occupiedSlots", "", "Lnet/neoforged/neoforge/items/IItemHandler;", "getOccupiedSlots", "(Lnet/neoforged/neoforge/items/IItemHandler;)I", "id", "", "Lnet/minecraft/world/level/block/Block;", "getId", "(Lnet/minecraft/world/level/block/Block;)Ljava/lang/String;", "targetBlock", "createcclogistics-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        private final Optional<FrogportBlockEntity> getFrogportFromPackager(PackagerBlockEntity $this$getFrogportFromPackager) {
            BlockEntity above;
            Level level = $this$getFrogportFromPackager.getLevel();
            BlockEntity blockEntity = above = level != null ? level.getBlockEntity($this$getFrogportFromPackager.getBlockPos().relative(Direction.UP)) : null;
            if (above instanceof FrogportBlockEntity) {
                Optional<BlockEntity> optional = Optional.of(above);
                Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                return optional;
            }
            Optional<FrogportBlockEntity> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }

        private final BlockPos facingPos(PackagerBlockEntity $this$facingPos) {
            Level level = $this$facingPos.getLevel();
            Intrinsics.checkNotNull((Object)level);
            Direction direction = (Direction)level.getBlockState($this$facingPos.getBlockPos()).getValue((Property)DirectionalBlock.FACING);
            BlockPos blockPos = $this$facingPos.getBlockPos().relative(direction.getOpposite());
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"relative(...)");
            return blockPos;
        }

        public final int getOccupiedSlots(@NotNull IItemHandler $this$occupiedSlots) {
            Intrinsics.checkNotNullParameter((Object)$this$occupiedSlots, (String)"<this>");
            int occupiedSlots = 0;
            int n = $this$occupiedSlots.getSlots();
            for (int slot = 0; slot < n; ++slot) {
                if ($this$occupiedSlots.getStackInSlot(slot).isEmpty()) continue;
                ++occupiedSlots;
            }
            return occupiedSlots;
        }

        @NotNull
        public final String getId(@NotNull Block $this$id) {
            Intrinsics.checkNotNullParameter((Object)$this$id, (String)"<this>");
            String string = ((ResourceKey)BuiltInRegistries.BLOCK.wrapAsHolder((Object)$this$id).unwrapKey().get()).location().toLanguageKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLanguageKey(...)");
            return string;
        }

        @Nullable
        public final Block targetBlock(@NotNull PackagerBlockEntity $this$targetBlock) {
            BlockState blockState;
            Intrinsics.checkNotNullParameter((Object)$this$targetBlock, (String)"<this>");
            Level level = $this$targetBlock.getLevel();
            return level != null && (blockState = level.getBlockState(this.facingPos($this$targetBlock))) != null ? blockState.getBlock() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

