/*
 * Decompiled with CFR 0.152.
 */
package com.xeli.createcclogistics.peripheral;

import com.simibubi.create.content.equipment.clipboard.ClipboardBlockEntity;
import com.simibubi.create.content.equipment.clipboard.ClipboardEntry;
import com.xeli.createcclogistics.peripheral.AssertBetweenKt;
import com.xeli.createcclogistics.peripheral.PeripheralContext;
import com.xeli.createcclogistics.peripheral.itemhandling.ItemDetailsKt;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\tH\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0007J \u0010\u0010\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\f\u0012\u0002\b\u00030\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u000fH\u0007J\u0014\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/xeli/createcclogistics/peripheral/ClipboardPeripheral;", "Ldan200/computercraft/api/peripheral/IPeripheral;", "ctx", "Lcom/xeli/createcclogistics/peripheral/PeripheralContext;", "<init>", "(Lcom/xeli/createcclogistics/peripheral/PeripheralContext;)V", "getCtx", "()Lcom/xeli/createcclogistics/peripheral/PeripheralContext;", "equals", "", "other", "getType", "", "isClipboardAttached", "getNumPages", "", "readPage", "", "", "index", "getPages", "", "Lcom/simibubi/create/content/equipment/clipboard/ClipboardEntry;", "createcclogistics-1.21.1"})
@SourceDebugExtension(value={"SMAP\nClipboardPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClipboardPeripheral.kt\ncom/xeli/createcclogistics/peripheral/ClipboardPeripheral\n+ 2 Optionals.kt\nkotlin/jvm/optionals/OptionalsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n34#2:64\n34#2:69\n1557#3:65\n1628#3,3:66\n*S KotlinDebug\n*F\n+ 1 ClipboardPeripheral.kt\ncom/xeli/createcclogistics/peripheral/ClipboardPeripheral\n*L\n23#1:64\n55#1:69\n38#1:65\n38#1:66,3\n*E\n"})
public final class ClipboardPeripheral
implements IPeripheral {
    @NotNull
    private final PeripheralContext ctx;

    public ClipboardPeripheral(@NotNull PeripheralContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.ctx = ctx;
    }

    @NotNull
    public final PeripheralContext getCtx() {
        return this.ctx;
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other instanceof ClipboardPeripheral && Intrinsics.areEqual(this.ctx.getTargetBlockEntity(), ((ClipboardPeripheral)other).ctx.getTargetBlockEntity());
    }

    @NotNull
    public String getType() {
        return "clipboard";
    }

    @LuaFunction
    public final boolean isClipboardAttached() {
        Optional<BlockEntity> $this$getOrElse$iv = this.ctx.getTargetBlockEntity();
        boolean $i$f$getOrElse = false;
        if (!$this$getOrElse$iv.isPresent()) {
            boolean bl = false;
            return false;
        }
        BlockEntity be = $this$getOrElse$iv.get();
        return be instanceof ClipboardBlockEntity;
    }

    @LuaFunction
    public final int getNumPages() {
        return this.getPages().size();
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction
    @NotNull
    public final List<Map<String, ?>> readPage(int index) {
        void $this$mapTo$iv$iv;
        List<List<ClipboardEntry>> pages = this.getPages();
        AssertBetweenKt.assertBetween(index, 1, pages.size(), "Index out of range (%s)");
        Iterable $this$map$iv = pages.get(index - 1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            String string;
            Map map;
            void entry;
            Map map2;
            ClipboardEntry clipboardEntry = (ClipboardEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Map $this$readPage_u24lambda_u243_u24lambda_u242 = map2 = MapsKt.createMapBuilder();
            boolean bl2 = false;
            $this$readPage_u24lambda_u243_u24lambda_u242.put("checked", entry.checked);
            if (!entry.icon.isEmpty()) {
                map = $this$readPage_u24lambda_u243_u24lambda_u242;
                string = "icon";
                ItemStack itemStack = entry.icon;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"icon");
                RegistryAccess registryAccess = this.ctx.getLevel().registryAccess();
                Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
                Map<String, Object> it = ItemDetailsKt.itemDetails(itemStack, registryAccess);
                boolean bl3 = false;
                Map mutable = MapsKt.toMutableMap(it);
                mutable.replace("count", entry.itemAmount);
                object = mutable;
                map.put(string, object);
            }
            map = $this$readPage_u24lambda_u243_u24lambda_u242;
            string = "text";
            String string2 = entry.text.tryCollapseToString();
            if (string2 == null) {
                string2 = "";
            }
            object = string2;
            map.put(string, object);
            collection.add(MapsKt.build((Map)map2));
        }
        return (List)destination$iv$iv;
    }

    private final List<List<ClipboardEntry>> getPages() {
        Optional<BlockEntity> $this$getOrElse$iv = this.ctx.getTargetBlockEntity();
        boolean $i$f$getOrElse = false;
        if (!$this$getOrElse$iv.isPresent()) {
            boolean bl = false;
            throw new LuaException("No clipboard attached");
        }
        BlockEntity be = $this$getOrElse$iv.get();
        if (be instanceof ClipboardBlockEntity) {
            ItemStack clipboardItem = ((ClipboardBlockEntity)be).dataContainer;
            List list = ClipboardEntry.readAll((ItemStack)clipboardItem);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readAll(...)");
            return list;
        }
        throw new LuaException("No clipboard attached");
    }
}

