/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.inventory;

import appeng.api.stacks.GenericStack;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaTable;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.APAddon;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RSApi;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.ChemicalUtil;
import de.srendi.advancedperipherals.common.util.inventory.GenericFilter;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class ChemicalFilter
extends GenericFilter<ChemicalStack> {
    public static final ChemicalFilter EMPTY = new ChemicalFilter();
    private Holder<Chemical> chemical = MekanismAPI.EMPTY_CHEMICAL.getAsHolder();
    private TagKey<Chemical> tag = null;
    private long count = 1000L;
    private String fingerprint = "";
    public int fromSlot = -1;
    public int toSlot = -1;

    private ChemicalFilter() {
    }

    public static Pair<ChemicalFilter, String> parse(LuaTable<?, ?> item) {
        if (item.isEmpty()) {
            return Pair.of(EMPTY, null);
        }
        ChemicalFilter chemicalFilter = ChemicalFilter.createEmpty();
        if (item.containsKey((Object)"name")) {
            try {
                String name = item.getString("name");
                if (name.startsWith("#")) {
                    chemicalFilter.tag = TagKey.create((net.minecraft.resources.ResourceKey)MekanismAPI.CHEMICAL_REGISTRY_NAME, (ResourceLocation)ResourceLocation.parse((String)name.substring(1)));
                } else {
                    chemicalFilter.chemical = MekanismAPI.CHEMICAL_REGISTRY.getHolder(ResourceLocation.parse((String)name)).orElse(null);
                    if (chemicalFilter.chemical == null) {
                        return Pair.of(null, "CHEMICAL_NOT_FOUND");
                    }
                }
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_ITEM");
            }
        }
        if (item.containsKey((Object)"fingerprint")) {
            try {
                chemicalFilter.fingerprint = item.getString("fingerprint");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_FINGERPRINT");
            }
        }
        if (item.containsKey((Object)"fromSlot")) {
            try {
                chemicalFilter.fromSlot = item.getInt("fromSlot");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_FROMSLOT");
            }
        }
        if (item.containsKey((Object)"toSlot")) {
            try {
                chemicalFilter.toSlot = item.getInt("toSlot");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_TOSLOT");
            }
        }
        if (item.containsKey((Object)"count")) {
            try {
                chemicalFilter.count = item.getInt("count");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_COUNT");
            }
        }
        AdvancedPeripherals.debug("Parsed item filter: " + String.valueOf(chemicalFilter));
        return Pair.of(chemicalFilter, null);
    }

    public static ChemicalFilter fromStack(ChemicalStack stack) {
        ChemicalFilter filter = ChemicalFilter.createEmpty();
        filter.chemical = stack.getChemicalHolder();
        return filter;
    }

    public static ChemicalFilter createEmpty() {
        return new ChemicalFilter();
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY || this.fingerprint.isEmpty() && this.chemical.is(MekanismAPI.EMPTY_CHEMICAL_NAME) && this.tag == null;
    }

    @Override
    public boolean testAE(GenericStack genericStack) {
        return false;
    }

    @Override
    public boolean testRS(ResourceAmount resourceAmount) {
        if (!APAddon.REFINEDSTORAGE_MEKANISM.isLoaded()) {
            return false;
        }
        ResourceKey resourceKey = resourceAmount.resource();
        if (resourceKey instanceof ChemicalResource) {
            ChemicalResource chemicalResource = (ChemicalResource)resourceKey;
            return this.test(RSApi.resourceToChemicalStack(chemicalResource));
        }
        return false;
    }

    public ChemicalStack toChemicalStack() {
        return new ChemicalStack(this.chemical, this.count);
    }

    @Override
    public boolean test(ChemicalStack stack) {
        if (this.isEmpty()) {
            return true;
        }
        if (!this.fingerprint.isEmpty()) {
            String testFingerprint = ChemicalUtil.getFingerprint(stack);
            return this.fingerprint.equals(testFingerprint);
        }
        if (!this.chemical.is(MekanismAPI.EMPTY_CHEMICAL_NAME) && !stack.is(this.chemical)) {
            return false;
        }
        return this.tag == null || stack.is(this.tag);
    }

    public long getCount() {
        return this.count;
    }

    public Holder<Chemical> getChemical() {
        return this.chemical;
    }

    public int getFromSlot() {
        return this.fromSlot;
    }

    public int getToSlot() {
        return this.toSlot;
    }

    public String toString() {
        return "ChemicalFilter{item=" + this.chemical.getRegisteredName() + ", tag=" + String.valueOf(this.tag) + ", count=" + this.count + ", fingerprint='" + this.fingerprint + "', fromSlot=" + this.fromSlot + ", toSlot=" + this.toSlot + "}";
    }
}

