/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.init;

import glitchcore.event.client.ItemTooltipEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModTags;

public class ModFertility {
    private static Set<String> springPlants = new HashSet<String>();
    private static Set<String> summerPlants = new HashSet<String>();
    private static Set<String> autumnPlants = new HashSet<String>();
    private static Set<String> winterPlants = new HashSet<String>();
    private static Set<String> allListedPlants = new HashSet<String>();
    private static HashMap<String, Integer> seedSeasons = new HashMap();

    public static void populate() {
        springPlants.clear();
        summerPlants.clear();
        autumnPlants.clear();
        winterPlants.clear();
        allListedPlants.clear();
        seedSeasons.clear();
        ModFertility.populateSeasonCrops(ModTags.Blocks.SPRING_CROPS, springPlants, 1);
        ModFertility.populateSeasonCrops(ModTags.Blocks.SUMMER_CROPS, summerPlants, 2);
        ModFertility.populateSeasonCrops(ModTags.Blocks.AUTUMN_CROPS, autumnPlants, 4);
        ModFertility.populateSeasonCrops(ModTags.Blocks.WINTER_CROPS, winterPlants, 8);
        ModFertility.populateSeasonSeeds(ModTags.Items.SPRING_CROPS, springPlants, 1);
        ModFertility.populateSeasonSeeds(ModTags.Items.SUMMER_CROPS, summerPlants, 2);
        ModFertility.populateSeasonSeeds(ModTags.Items.AUTUMN_CROPS, autumnPlants, 4);
        ModFertility.populateSeasonSeeds(ModTags.Items.WINTER_CROPS, winterPlants, 8);
    }

    public static boolean isCrop(BlockState state) {
        return state.is(ModTags.Blocks.SPRING_CROPS) || state.is(ModTags.Blocks.SUMMER_CROPS) || state.is(ModTags.Blocks.AUTUMN_CROPS) || state.is(ModTags.Blocks.WINTER_CROPS);
    }

    public static boolean isCropFertile(String cropName, Level level, BlockPos pos) {
        Season season = SeasonHelper.getSeasonState(level).getSeason();
        Holder biome = level.getBiome(pos);
        if (pos.getY() < ModConfig.fertility.undergroundFertilityLevel && !level.canSeeSky(pos)) {
            return true;
        }
        if (biome.is(ModTags.Biomes.INFERTILE_BIOMES)) {
            return false;
        }
        if (!ModConfig.fertility.seasonalCrops || biome.is(ModTags.Biomes.BLACKLISTED_BIOMES) || !ModConfig.seasons.isDimensionWhitelisted((ResourceKey<Level>)level.dimension())) {
            return true;
        }
        if (biome.is(ModTags.Biomes.TROPICAL_BIOMES)) {
            return summerPlants.contains(cropName) || !allListedPlants.contains(cropName);
        }
        if (!((Biome)biome.value()).warmEnoughToRain(pos)) {
            return winterPlants.contains(cropName);
        }
        if (season == Season.SPRING && springPlants.contains(cropName)) {
            return true;
        }
        if (season == Season.SUMMER && summerPlants.contains(cropName)) {
            return true;
        }
        if (season == Season.AUTUMN && autumnPlants.contains(cropName)) {
            return true;
        }
        if (season == Season.WINTER && winterPlants.contains(cropName)) {
            return true;
        }
        return !allListedPlants.contains(cropName);
    }

    private static void populateSeasonCrops(TagKey<Block> tag, Set<String> cropSet, int bitmask) {
        BuiltInRegistries.BLOCK.getTag(tag).ifPresent(blocks -> {
            for (Holder block : blocks) {
                Optional blockKey = block.unwrapKey();
                if (blockKey.isEmpty()) continue;
                String plantName = ((ResourceKey)blockKey.get()).location().toString();
                cropSet.add(plantName);
                if (bitmask == 0) continue;
                allListedPlants.add(plantName);
                if (seedSeasons.containsKey(plantName)) {
                    int seasons = seedSeasons.get(plantName);
                    seedSeasons.put(plantName, seasons | bitmask);
                    continue;
                }
                seedSeasons.put(plantName, bitmask);
            }
        });
    }

    private static void populateSeasonSeeds(TagKey<Item> tag, Set<String> cropSet, int bitmask) {
        BuiltInRegistries.ITEM.getTag(tag).ifPresent(items -> {
            for (Holder item : items) {
                Optional itemKey = item.unwrapKey();
                if (itemKey.isEmpty()) continue;
                String plantName = ((ResourceKey)itemKey.get()).location().toString();
                cropSet.add(plantName);
                if (bitmask == 0) continue;
                allListedPlants.add(plantName);
                if (seedSeasons.containsKey(plantName)) {
                    int seasons = seedSeasons.get(plantName);
                    seedSeasons.put(plantName, seasons | bitmask);
                    continue;
                }
                seedSeasons.put(plantName, bitmask);
            }
        });
    }

    public static void setupTooltips(ItemTooltipEvent event) {
        String name;
        if (ModConfig.fertility.cropTooltips && ModConfig.fertility.seasonalCrops && seedSeasons.containsKey(name = BuiltInRegistries.ITEM.getKey((Object)event.getStack().getItem()).toString())) {
            int mask = seedSeasons.get(name);
            event.getTooltip().add(Component.translatable((String)"desc.sereneseasons.fertile_seasons").append(":"));
            if ((mask & 1) != 0 && (mask & 2) != 0 && (mask & 4) != 0 && (mask & 8) != 0) {
                event.getTooltip().add(Component.translatable((String)" ").append((Component)Component.translatable((String)"desc.sereneseasons.year_round")).withStyle(ChatFormatting.LIGHT_PURPLE));
            } else {
                if ((mask & 1) != 0) {
                    event.getTooltip().add(Component.translatable((String)" ").append((Component)Component.translatable((String)"desc.sereneseasons.spring")).withStyle(ChatFormatting.GREEN));
                }
                if ((mask & 2) != 0) {
                    event.getTooltip().add(Component.translatable((String)" ").append((Component)Component.translatable((String)"desc.sereneseasons.summer")).withStyle(ChatFormatting.YELLOW));
                }
                if ((mask & 4) != 0) {
                    event.getTooltip().add(Component.translatable((String)" ").append((Component)Component.translatable((String)"desc.sereneseasons.autumn")).withStyle(ChatFormatting.GOLD));
                }
                if ((mask & 8) != 0) {
                    event.getTooltip().add(Component.translatable((String)" ").append((Component)Component.translatable((String)"desc.sereneseasons.winter")).withStyle(ChatFormatting.AQUA));
                }
            }
        }
    }
}

