/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.client.renderer.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.strawstatues.StrawStatues;
import fuzs.strawstatues.client.init.ModClientRegistry;
import fuzs.strawstatues.client.model.StrawStatueArmorModel;
import fuzs.strawstatues.client.model.StrawStatueModel;
import fuzs.strawstatues.client.renderer.entity.layers.StrawStatueCapeLayer;
import fuzs.strawstatues.client.renderer.entity.layers.StrawStatueDeadmau5EarsLayer;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StrawStatueRenderer
extends LivingEntityRenderer<StrawStatue, StrawStatueModel> {
    public static final ResourceLocation STRAW_STATUE_LOCATION = StrawStatues.id("textures/entity/straw_statue.png");

    public StrawStatueRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new StrawStatueModel(context.m_174023_(ModClientRegistry.STRAW_STATUE), false), 0.0f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new StrawStatueArmorModel(context.m_174023_(ModClientRegistry.STRAW_STATUE_INNER_ARMOR)), new StrawStatueArmorModel(context.m_174023_(ModClientRegistry.STRAW_STATUE_OUTER_ARMOR)), context.m_266367_()));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.m_234598_()));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.m_174027_()));
        this.m_115326_(new StrawStatueDeadmau5EarsLayer((RenderLayerParent<StrawStatue, StrawStatueModel>)this));
        this.m_115326_(new StrawStatueCapeLayer((RenderLayerParent<StrawStatue, StrawStatueModel>)this));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_(), context.m_234598_()));
    }

    public static Optional<ResourceLocation> getPlayerProfileTexture(StrawStatue entity, MinecraftProfileTexture.Type type) {
        Minecraft minecraft;
        Map map;
        GameProfile gameProfile = entity.getOwner().orElse(null);
        if (gameProfile != null && (map = (minecraft = Minecraft.m_91087_()).m_91109_().m_118815_(gameProfile)).containsKey(type)) {
            return Optional.of(minecraft.m_91109_().m_118825_((MinecraftProfileTexture)map.get(type), type));
        }
        return Optional.empty();
    }

    public void render(StrawStatue entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        this.setModelProperties(entity);
        super.m_7392_((LivingEntity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public Vec3 getRenderOffset(StrawStatue entity, float partialTicks) {
        return entity.m_6047_() ? new Vec3(0.0, -0.125, 0.0) : super.m_7860_((Entity)entity, partialTicks);
    }

    private void setModelProperties(StrawStatue entity) {
        StrawStatueModel model = (StrawStatueModel)this.m_7200_();
        model.m_8009_(true);
        model.f_102809_.f_104207_ = entity.isModelPartShown(PlayerModelPart.HAT);
        model.f_103378_.f_104207_ = entity.isModelPartShown(PlayerModelPart.JACKET);
        model.f_103376_.f_104207_ = entity.isModelPartShown(PlayerModelPart.LEFT_PANTS_LEG);
        model.f_103377_.f_104207_ = entity.isModelPartShown(PlayerModelPart.RIGHT_PANTS_LEG);
        model.f_103374_.f_104207_ = model.slimLeftSleeve.f_104207_ = entity.isModelPartShown(PlayerModelPart.LEFT_SLEEVE);
        model.f_103375_.f_104207_ = model.slimRightSleeve.f_104207_ = entity.isModelPartShown(PlayerModelPart.RIGHT_SLEEVE);
        model.f_102817_ = entity.m_6047_();
    }

    public ResourceLocation getTextureLocation(StrawStatue entity) {
        return StrawStatueRenderer.getPlayerProfileTexture(entity, MinecraftProfileTexture.Type.SKIN).orElse(STRAW_STATUE_LOCATION);
    }

    protected void scale(StrawStatue livingEntity, PoseStack matrixStack, float partialTickTime) {
        float modelScale = Mth.m_14179_((float)partialTickTime, (float)livingEntity.entityScaleO, (float)livingEntity.getEntityScale());
        modelScale /= 3.0f;
        matrixStack.m_85841_(modelScale *= 0.9375f, modelScale, modelScale);
    }

    protected void setupRotations(StrawStatue entityLiving, PoseStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        float entityZRotation = Mth.m_14179_((float)partialTicks, (float)entityLiving.entityRotationsO.m_123158_(), (float)entityLiving.getEntityZRotation());
        float entityXRotation = Mth.m_14179_((float)partialTicks, (float)entityLiving.entityRotationsO.m_123156_(), (float)entityLiving.getEntityXRotation());
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f - entityZRotation));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - rotationYaw));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f - entityXRotation));
        float hurtAmount = (float)(entityLiving.m_9236_().m_46467_() - entityLiving.f_31528_) + partialTicks;
        if (hurtAmount < 5.0f) {
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14031_((float)(hurtAmount / 1.5f * (float)Math.PI)) * 3.0f));
        }
        if (StrawStatueRenderer.m_194453_((LivingEntity)entityLiving)) {
            matrixStack.m_85837_(0.0, (double)(entityLiving.m_20206_() - 0.0625f), 0.0);
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        }
    }

    protected boolean shouldShowName(StrawStatue entity) {
        double d = this.f_114476_.m_114471_((Entity)entity);
        float f = entity.m_6047_() ? 32.0f : 64.0f;
        return !(d >= (double)(f * f)) && entity.m_20151_();
    }

    @Nullable
    protected RenderType getRenderType(StrawStatue livingEntity, boolean bodyVisible, boolean translucent, boolean glowing) {
        if (!livingEntity.m_31677_()) {
            return super.m_7225_((LivingEntity)livingEntity, bodyVisible, translucent, glowing);
        }
        ResourceLocation resourceLocation = this.getTextureLocation(livingEntity);
        if (translucent) {
            return RenderType.m_110454_((ResourceLocation)resourceLocation, (boolean)false);
        }
        return bodyVisible ? RenderType.m_110443_((ResourceLocation)resourceLocation, (boolean)false) : null;
    }
}

