/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.decoration.ArmorStand;

public class StrawStatueModel
extends PlayerModel<StrawStatue> {
    public final ModelPart slimLeftArm;
    public final ModelPart slimRightArm;
    public final ModelPart slimLeftSleeve;
    public final ModelPart slimRightSleeve;
    private final ModelPart cloak;
    private boolean slim;

    public StrawStatueModel(ModelPart modelPart, boolean slim) {
        super(modelPart, slim);
        this.slimLeftArm = modelPart.m_171324_("slim_left_arm");
        this.slimRightArm = modelPart.m_171324_("slim_right_arm");
        this.slimLeftSleeve = modelPart.m_171324_("slim_left_sleeve");
        this.slimRightSleeve = modelPart.m_171324_("slim_right_sleeve");
        this.cloak = modelPart.m_171324_("cloak");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = PlayerModel.m_170825_((CubeDeformation)CubeDeformation.f_171458_, (boolean)false);
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("slim_left_arm", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)5.0f, (float)2.5f, (float)0.0f));
        partDefinition.m_171599_("slim_right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)-5.0f, (float)2.5f, (float)0.0f));
        partDefinition.m_171599_("slim_left_sleeve", CubeListBuilder.m_171558_().m_171514_(48, 48).m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, CubeDeformation.f_171458_.m_171469_(0.25f)), PartPose.m_171419_((float)5.0f, (float)2.5f, (float)0.0f));
        partDefinition.m_171599_("slim_right_sleeve", CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, CubeDeformation.f_171458_.m_171469_(0.25f)), PartPose.m_171419_((float)-5.0f, (float)2.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5607_() {
        return Iterables.concat((Iterable)super.m_5607_(), (Iterable)ImmutableList.of((Object)this.f_102809_));
    }

    protected Iterable<ModelPart> m_5608_() {
        return (Iterable)Stream.concat(StreamSupport.stream(super.m_5608_().spliterator(), false).filter(modelPart -> modelPart != this.f_102809_), Stream.of(this.slimLeftArm, this.slimRightArm, this.slimLeftSleeve, this.slimRightSleeve)).collect(ImmutableList.toImmutableList());
    }

    public void setupAnim(StrawStatue entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        StrawStatueModel.setupPoseAnim(this, entity);
        this.setupSlimAnim(entity);
        this.setupCloakAnim(entity);
        this.f_102809_.m_104315_(this.f_102808_);
        this.f_103376_.m_104315_(this.f_102814_);
        this.f_103377_.m_104315_(this.f_102813_);
        this.f_103374_.m_104315_(this.f_102812_);
        this.f_103375_.m_104315_(this.f_102811_);
        this.slimLeftSleeve.m_104315_(this.slimLeftArm);
        this.slimRightSleeve.m_104315_(this.slimRightArm);
        this.f_103378_.m_104315_(this.f_102810_);
        this.setupCrouchingAnimCape(entity);
    }

    private void setupSlimAnim(StrawStatue entity) {
        this.slimLeftArm.f_104207_ = true;
        this.f_102812_.f_104207_ = true;
        this.slimRightArm.f_104207_ = true;
        this.f_102811_.f_104207_ = true;
        this.slim = entity.slimArms();
        this.slimLeftArm.f_104203_ = (float)Math.PI / 180 * entity.m_31688_().m_123156_();
        this.slimLeftArm.f_104204_ = (float)Math.PI / 180 * entity.m_31688_().m_123157_();
        this.slimLeftArm.f_104205_ = (float)Math.PI / 180 * entity.m_31688_().m_123158_();
        this.slimRightArm.f_104203_ = (float)Math.PI / 180 * entity.m_31689_().m_123156_();
        this.slimRightArm.f_104204_ = (float)Math.PI / 180 * entity.m_31689_().m_123157_();
        this.slimRightArm.f_104205_ = (float)Math.PI / 180 * entity.m_31689_().m_123158_();
        if (this.slim) {
            this.f_103374_.f_104207_ = false;
            this.f_102812_.f_104207_ = false;
            this.f_103375_.f_104207_ = false;
            this.f_102811_.f_104207_ = false;
        } else {
            this.slimLeftSleeve.f_104207_ = false;
            this.slimLeftArm.f_104207_ = false;
            this.slimRightSleeve.f_104207_ = false;
            this.slimRightArm.f_104207_ = false;
        }
    }

    private void setupCloakAnim(StrawStatue entity) {
        this.cloak.f_104203_ = (float)(-Math.PI) / 180 * entity.m_31685_().m_123156_();
        this.cloak.f_104204_ = (float)Math.PI / 180 * entity.m_31685_().m_123157_();
        this.cloak.f_104205_ = (float)(-Math.PI) / 180 * entity.m_31685_().m_123158_();
    }

    private void setupCrouchingAnimCape(StrawStatue entity) {
        if (entity.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
            if (this.f_102817_) {
                this.cloak.f_104202_ = 1.4f;
                this.cloak.f_104201_ = 1.85f;
            } else {
                this.cloak.f_104202_ = 0.0f;
                this.cloak.f_104201_ = 0.0f;
            }
        } else if (this.f_102817_) {
            this.cloak.f_104202_ = 0.3f;
            this.cloak.f_104201_ = 0.8f;
        } else {
            this.cloak.f_104202_ = -1.1f;
            this.cloak.f_104201_ = -0.85f;
        }
    }

    public void m_6002_(HumanoidArm side, PoseStack poseStack) {
        ModelPart modelPart = this.m_102851_(side);
        if (this.slim) {
            float f = 0.5f * (float)(side == HumanoidArm.RIGHT ? 1 : -1);
            modelPart.f_104200_ += f;
            modelPart.m_104299_(poseStack);
            modelPart.f_104200_ -= f;
        } else {
            modelPart.m_104299_(poseStack);
        }
    }

    public static <T extends ArmorStand> void setupPoseAnim(HumanoidModel<T> model, T entity) {
        model.f_102808_.f_104203_ = (float)Math.PI / 180 * entity.m_31680_().m_123156_();
        model.f_102808_.f_104204_ = (float)Math.PI / 180 * entity.m_31680_().m_123157_();
        model.f_102808_.f_104205_ = (float)Math.PI / 180 * entity.m_31680_().m_123158_();
        model.f_102812_.f_104203_ = (float)Math.PI / 180 * entity.m_31688_().m_123156_();
        model.f_102812_.f_104204_ = (float)Math.PI / 180 * entity.m_31688_().m_123157_();
        model.f_102812_.f_104205_ = (float)Math.PI / 180 * entity.m_31688_().m_123158_();
        model.f_102811_.f_104203_ = (float)Math.PI / 180 * entity.m_31689_().m_123156_();
        model.f_102811_.f_104204_ = (float)Math.PI / 180 * entity.m_31689_().m_123157_();
        model.f_102811_.f_104205_ = (float)Math.PI / 180 * entity.m_31689_().m_123158_();
        model.f_102814_.f_104203_ = (float)Math.PI / 180 * entity.m_31691_().m_123156_();
        model.f_102814_.f_104204_ = (float)Math.PI / 180 * entity.m_31691_().m_123157_();
        model.f_102814_.f_104205_ = (float)Math.PI / 180 * entity.m_31691_().m_123158_();
        model.f_102813_.f_104203_ = (float)Math.PI / 180 * entity.m_31694_().m_123156_();
        model.f_102813_.f_104204_ = (float)Math.PI / 180 * entity.m_31694_().m_123157_();
        model.f_102813_.f_104205_ = (float)Math.PI / 180 * entity.m_31694_().m_123158_();
        StrawStatueModel.setupCrouchingAnim(model);
    }

    private static <T extends ArmorStand> void setupCrouchingAnim(HumanoidModel<T> model) {
        if (model.f_102817_) {
            model.f_102810_.f_104203_ = 0.5f;
            model.f_102811_.f_104203_ += 0.4f;
            model.f_102812_.f_104203_ += 0.4f;
            model.f_102813_.f_104202_ = 4.0f;
            model.f_102814_.f_104202_ = 4.0f;
            model.f_102813_.f_104201_ = 12.2f;
            model.f_102814_.f_104201_ = 12.2f;
            model.f_102808_.f_104201_ = 4.2f;
            model.f_102810_.f_104201_ = 3.2f;
            model.f_102812_.f_104201_ = 5.2f;
            model.f_102811_.f_104201_ = 5.2f;
        } else {
            model.f_102810_.f_104203_ = 0.0f;
            model.f_102813_.f_104202_ = 0.1f;
            model.f_102814_.f_104202_ = 0.1f;
            model.f_102813_.f_104201_ = 12.0f;
            model.f_102814_.f_104201_ = 12.0f;
            model.f_102808_.f_104201_ = 0.0f;
            model.f_102810_.f_104201_ = 0.0f;
            model.f_102812_.f_104201_ = 2.0f;
            model.f_102811_.f_104201_ = 2.0f;
        }
    }
}

