/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.mods.pop.client;

import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.mikey.mods.pop.client.pops.AnimTracker;
import pro.mikey.mods.pop.client.pops.IPopRender;
import pro.mikey.mods.pop.client.pops.PopManager;
import pro.mikey.mods.pop.data.PopData;

public class PopLayer
implements IGuiOverlay {
    public static final String LAYER_ID = "overlay-layer";
    private static final Logger LOGGER = LoggerFactory.getLogger(PopLayer.class);
    private PopData currentPop = null;

    public PopLayer() {
        LOGGER.info("Initializing Pop Layer");
    }

    @Nullable
    private PopData getNextOrCurrent() {
        if (this.currentPop == null) {
            PopManager popManager = PopManager.get();
            this.currentPop = popManager.hasNext() ? popManager.next() : null;
        }
        return this.currentPop;
    }

    public void render(ForgeGui forgeGui, GuiGraphics guiGraphics, float partialTicks, int screenWidth, int screenHeigh) {
        PopData pop = this.getNextOrCurrent();
        if (pop == null) {
            return;
        }
        IPopRender renderer = pop.renderer();
        AnimTracker tracker = pop.tracker();
        if (tracker.isDone()) {
            this.currentPop = null;
            return;
        }
        renderer.render(this.currentPop, guiGraphics, partialTicks);
    }
}

