/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.mods.pop;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.server.command.EnumArgument;
import pro.mikey.mods.pop.data.Placement;
import pro.mikey.mods.pop.net.ClientCreatePopPacket;
import pro.mikey.mods.pop.net.Networking;

public class PopCommands {
    public static SimpleCommandExceptionType NO_TARGETS = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"No targets found"));

    public static LiteralArgumentBuilder<CommandSourceStack> register(CommandBuildContext context) {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"pop").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"create").requires(stack -> stack.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"placement", (ArgumentType)EnumArgument.enumArgument(Placement.class)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"content", (ArgumentType)ComponentArgument.m_87114_()).executes(PopCommands::sendPop))).then(Commands.m_82129_((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(PopCommands::sendPop))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"content", (ArgumentType)ComponentArgument.m_87114_()).executes(PopCommands::sendPop))).then(Commands.m_82129_((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(PopCommands::sendPop)))));
    }

    private static int sendPop(CommandContext<CommandSourceStack> stack) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(stack, (String)"target");
        if (targets.isEmpty()) {
            throw NO_TARGETS.create();
        }
        int duration = IntegerArgumentType.getInteger(stack, (String)"duration");
        Placement placement = Placement.MIDDLE_CENTER;
        try {
            placement = (Placement)((Object)stack.getArgument("placement", Placement.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        MutableComponent content = Component.m_237113_((String)"");
        try {
            content = (Component)stack.getArgument("content", Component.class);
        }
        catch (IllegalArgumentException ignored) {
            try {
                content = Component.m_237113_((String)StringArgumentType.getString(stack, (String)"text"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        ClientCreatePopPacket packet = new ClientCreatePopPacket((Component)content, placement, duration);
        for (ServerPlayer target : targets) {
            Networking.sendTo(packet, target);
        }
        return 0;
    }
}

