/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.mixins.ticketsystem.ticketpropagator;

import com.ishland.vmp.mixins.access.IChunkHolder;
import com.ishland.vmp.mixins.access.IChunkTicket;
import io.papermc.paper.util.misc.Delayed8WayDistancePropagator2D;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.Ticket;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.thread.ProcessorHandle;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DistanceManager.class})
public abstract class MixinChunkTicketManager {
    @Mutable
    @Shadow
    @Final
    private DistanceManager.ChunkTicketTracker f_140762_;
    @Shadow
    @Final
    private DistanceManager.PlayerTicketTracker f_140764_;
    @Shadow
    @Final
    private Set<ChunkHolder> f_140765_;
    @Shadow
    @Final
    private Executor f_140770_;
    @Shadow
    @Final
    private LongSet f_140769_;
    @Shadow
    @Final
    private ProcessorHandle<ChunkTaskPriorityQueueSorter.Release> f_140768_;
    @Shadow
    private long f_140771_;
    @Shadow
    @Final
    private Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> f_140761_;
    @Unique
    protected Long2IntLinkedOpenHashMap ticketLevelUpdates;
    @Unique
    protected Delayed8WayDistancePropagator2D ticketLevelPropagator;
    @Unique
    private ObjectArrayFIFOQueue<ChunkHolder> pendingChunkHolderUpdates;

    @Shadow
    @Nullable
    protected abstract ChunkHolder m_7316_(long var1);

    @Shadow
    @Nullable
    protected abstract ChunkHolder m_7288_(long var1, int var3, @Nullable ChunkHolder var4, int var5);

    @Shadow
    protected abstract SortedArraySet<Ticket<?>> m_140857_(long var1);

    @Shadow
    protected static int m_140797_(SortedArraySet<Ticket<?>> sortedArraySet) {
        throw new AbstractMethodError();
    }

    @Unique
    private static int convertBetweenTicketLevels(int level) {
        return ChunkLevel.f_286967_ - level + 1;
    }

    @Unique
    protected final void updateTicketLevel(long coordinate, int ticketLevel) {
        if (ticketLevel > ChunkLevel.f_286967_) {
            this.ticketLevelPropagator.removeSource(coordinate);
        } else {
            this.ticketLevelPropagator.setSource(coordinate, MixinChunkTicketManager.convertBetweenTicketLevels(ticketLevel));
        }
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(Executor workerExecutor, Executor mainThreadExecutor, CallbackInfo ci) {
        this.f_140762_ = null;
        this.ticketLevelUpdates = new Long2IntLinkedOpenHashMap(){

            protected void rehash(int newN) {
                if (newN < this.n) {
                    return;
                }
                super.rehash(newN);
            }
        };
        this.ticketLevelPropagator = new Delayed8WayDistancePropagator2D((coordinate, oldLevel, newLevel) -> this.ticketLevelUpdates.putAndMoveToLast(coordinate, MixinChunkTicketManager.convertBetweenTicketLevels(newLevel)));
        this.pendingChunkHolderUpdates = new ObjectArrayFIFOQueue();
    }

    @Redirect(method={"purge", "addTicket(JLnet/minecraft/server/world/ChunkTicket;)V", "removeTicket(JLnet/minecraft/server/world/ChunkTicket;)V", "removePersistentTickets"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/world/ChunkTicketManager$TicketDistanceLevelPropagator;updateLevel(JIZ)V"), require=3, expect=3)
    private void redirectUpdate(DistanceManager.ChunkTicketTracker instance, long l, int i, boolean b) {
        this.updateTicketLevel(l, i);
    }

    @Overwrite
    public void m_140776_() {
        ++this.f_140771_;
        Predicate<Ticket> predicate = chunkTicket -> ((IChunkTicket)chunkTicket).invokeIsExpired1(this.f_140771_);
        ObjectIterator objectIterator = this.f_140761_.long2ObjectEntrySet().fastIterator();
        while (objectIterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectIterator.next();
            if (((SortedArraySet)entry.getValue()).removeIf(predicate)) {
                this.updateTicketLevel(entry.getLongKey(), MixinChunkTicketManager.m_140797_((SortedArraySet)entry.getValue()));
            }
            if (!((SortedArraySet)entry.getValue()).isEmpty()) continue;
            objectIterator.remove();
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/world/ChunkTicketManager$TicketDistanceLevelPropagator;update(I)I"))
    public int tickTickets(DistanceManager.ChunkTicketTracker __, int distance, ChunkMap threadedAnvilChunkStorage) {
        boolean hasUpdates = this.ticketLevelPropagator.propagateUpdates();
        if (hasUpdates) {
            // empty if block
        }
        while (!this.ticketLevelUpdates.isEmpty()) {
            ChunkHolder holder;
            int currentLevel;
            hasUpdates = true;
            long key = this.ticketLevelUpdates.firstLongKey();
            int newLevel = this.ticketLevelUpdates.removeFirstInt();
            if (newLevel == (currentLevel = (holder = this.m_7316_(key)) == null ? ChunkLevel.f_286967_ + 1 : holder.m_140093_())) continue;
            if ((holder = this.m_7288_(key, newLevel, holder, currentLevel)) == null) {
                if (newLevel > ChunkLevel.f_286967_) continue;
                throw new IllegalStateException("Chunk holder not created");
            }
            this.pendingChunkHolderUpdates.enqueue((Object)holder);
        }
        while (!this.pendingChunkHolderUpdates.isEmpty()) {
            ((IChunkHolder)this.pendingChunkHolderUpdates.dequeue()).invokeTick1(threadedAnvilChunkStorage, this.f_140770_);
        }
        return hasUpdates ? distance - 1 : distance;
    }
}

