/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.mixins.playerwatching;

import com.google.common.collect.ImmutableList;
import com.ishland.vmp.common.chunkwatching.AreaPlayerChunkWatchingManager;
import java.util.List;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkMap.class})
public abstract class MixinThreadedAnvilChunkStorage {
    @Shadow
    @Final
    private PlayerMap f_140149_;
    @Shadow
    private int f_140126_;
    @Shadow
    @Final
    private static Logger f_140128_;
    @Shadow
    @Final
    private ChunkMap.DistanceManager f_140145_;

    @Shadow
    protected abstract boolean m_183751_(ServerPlayer var1, ChunkPos var2);

    @Shadow
    protected abstract void m_183754_(ServerPlayer var1, ChunkPos var2, MutableObject<ClientboundLevelChunkWithLightPacket> var3, boolean var4, boolean var5);

    @Shadow
    protected abstract SectionPos m_140373_(ServerPlayer var1);

    @Redirect(method={"<init>"}, at=@At(value="NEW", target="net/minecraft/server/world/PlayerChunkWatchingManager"))
    private PlayerMap redirectNewPlayerChunkWatchingManager() {
        return new AreaPlayerChunkWatchingManager((player, chunkX, chunkZ) -> this.m_183754_(player, new ChunkPos(chunkX, chunkZ), (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), false, true), (player, chunkX, chunkZ) -> this.m_183754_(player, new ChunkPos(chunkX, chunkZ), (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), true, false), (ChunkMap)this);
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void onTick(CallbackInfo ci) {
        PlayerMap playerMap = this.f_140149_;
        if (!(playerMap instanceof AreaPlayerChunkWatchingManager)) {
            throw new IllegalArgumentException("Not an instance of AreaPlayerChunkWatchingManager");
        }
        AreaPlayerChunkWatchingManager areaPlayerChunkWatchingManager = (AreaPlayerChunkWatchingManager)playerMap;
        areaPlayerChunkWatchingManager.tick();
    }

    @Inject(method={"setViewDistance"}, at={@At(value="RETURN")})
    private void onSetViewDistance(CallbackInfo ci) {
        PlayerMap playerMap = this.f_140149_;
        if (!(playerMap instanceof AreaPlayerChunkWatchingManager)) {
            throw new IllegalArgumentException("Not an instance of AreaPlayerChunkWatchingManager");
        }
        AreaPlayerChunkWatchingManager areaPlayerChunkWatchingManager = (AreaPlayerChunkWatchingManager)playerMap;
        f_140128_.info("Changing watch distance to {}", (Object)this.f_140126_);
        areaPlayerChunkWatchingManager.setWatchDistance(this.f_140126_);
    }

    @Overwrite
    public List<ServerPlayer> m_183262_(ChunkPos chunkPos, boolean onlyOnWatchDistanceEdge) {
        AreaPlayerChunkWatchingManager watchingManager = (AreaPlayerChunkWatchingManager)this.f_140149_;
        if (!onlyOnWatchDistanceEdge) {
            return (List)((Object)watchingManager.m_183926_(chunkPos.m_45588_()));
        }
        Object[] set = watchingManager.getPlayersWatchingChunkArray(chunkPos.m_45588_());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object __player : set) {
            ServerPlayer serverPlayerEntity;
            SectionPos watchedPos;
            int chebyshevDistance;
            if (!(__player instanceof ServerPlayer) || (chebyshevDistance = Math.max(Math.abs((watchedPos = (serverPlayerEntity = (ServerPlayer)__player).m_8965_()).m_123170_() - chunkPos.f_45578_), Math.abs(watchedPos.m_123222_() - chunkPos.f_45579_))) > this.f_140126_ || onlyOnWatchDistanceEdge && chebyshevDistance != this.f_140126_) continue;
            builder.add((Object)serverPlayerEntity);
        }
        return builder.build();
    }

    @Overwrite
    public List<ServerPlayer> m_183888_(ChunkPos pos) {
        long l = pos.m_45588_();
        if (!this.f_140145_.m_140847_(l)) {
            return List.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object __player : ((AreaPlayerChunkWatchingManager)this.f_140149_).getPlayersWatchingChunkArray(l)) {
            ServerPlayer serverPlayerEntity;
            if (!(__player instanceof ServerPlayer) || !this.m_183751_(serverPlayerEntity = (ServerPlayer)__player, pos)) continue;
            builder.add((Object)serverPlayerEntity);
        }
        return builder.build();
    }

    @Overwrite
    public boolean m_183879_(ChunkPos pos) {
        long l = pos.m_45588_();
        if (!this.f_140145_.m_140847_(l)) {
            return false;
        }
        for (Object __player : ((AreaPlayerChunkWatchingManager)this.f_140149_).getPlayersWatchingChunkArray(l)) {
            ServerPlayer serverPlayerEntity;
            if (!(__player instanceof ServerPlayer) || !this.m_183751_(serverPlayerEntity = (ServerPlayer)__player, pos)) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"handlePlayerAddedOrRemoved"}, at={@At(value="HEAD")})
    private void onHandlePlayerAddedOrRemoved(ServerPlayer player, boolean added, CallbackInfo ci) {
        if (added) {
            this.m_140373_(player);
        }
    }
}

