/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.mixins.networking.eventloops;

import com.ishland.vmp.common.networking.eventloops.VMPEventLoops;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Connection.class})
public class MixinClientConnection {
    @Shadow
    private Channel f_129468_;
    @Unique
    private boolean isReregistering = false;
    @Unique
    private EventLoopGroup pendingReregistration = null;

    @Redirect(method={"setState"}, at=@At(value="INVOKE", target="Lio/netty/channel/EventLoop;execute(Ljava/lang/Runnable;)V"))
    private void onSetState(EventLoop eventLoop, Runnable r, ConnectionProtocol state) {
        if (this.f_129468_.eventLoop() == eventLoop) {
            EventLoopGroup group = VMPEventLoops.getEventLoopGroup(this.f_129468_, state);
            if (group != null) {
                this.reregister(group);
            } else {
                eventLoop.execute(r);
            }
        } else {
            eventLoop.execute(r);
        }
    }

    private synchronized void reregister(EventLoopGroup group) {
        if (this.isReregistering) {
            this.pendingReregistration = group;
            return;
        }
        ChannelPromise promise = this.f_129468_.newPromise();
        this.f_129468_.config().setAutoRead(false);
        this.isReregistering = true;
        this.f_129468_.deregister().addListener(future -> {
            if (future.isSuccess()) {
                group.register(promise);
            } else {
                promise.setFailure((Throwable)new RuntimeException("Failed to deregister channel", future.cause()));
            }
        });
        promise.addListener(future -> {
            this.isReregistering = false;
            if (future.isSuccess()) {
                this.f_129468_.config().setAutoRead(true);
            } else {
                this.f_129468_.pipeline().fireExceptionCaught(future.cause());
            }
            if (this.pendingReregistration != null) {
                this.reregister(this.pendingReregistration);
                this.pendingReregistration = null;
            }
        });
    }
}

