/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.mixins.chunk.loading.async_chunk_on_player_login;

import com.ishland.vmp.common.chunk.loading.async_chunks_on_player_login.IAsyncChunkPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public class MixinServerPlayerEntity
implements IAsyncChunkPlayer {
    @Unique
    private CompoundTag playerData = null;
    @Unique
    private boolean chunkLoadCompleted = true;

    @Override
    public void markPlayerForAsyncChunkLoad() {
        this.chunkLoadCompleted = false;
    }

    @Override
    public void setPlayerData(CompoundTag nbtCompound) {
        this.playerData = nbtCompound;
    }

    @Override
    public CompoundTag getPlayerData() {
        return this.playerData;
    }

    @Override
    public boolean isChunkLoadCompleted() {
        return this.chunkLoadCompleted;
    }

    @Override
    public void onChunkLoadComplete() {
        this.chunkLoadCompleted = true;
    }

    @Inject(method={"playerTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void suppressActionsDuringChunkLoad(CallbackInfo ci) {
        if (!this.chunkLoadCompleted) {
            ci.cancel();
        }
    }
}

