/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.common.chunkwatching;

import com.ishland.vmp.common.chunk.sending.PlayerChunkSendingSystem;
import com.ishland.vmp.common.maps.AreaMap;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;

public class AreaPlayerChunkWatchingManager
extends PlayerMap {
    public static final int GENERAL_PLAYER_AREA_MAP_DISTANCE = (int)Math.ceil((double)Arrays.stream(MobCategory.values()).mapToInt(MobCategory::m_21611_).reduce(0, Math::max) / 16.0);
    private final AreaMap<ServerPlayer> playerAreaMap;
    private final AreaMap<ServerPlayer> generalPlayerAreaMap = new AreaMap();
    private final Object2LongOpenHashMap<ServerPlayer> positions = new Object2LongOpenHashMap();
    private final PlayerChunkSendingSystem playerChunkSendingSystem;
    private Listener addListener = null;
    private Listener removeListener = null;
    private int watchDistance = 5;

    public AreaPlayerChunkWatchingManager() {
        this(null, null, null);
    }

    public AreaPlayerChunkWatchingManager(Listener addListener, Listener removeListener, ChunkMap tacs) {
        this.addListener = addListener;
        this.removeListener = removeListener;
        if (tacs != null) {
            this.playerChunkSendingSystem = new PlayerChunkSendingSystem(tacs);
            this.addListener = null;
            this.removeListener = null;
            this.playerAreaMap = new AreaMap(null, null, false);
        } else {
            this.playerChunkSendingSystem = null;
            this.playerAreaMap = new AreaMap<ServerPlayer>((object, x, z) -> {
                if (this.addListener != null) {
                    this.addListener.accept((ServerPlayer)object, x, z);
                }
            }, (object, x, z) -> {
                if (this.removeListener != null) {
                    this.removeListener.accept((ServerPlayer)object, x, z);
                }
            }, true);
        }
    }

    public void tick() {
        if (this.playerChunkSendingSystem != null) {
            this.playerChunkSendingSystem.tick();
        }
    }

    public void onChunkLoaded(long pos) {
        if (this.playerChunkSendingSystem != null) {
            this.playerChunkSendingSystem.onChunkLoaded(pos);
        }
    }

    public void setWatchDistance(int watchDistance) {
        this.watchDistance = Math.max(3, watchDistance);
        ObjectIterator iterator = this.positions.object2LongEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Object2LongMap.Entry entry = (Object2LongMap.Entry)iterator.next();
            this.playerAreaMap.update((ServerPlayer)entry.getKey(), MCUtil.getCoordinateX(entry.getLongValue()), MCUtil.getCoordinateZ(entry.getLongValue()), this.watchDistance);
            this.generalPlayerAreaMap.update((ServerPlayer)entry.getKey(), MCUtil.getCoordinateX(entry.getLongValue()), MCUtil.getCoordinateZ(entry.getLongValue()), GENERAL_PLAYER_AREA_MAP_DISTANCE);
        }
        if (this.playerChunkSendingSystem != null) {
            this.playerChunkSendingSystem.setWatchDistance(watchDistance);
        }
    }

    public int getWatchDistance() {
        return this.watchDistance;
    }

    public Set<ServerPlayer> m_183926_(long l) {
        return this.playerAreaMap.getObjectsInRange(l);
    }

    public Object[] getPlayersWatchingChunkArray(long coordinateKey) {
        return this.playerAreaMap.getObjectsInRangeArray(coordinateKey);
    }

    public Object[] getPlayersInGeneralAreaMap(long coordinateKey) {
        return this.generalPlayerAreaMap.getObjectsInRangeArray(coordinateKey);
    }

    public void m_8252_(long l, ServerPlayer player, boolean watchDisabled) {
        super.m_8252_(l, player, watchDisabled);
        int x = ChunkPos.m_45592_((long)l);
        int z = ChunkPos.m_45602_((long)l);
        this.playerAreaMap.add(player, x, z, this.watchDistance);
        this.generalPlayerAreaMap.add(player, x, z, GENERAL_PLAYER_AREA_MAP_DISTANCE);
        this.positions.put((Object)player, MCUtil.getCoordinateKey(x, z));
        if (this.playerChunkSendingSystem != null) {
            this.playerChunkSendingSystem.add(player, x, z);
        }
    }

    public void m_8249_(long l, ServerPlayer player) {
        super.m_8249_(l, player);
        this.playerAreaMap.remove(player);
        this.generalPlayerAreaMap.remove(player);
        this.positions.removeLong((Object)player);
        if (this.playerChunkSendingSystem != null) {
            this.playerChunkSendingSystem.remove(player);
        }
    }

    public void m_8256_(ServerPlayer player) {
        super.m_8256_(player);
    }

    public void m_8258_(ServerPlayer player) {
        super.m_8258_(player);
    }

    public boolean m_8260_(ServerPlayer player) {
        return super.m_8260_(player);
    }

    public boolean m_8262_(ServerPlayer player) {
        return super.m_8262_(player);
    }

    public void m_8245_(long prevPos, long currentPos, ServerPlayer player) {
        int x = ChunkPos.m_45592_((long)currentPos);
        int z = ChunkPos.m_45602_((long)currentPos);
        this.playerAreaMap.update(player, x, z, this.watchDistance);
        this.generalPlayerAreaMap.update(player, x, z, GENERAL_PLAYER_AREA_MAP_DISTANCE);
        this.positions.put((Object)player, MCUtil.getCoordinateKey(x, z));
        if (this.playerChunkSendingSystem != null) {
            this.playerChunkSendingSystem.movePlayer(player, currentPos);
        }
    }

    public static interface Listener {
        public void accept(ServerPlayer var1, int var2, int var3);
    }
}

