/*
 * Decompiled with CFR 0.152.
 */
package net.glad0s.bobberdetector.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.utility.FilesHelper;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Map;
import java.util.function.BiConsumer;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.glad0s.bobberdetector.BobberDetector;
import net.glad0s.bobberdetector.datagen.forge.BDDatagenImpl;
import net.glad0s.bobberdetector.register.BDPonders;

public class BDDatagen {
    private static final CreateRegistrate REGISTRATE = BobberDetector.registrate();

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addExtraRegistrateData() {
        BDDatagenImpl.addExtraRegistrateData();
    }

    protected static void provideDefaultLang(String fileName, BiConsumer<String, String> consumer) {
        String path = "assets/bobberdetector/lang/default/" + fileName + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource((String)path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(key, value);
        }
    }

    protected static void providePonderLang(BiConsumer<String, String> consumer) {
        PonderIndex.addPlugin((PonderPlugin)new BDPonders());
        PonderIndex.getLangAccess().provideLang("bobberdetector", consumer);
    }
}

