/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_spawner.content.components;

import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class SpawnerRecipeOutput {
    @Nullable
    private EntityType<?> mob;
    private static final String RANDOM_KEY = "random";
    public static final SpawnerRecipeOutput EMPTY = new SpawnerRecipeOutput();

    SpawnerRecipeOutput(@Nullable EntityType<?> mobEntity) {
        this.mob = mobEntity;
    }

    public SpawnerRecipeOutput() {
        this.mob = null;
    }

    public static SpawnerRecipeOutput fromJson(String mob) {
        if (mob == null || mob.equals(RANDOM_KEY)) {
            return new SpawnerRecipeOutput();
        }
        ResourceLocation mobResourceLocation = new ResourceLocation(mob);
        EntityType mobEntity = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(mobResourceLocation);
        if (mobEntity == null) {
            return new SpawnerRecipeOutput();
        }
        return new SpawnerRecipeOutput(mobEntity);
    }

    public static SpawnerRecipeOutput fromNetwork(FriendlyByteBuf buffer) {
        String mobId = buffer.m_130277_();
        if (mobId.equals(RANDOM_KEY)) {
            return new SpawnerRecipeOutput();
        }
        ResourceLocation mobResourceLocation = new ResourceLocation(mobId);
        EntityType mobEntity = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(mobResourceLocation);
        if (mobEntity == null) {
            return new SpawnerRecipeOutput();
        }
        return new SpawnerRecipeOutput(mobEntity);
    }

    public static SpawnerRecipeOutput of(ResourceLocation mobResourceLocation) {
        if (mobResourceLocation == null) {
            return new SpawnerRecipeOutput();
        }
        EntityType mobEntity = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(mobResourceLocation);
        return new SpawnerRecipeOutput(mobEntity);
    }

    public static SpawnerRecipeOutput of(String mobString) {
        return SpawnerRecipeOutput.of(ResourceLocation.m_135820_((String)mobString));
    }

    public String toJson() {
        assert (this.mob != null);
        if (this.mob == null) {
            return RANDOM_KEY;
        }
        return ForgeRegistries.ENTITY_TYPES.getKey(this.mob).toString();
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        if (this.mob == null) {
            buffer.m_130070_(RANDOM_KEY);
            return;
        }
        ResourceLocation mobResourceLocation = ForgeRegistries.ENTITY_TYPES.getKey(this.mob);
        assert (mobResourceLocation != null);
        buffer.m_130070_(mobResourceLocation.toString());
    }

    public EntityType<?> getMob() {
        return this.mob;
    }

    public String serialize() {
        if (this.mob == null) {
            return "";
        }
        return this.mob.m_147048_();
    }
}

