/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.security;

import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.client.ClientUtil;
import com.jaquadro.minecraft.storagedrawers.security.DefaultSecurityProvider;
import com.mojang.authlib.GameProfile;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class SecurityManager {
    private static final ISecurityProvider defaultProvider = new DefaultSecurityProvider();

    public static boolean hasOwnership(GameProfile profile, IProtectable target) {
        if (target == null || profile == null) {
            return false;
        }
        ISecurityProvider provider = target.getSecurityProvider();
        if (provider == null) {
            provider = defaultProvider;
        }
        return provider.hasOwnership(profile, target);
    }

    public static boolean hasAccess(Player player, IProtectable target) {
        if (target == null || player == null) {
            return false;
        }
        ISecurityProvider provider = target.getSecurityProvider();
        if (provider == null) {
            provider = defaultProvider;
        }
        return provider.hasAccess(player, target);
    }

    public static boolean clientHasAccess(IProtectable target) {
        if (!FMLEnvironment.dist.isClient()) {
            return false;
        }
        return SecurityManager.hasAccess(ClientUtil.getLocalPlayer(), target);
    }
}

