/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.events.behaviors;

import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.amendments.common.block.LiquidCauldronBlock;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.BlockUse;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.amendments.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CauldronConversion
implements BlockUse {
    @Override
    public boolean isEnabled() {
        return CommonConfigs.LIQUID_CAULDRON.get();
    }

    @Override
    public boolean appliesToBlock(Block block) {
        return Blocks.f_50256_ == block;
    }

    @Override
    public InteractionResult tryPerformingAction(BlockState state, BlockPos pos, Level level, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit) {
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        return CauldronConversion.convert(state, pos, level, player, hand, stack, true);
    }

    public static InteractionResult convert(BlockState state, BlockPos pos, Level level, Player player, InteractionHand hand, ItemStack stack, boolean checkCauldronInteractions) {
        BlockEntity blockEntity;
        BlockState newState = CauldronConversion.getNewState(pos, level, stack, checkCauldronInteractions);
        if (newState != null && level.m_46597_(pos, newState) && (blockEntity = level.m_7702_(pos)) instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
            if (te.handleInteraction(player, hand)) {
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            level.m_46597_(pos, state);
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public static BlockState getNewState(BlockPos pos, Level level, ItemStack stack) {
        return CauldronConversion.getNewState(pos, level, stack, true);
    }

    @Nullable
    public static BlockState getNewState(BlockPos pos, Level level, ItemStack stack, boolean checkCauldronInteractions) {
        Pair fluid = SoftFluidStack.fromItem((ItemStack)stack);
        if (fluid == null) {
            return null;
        }
        SoftFluidStack first = (SoftFluidStack)fluid.getFirst();
        if (checkCauldronInteractions && ((CauldronBlock)Blocks.f_50256_).f_151943_.containsKey(stack.m_41720_()) && !first.is((Holder)BuiltInSoftFluids.POTION)) {
            return null;
        }
        if (CompatHandler.RATS && stack.m_150930_(Items.f_42455_)) {
            return null;
        }
        return CauldronConversion.getNewState(pos, level, first);
    }

    @Nullable
    public static BlockState getNewState(BlockPos pos, Level level, SoftFluidStack fluid) {
        if (fluid != null && !fluid.is(ModTags.CAULDRON_BLACKLIST)) {
            BlockState newState;
            if (fluid.is(ModRegistry.DYE_SOFT_FLUID)) {
                newState = ModRegistry.DYE_CAULDRON.get().m_49966_();
            } else {
                BlockPos belowPos = pos.m_7495_();
                newState = (BlockState)ModRegistry.LIQUID_CAULDRON.get().m_49966_().m_61124_((Property)LiquidCauldronBlock.BOILING, (Comparable)Boolean.valueOf(LiquidCauldronBlock.shouldBoil(level.m_8055_(belowPos), fluid, (LevelAccessor)level, belowPos)));
            }
            return newState;
        }
        return null;
    }
}

