/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.composite;

import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.box.PackageStyles;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.extensions.IForgeItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import ru.zznty.create_factory_logistics.FactoryItems;
import ru.zznty.create_factory_logistics.logistics.composite.CompositePackageEntity;
import ru.zznty.create_factory_logistics.logistics.composite.CompositePackageRenderer;

public class CompositePackageItem
extends PackageItem {
    public static final String CHILDREN_TAG = "Children";

    public CompositePackageItem(Item.Properties properties) {
        super(properties, (PackageStyles.PackageStyle)PackageStyles.STYLES.get(1));
        PackageStyles.ALL_BOXES.remove((Object)this);
        PackageStyles.STANDARD_BOXES.remove((Object)this);
    }

    public Entity createEntity(Level world, Entity location, ItemStack itemstack) {
        return CompositePackageEntity.fromDroppedItem(world, location, itemstack);
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        for (ItemStack child : CompositePackageItem.getChildren(pStack)) {
            child.m_41720_().m_7373_(child, pLevel, pTooltipComponents, pIsAdvanced);
        }
    }

    public InteractionResultHolder<ItemStack> open(Level worldIn, Player playerIn, InteractionHand handIn) {
        InteractionResultHolder resultHolder = super.open(worldIn, playerIn, handIn);
        if (resultHolder.m_19089_() == InteractionResult.SUCCESS && !worldIn.m_5776_()) {
            for (ItemStack child : CompositePackageItem.getChildren((ItemStack)resultHolder.m_19095_())) {
                playerIn.m_150109_().m_150079_(child);
            }
        }
        return resultHolder;
    }

    public static List<ItemStack> getChildren(ItemStack stack) {
        if (!stack.m_41782_()) {
            return List.of();
        }
        return NBTHelper.readCompoundList((ListTag)stack.m_41783_().m_128437_(CHILDREN_TAG, 10), ItemStack::m_41712_);
    }

    public static ItemStack of(ItemStack box, List<ItemStack> children) {
        ItemStack compositeBox = new ItemStack(FactoryItems.COMPOSITE_PACKAGE);
        if (box.m_41782_()) {
            compositeBox.m_41751_(box.m_41783_().m_6426_());
        }
        children = new ArrayList<ItemStack>(children);
        ItemStackHandler contents = PackageItem.getContents((ItemStack)compositeBox);
        ListTag listTag = compositeBox.m_41784_().m_128437_(CHILDREN_TAG, 10);
        if (!listTag.isEmpty()) {
            children.addAll(CompositePackageItem.getChildren(compositeBox));
            listTag.clear();
        }
        for (int i = 0; i < children.size(); ++i) {
            ItemStack child = children.get(i);
            if (!(child.m_41720_() instanceof CompositePackageItem)) continue;
            children.addAll(CompositePackageItem.getChildren(child));
            child.m_41784_().m_128473_(CHILDREN_TAG);
            ItemStackHandler childContents = PackageItem.getContents((ItemStack)child);
            boolean emptied = true;
            for (int slot = 0; slot < childContents.getSlots(); ++slot) {
                ItemStack reminder = ItemHandlerHelper.insertItemStacked((IItemHandler)contents, (ItemStack)childContents.getStackInSlot(slot), (boolean)false);
                childContents.setStackInSlot(slot, reminder);
                if (reminder.m_41619_()) continue;
                emptied = false;
            }
            if (!emptied) {
                children.add(PackageItem.containing((ItemStackHandler)childContents));
            }
            children.remove(i);
            --i;
        }
        compositeBox.m_41700_(CHILDREN_TAG, (Tag)NBTHelper.writeCompoundList(children, IForgeItemStack::serializeNBT));
        return compositeBox;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new CompositePackageRenderer()));
        super.initializeClient(consumer);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_().m_6144_()) {
            return this.open(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
        }
        Vec3 point = context.m_43720_();
        float h = (float)this.style.height() / 16.0f;
        float r = (float)this.style.width() / 2.0f / 16.0f;
        if (context.m_43719_() == Direction.DOWN) {
            point = point.m_82492_(0.0, (double)(h + 0.25f), 0.0);
        } else if (context.m_43719_().m_122434_().m_122479_()) {
            point = point.m_82549_(Vec3.m_82528_((Vec3i)context.m_43719_().m_122436_()).m_82490_((double)r));
        }
        AABB scanBB = new AABB(point, point).m_82377_((double)r, 0.0, (double)r).m_82363_(0.0, (double)h, 0.0);
        Level world = context.m_43725_();
        if (!world.m_142425_((EntityTypeTest)AllEntityTypes.PACKAGE.get(), scanBB, e -> true).isEmpty()) {
            return super.m_6225_(context);
        }
        CompositePackageEntity packageEntity = new CompositePackageEntity(world, point.f_82479_, point.f_82480_, point.f_82481_);
        ItemStack itemInHand = context.m_43722_();
        packageEntity.setBox(itemInHand.m_41777_());
        world.m_7967_((Entity)packageEntity);
        itemInHand.m_41774_(1);
        return InteractionResult.SUCCESS;
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int ticks) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int i = this.m_8105_(stack) - ticks;
        if (i < 0) {
            return;
        }
        float f = CompositePackageItem.getPackageVelocity((int)i);
        if ((double)f < 0.1) {
            return;
        }
        if (world.f_46443_) {
            return;
        }
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.5f, 0.5f);
        ItemStack copy = stack.m_41777_();
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        Vec3 vec = new Vec3(entity.m_20185_(), entity.m_20186_() + entity.m_20191_().m_82376_() / 2.0, entity.m_20189_());
        Vec3 motion = entity.m_20154_().m_82490_((double)(f * 2.0f));
        vec = vec.m_82549_(motion);
        CompositePackageEntity packageEntity = new CompositePackageEntity(world, vec.f_82479_, vec.f_82480_, vec.f_82481_);
        packageEntity.setBox(copy);
        packageEntity.m_20256_(motion);
        packageEntity.tossedBy = new WeakReference<Player>(player);
        world.m_7967_((Entity)packageEntity);
    }
}

