/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.composite;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.logistics.box.PackageEntity;
import com.simibubi.create.content.logistics.chute.ChuteBlock;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.network.PlayMessages;
import ru.zznty.create_factory_logistics.FactoryEntities;
import ru.zznty.create_factory_logistics.logistics.composite.CompositePackageItem;
import ru.zznty.create_factory_logistics.mixin.accessor.PackageEntityAccessor;

public class CompositePackageEntity
extends PackageEntity
implements IHaveGoggleInformation {
    public List<ItemStack> children = List.of();

    public CompositePackageEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public CompositePackageEntity(Level worldIn, double x, double y, double z) {
        this((EntityType)FactoryEntities.COMPOSITE_PACKAGE.get(), worldIn);
        this.m_6034_(x, y, z);
        this.m_6210_();
    }

    public void setBox(ItemStack box) {
        super.setBox(box);
        this.children = CompositePackageItem.getChildren(box);
    }

    protected void m_6668_(DamageSource pDamageSource) {
        super.m_6668_(pDamageSource);
        for (ItemStack child : this.children) {
            ItemEntity jarEntity = new ItemEntity(this.m_9236_(), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, child);
            this.m_9236_().m_7967_((Entity)jarEntity);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip);
    }

    private boolean containedFluidTooltip(List<Component> originalTooltip) {
        ArrayList tooltip = new ArrayList();
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        CreateLang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        boolean isEmpty = true;
        for (ItemStack child : this.children) {
            FluidStack fluidStack;
            Optional fluidHandler = FluidUtil.getFluidHandler((ItemStack)child).resolve();
            if (fluidHandler.isEmpty() || (fluidStack = ((IFluidHandlerItem)fluidHandler.get()).getFluidInTank(0)).isEmpty()) continue;
            CreateLang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            CreateLang.builder().add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)((IFluidHandlerItem)fluidHandler.get()).getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (isEmpty) {
            tooltip.clear();
        }
        originalTooltip.addAll(tooltip);
        return true;
    }

    public static PackageEntity fromDroppedItem(Level world, Entity originalEntity, ItemStack itemstack) {
        PackageEntity packageEntity = (PackageEntity)((EntityType)FactoryEntities.COMPOSITE_PACKAGE.get()).m_20615_(world);
        Vec3 position = originalEntity.m_20182_();
        packageEntity.m_146884_(position);
        packageEntity.setBox(itemstack);
        packageEntity.m_20256_(originalEntity.m_20184_().m_82490_(1.5));
        PackageEntityAccessor accessor = (PackageEntityAccessor)packageEntity;
        accessor.setOriginalEntity(originalEntity);
        if (world != null && !world.f_46443_ && ChuteBlock.isChute((BlockState)world.m_8055_(BlockPos.m_274561_((double)position.f_82479_, (double)(position.f_82480_ + 0.5), (double)position.f_82481_)))) {
            packageEntity.m_146922_((float)((int)packageEntity.m_146908_() / 90 * 90));
        }
        return packageEntity;
    }

    public static CompositePackageEntity spawn(PlayMessages.SpawnEntity spawnEntity, Level world) {
        CompositePackageEntity packageEntity = new CompositePackageEntity(world, spawnEntity.getPosX(), spawnEntity.getPosY(), spawnEntity.getPosZ());
        packageEntity.m_20334_(spawnEntity.getVelX(), spawnEntity.getVelY(), spawnEntity.getVelZ());
        packageEntity.clientPosition = packageEntity.m_20182_();
        return packageEntity;
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> boxBuilder = builder;
        return boxBuilder.setCustomClientFactory(CompositePackageEntity::spawn).m_20699_(1.0f, 1.0f);
    }
}

