/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics;

import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class FluidItemStackHandler
extends ItemStackHandler {
    private Fluid fluid = Fluids.f_76191_;

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        if (stack.m_41720_() instanceof BucketItem) {
            return true;
        }
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStack resultStack = super.insertItem(slot, stack, simulate);
        if (this.getStackInSlot(slot).m_41720_() instanceof BucketItem) {
            return resultStack;
        }
        this.stacks.set(slot, (Object)new ItemStack((ItemLike)this.fluid.m_6859_()));
        return resultStack;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.fluid = FluidItemStackHandler.getFluidFromStack(this.getStackInSlot(slot), this.fluid);
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public static Fluid getFluidFromStack(ItemStack stack, Fluid existingFluid) {
        Item item = stack.m_41720_();
        if (item instanceof BucketItem) {
            BucketItem be = (BucketItem)item;
            return be.getFluid();
        }
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(fluidHandler -> {
            if (fluidHandler.getTanks() < 1) {
                return Fluids.f_76191_;
            }
            FluidStack fluidInItem = fluidHandler.getFluidInTank(0);
            if (fluidHandler.getTanks() > 1 && (fluidInItem == FluidStack.EMPTY || fluidInItem.getFluid() == existingFluid)) {
                for (int i = 1; i < fluidHandler.getTanks(); ++i) {
                    fluidInItem = fluidHandler.getFluidInTank(i);
                    if (fluidInItem == FluidStack.EMPTY || fluidInItem.getFluid() == existingFluid) continue;
                    return fluidInItem.getFluid();
                }
            }
            return fluidInItem.getFluid();
        }).orElse(Fluids.f_76191_);
    }
}

