/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeature;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.ferreusveritas.dynamictrees.util.function.CanGrowPredicate;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ShroomlightGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> SHROOMLIGHT_BLOCK = ConfigurationProperty.block("shroomlight");
    private static final Direction[] HORIZONTALS = CoordUtils.HORIZONTALS;
    private static final double VANILLA_GROW_CHANCE = (double)0.005f;

    public ShroomlightGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(SHROOMLIGHT_BLOCK, MAX_HEIGHT, CAN_GROW_PREDICATE, PLACE_CHANCE, MAX_COUNT);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(SHROOMLIGHT_BLOCK, Blocks.f_50701_)).with(MAX_HEIGHT, 32)).with(CAN_GROW_PREDICATE, (level, blockPos) -> (double)level.m_213780_().m_188501_() <= (double)0.005f)).with(PLACE_CHANCE, Float.valueOf(0.3f))).with(MAX_COUNT, 4);
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        boolean placed = this.placeShroomlightsInValidPlace(configuration, context.level(), context.pos(), true);
        if (placed) {
            SimpleVoxmap leafMap = context.species().getLeavesProperties().getCellKit().getLeafCluster();
            for (BlockPos endPos : context.endPoints()) {
                TreeHelper.ageVolume(context.level(), endPos.m_6625_(leafMap.getLenY() / 2 + 1), leafMap.getLenX() / 2, leafMap.getLenY() / 2 - 1, 4, SafeChunkBounds.ANY_WG);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        return context.natural() && ((CanGrowPredicate)configuration.get(CAN_GROW_PREDICATE)).test(context.level(), context.pos().m_7494_()) && context.fertility() != 0 && this.placeShroomlightsInValidPlace(configuration, context.level(), context.pos(), false);
    }

    private boolean placeShroomlightsInValidPlace(GenFeatureConfiguration configuration, LevelAccessor level, BlockPos rootPos, boolean worldGen) {
        int treeHeight = this.getTreeHeight(level, rootPos, (Integer)configuration.get(MAX_HEIGHT));
        Block shroomlightBlock = configuration.get(SHROOMLIGHT_BLOCK);
        List<BlockPos> validSpaces = this.findBranchPits(configuration, level, rootPos, treeHeight);
        if (validSpaces == null) {
            return false;
        }
        if (!validSpaces.isEmpty()) {
            if (worldGen) {
                int placed = 0;
                for (BlockPos chosenSpace : validSpaces) {
                    if (!(level.m_213780_().m_188501_() <= ((Float)configuration.get(PLACE_CHANCE)).floatValue())) continue;
                    level.m_7731_(chosenSpace, shroomlightBlock.m_49966_(), 2);
                    if (++placed <= (Integer)configuration.get(MAX_COUNT)) continue;
                    break;
                }
            } else {
                BlockPos chosenSpace = validSpaces.get(level.m_213780_().m_188503_(validSpaces.size()));
                level.m_7731_(chosenSpace, shroomlightBlock.m_49966_(), 2);
            }
            return true;
        }
        return false;
    }

    private int getTreeHeight(LevelAccessor level, BlockPos rootPos, int maxHeight) {
        for (int i = 1; i < maxHeight; ++i) {
            if (TreeHelper.isBranch(level.m_8055_(rootPos.m_6630_(i)))) continue;
            return i - 1;
        }
        return maxHeight;
    }

    @Nullable
    private List<BlockPos> findBranchPits(GenFeatureConfiguration configuration, LevelAccessor level, BlockPos rootPos, int maxHeight) {
        int existingBlocks = 0;
        LinkedList<BlockPos> validSpaces = new LinkedList<BlockPos>();
        boolean firstPit = true;
        block0: for (int y = 2; y < maxHeight; ++y) {
            BlockPos trunkPos = rootPos.m_6630_(y);
            for (Direction dir : HORIZONTALS) {
                BlockPos sidePos = trunkPos.m_121945_(dir);
                if ((level.m_46859_(sidePos) || level.m_8055_(sidePos).m_60734_() instanceof DynamicLeavesBlock) && TreeHelper.isBranch(level.m_8055_(sidePos.m_7494_()))) {
                    if (firstPit) {
                        firstPit = false;
                        continue block0;
                    }
                    validSpaces.add(sidePos);
                    continue;
                }
                if (level.m_8055_(sidePos).m_60734_() != configuration.get(SHROOMLIGHT_BLOCK) || ++existingBlocks <= (Integer)configuration.get(MAX_COUNT)) continue;
                return null;
            }
        }
        return validSpaces;
    }
}

