/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeature;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.compat.season.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.fruit.Fruit;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.nodemapper.FindEndsNode;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class FruitGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Fruit> FRUIT = ConfigurationProperty.property("fruit", Fruit.class);

    public FruitGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(FRUIT, VERTICAL_SPREAD, QUANTITY, RAY_DISTANCE, FRUITING_RADIUS, PLACE_CHANCE);
    }

    @Override
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(FRUIT, Fruit.NULL)).with(VERTICAL_SPREAD, Float.valueOf(30.0f))).with(QUANTITY, 4)).with(FRUITING_RADIUS, 8)).with(PLACE_CHANCE, Float.valueOf(1.0f));
    }

    @Override
    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        return species.hasFruit(configuration.get(FRUIT));
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (!context.endPoints().isEmpty()) {
            int qty = (Integer)configuration.get(QUANTITY);
            qty = (int)((float)qty * context.fruitProductionFactor().floatValue());
            for (int i = 0; i < qty; ++i) {
                BlockPos endPoint = context.endPoints().get(context.random().m_188503_(context.endPoints().size()));
                this.placeDuringWorldGen(configuration, context.species(), context.level(), context.pos().m_7494_(), endPoint, context.bounds(), context.seasonValue());
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        LevelAccessor level = context.level();
        BlockState blockState = level.m_8055_(context.treePos());
        BranchBlock branch = TreeHelper.getBranch(blockState);
        Fruit fruit = configuration.get(FRUIT);
        if (branch != null && branch.getRadius(blockState) >= (Integer)configuration.get(FRUITING_RADIUS) && context.natural()) {
            BlockPos rootPos = context.pos();
            float fruitingFactor = fruit.seasonalFruitProductionFactor(context.levelContext(), rootPos);
            if (fruitingFactor > fruit.getMinProductionFactor() && fruitingFactor > level.m_213780_().m_188501_()) {
                FindEndsNode endFinder = new FindEndsNode();
                TreeHelper.startAnalysisFromRoot(level, rootPos, new MapSignal(endFinder));
                List<BlockPos> endPoints = endFinder.getEnds();
                int qty = (Integer)configuration.get(QUANTITY);
                if (!endPoints.isEmpty()) {
                    for (int i = 0; i < qty; ++i) {
                        BlockPos endPoint = endPoints.get(level.m_213780_().m_188503_(endPoints.size()));
                        this.place(configuration, context.species(), level, rootPos.m_7494_(), endPoint, SeasonHelper.getSeasonValue(context.levelContext(), rootPos));
                    }
                }
            }
        }
        return true;
    }

    protected void place(GenFeatureConfiguration configuration, Species species, LevelAccessor level, BlockPos treePos, BlockPos branchPos, Float seasonValue) {
        BlockPos fruitPos = CoordUtils.getRayTraceFruitPos(level, species, treePos, branchPos, SafeChunkBounds.ANY);
        if (this.shouldPlace(configuration, level, fruitPos)) {
            configuration.get(FRUIT).place(level, fruitPos, seasonValue);
        }
    }

    protected boolean shouldPlace(GenFeatureConfiguration configuration, LevelAccessor level, BlockPos pos) {
        return pos != BlockPos.f_121853_ && (CoordUtils.coordHashCode(pos, 0) & 3) == 0 && level.m_213780_().m_188501_() <= ((Float)configuration.get(PLACE_CHANCE)).floatValue();
    }

    protected void placeDuringWorldGen(GenFeatureConfiguration configuration, Species species, LevelAccessor level, BlockPos treePos, BlockPos branchPos, SafeChunkBounds bounds, Float seasonValue) {
        BlockPos fruitPos = CoordUtils.getRayTraceFruitPos(level, species, treePos, branchPos, bounds);
        if (this.shouldPlaceDuringWorldGen(configuration, level, fruitPos)) {
            configuration.get(FRUIT).placeDuringWorldGen(level, fruitPos, seasonValue);
        }
    }

    protected boolean shouldPlaceDuringWorldGen(GenFeatureConfiguration configuration, LevelAccessor level, BlockPos pos) {
        return pos != BlockPos.f_121853_ && level.m_213780_().m_188501_() <= ((Float)configuration.get(PLACE_CHANCE)).floatValue();
    }
}

