/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models.loader;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.models.geometry.BranchBlockModelGeometry;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BranchBlockModelLoader
implements IGeometryLoader<BranchBlockModelGeometry> {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final String TEXTURES = "textures";
    private static final String BARK = "bark";
    private static final String RINGS = "rings";

    public BranchBlockModelGeometry read(JsonObject modelObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
        JsonObject textures = this.getTexturesObject(modelObject);
        ResourceLocation familyName = this.getLocation(modelObject);
        return this.getModelGeometry(this.getBarkTextureLocation(textures), this.getRingsTextureLocation(textures), familyName == null ? null : TreeRegistry.processResLoc(familyName));
    }

    protected JsonObject getTexturesObject(JsonObject modelContents) {
        if (!modelContents.has(TEXTURES) || !modelContents.get(TEXTURES).isJsonObject()) {
            this.throwRequiresElement(TEXTURES, "Json Object");
        }
        return modelContents.getAsJsonObject(TEXTURES);
    }

    protected ResourceLocation getBarkTextureLocation(JsonObject textureObject) {
        return this.getTextureLocation(textureObject, BARK);
    }

    protected ResourceLocation getRingsTextureLocation(JsonObject textureObject) {
        return this.getTextureLocation(textureObject, RINGS);
    }

    @Nullable
    protected ResourceLocation getLocation(JsonObject object) {
        try {
            return this.getLocationOrThrow(this.getOrThrow(object, "family"));
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    protected ResourceLocation getTextureLocation(JsonObject textureObject, String textureElement) {
        try {
            return this.getLocationOrThrow(this.getOrThrow(textureObject, textureElement));
        }
        catch (RuntimeException e) {
            LOGGER.error("{} missing or did not have valid \"{}\" texture location element, using missing texture.", (Object)this.getModelTypeName(), (Object)textureElement);
            return MissingTextureAtlasSprite.m_118071_();
        }
    }

    protected String getOrThrow(JsonObject jsonObject, String identifier) {
        if (jsonObject.get(identifier) == null || !jsonObject.get(identifier).isJsonPrimitive() || !jsonObject.get(identifier).getAsJsonPrimitive().isString()) {
            this.throwRequiresElement(identifier, "String");
        }
        return jsonObject.get(identifier).getAsString();
    }

    protected void throwRequiresElement(String element, String expectedType) {
        throw new RuntimeException(this.getModelTypeName() + " requires a valid \"" + element + "\" element of type " + expectedType + ".");
    }

    protected ResourceLocation getLocationOrThrow(String location) {
        try {
            return new ResourceLocation(location);
        }
        catch (ResourceLocationException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getModelTypeName() {
        return "Branch";
    }

    protected BranchBlockModelGeometry getModelGeometry(ResourceLocation barkTextureLocation, ResourceLocation ringsTextureLocation, @Nullable ResourceLocation familyName) {
        return new BranchBlockModelGeometry(barkTextureLocation, ringsTextureLocation, familyName, false);
    }
}

