/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.event.handler;

import com.ferreusveritas.dynamictrees.event.handler.CommonEventHandler;
import com.ferreusveritas.dynamictrees.event.handler.LeafUpdateEventHandler;
import com.ferreusveritas.dynamictrees.event.handler.ServerEventHandler;
import com.ferreusveritas.dynamictrees.event.handler.VanillaSaplingEventHandler;
import com.ferreusveritas.dynamictrees.event.handler.WorldGenEventHandler;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;

public final class EventHandlers {
    public static final CommonEventHandler COMMON_EVENT_HANDLER = new CommonEventHandler();
    public static final ServerEventHandler SERVER_EVENT_HANDLER = new ServerEventHandler();
    public static final LeafUpdateEventHandler LEAF_UPDATE_EVENT_HANDLER = new LeafUpdateEventHandler();
    public static final VanillaSaplingEventHandler VANILLA_SAPLING_EVENT_HANDLER = new VanillaSaplingEventHandler();
    public static final WorldGenEventHandler WORLD_GEN_EVENT_HANDLER = new WorldGenEventHandler();

    public static void registerCommon() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.register((Object)COMMON_EVENT_HANDLER);
        bus.register((Object)SERVER_EVENT_HANDLER);
        if (ModList.get().isLoaded("fastleafdecay")) {
            bus.register((Object)LEAF_UPDATE_EVENT_HANDLER);
        }
        bus.register((Object)WORLD_GEN_EVENT_HANDLER);
    }

    public static void configReload() {
        EventHandlers.registerOrUnregister(VANILLA_SAPLING_EVENT_HANDLER, (Boolean)DTConfigs.REPLACE_VANILLA_SAPLING.get());
    }

    private static void registerOrUnregister(Object handler, boolean register) {
        if (register) {
            MinecraftForge.EVENT_BUS.register(handler);
        } else {
            MinecraftForge.EVENT_BUS.unregister(handler);
        }
    }
}

