/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.client;

import com.ferreusveritas.dynamictrees.compat.season.SeasonHelper;
import com.ferreusveritas.dynamictrees.item.Seed;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class TooltipHandler {
    public static void setupTooltips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (!(item instanceof Seed)) {
            return;
        }
        Seed seed = (Seed)item;
        Player player = event.getEntity();
        if (player == null || player.m_9236_() == null) {
            return;
        }
        LevelContext levelContext = LevelContext.create((LevelAccessor)player.m_9236_());
        Species species = seed.getSpecies();
        if (SeasonHelper.getSeasonValue(levelContext, BlockPos.f_121853_) == null || species == null || !species.isValid()) {
            return;
        }
        int flags = seed.getSpecies().getSeasonalTooltipFlags(levelContext);
        TooltipHandler.applySeasonalTooltips(event.getToolTip(), flags);
    }

    public static void applySeasonalTooltips(List<Component> tipList, int flags) {
        if (flags != 0) {
            tipList.add((Component)Component.m_237115_((String)"desc.dynamictrees.seasonal.fertile_seasons").m_130946_(":"));
            if ((flags & 0xF) == 15) {
                tipList.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"desc.dynamictrees.seasonal.year_round").m_130940_(ChatFormatting.LIGHT_PURPLE)));
            } else {
                if ((flags & 1) != 0) {
                    tipList.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"desc.dynamictrees.seasonal.spring").m_130940_(ChatFormatting.GREEN)));
                }
                if ((flags & 2) != 0) {
                    tipList.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"desc.dynamictrees.seasonal.summer").m_130940_(ChatFormatting.YELLOW)));
                }
                if ((flags & 4) != 0) {
                    tipList.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"desc.dynamictrees.seasonal.autumn").m_130940_(ChatFormatting.GOLD)));
                }
                if ((flags & 8) != 0) {
                    tipList.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"desc.dynamictrees.seasonal.winter").m_130940_(ChatFormatting.AQUA)));
                }
            }
        }
    }
}

