/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.worldgen;

import com.ferreusveritas.dynamictrees.api.worldgen.FeatureCanceller;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;

public class BiomePropertySelectors {

    public static enum Chance {
        OK,
        CANCEL,
        UNHANDLED;

    }

    public static class RandomSpeciesSelector
    implements SpeciesSelector {
        ArrayList<Entry> decisionTable = new ArrayList();
        int totalWeight;

        public int getSize() {
            return this.decisionTable.size();
        }

        public RandomSpeciesSelector add(@Nonnull Species species, int weight) {
            this.decisionTable.add(new Entry(new SpeciesSelection(species), weight));
            this.totalWeight += weight;
            return this;
        }

        public RandomSpeciesSelector add(int weight) {
            this.decisionTable.add(new Entry(new SpeciesSelection(), weight));
            this.totalWeight += weight;
            return this;
        }

        @Override
        public SpeciesSelection getSpecies(BlockPos pos, BlockState dirt, RandomSource random) {
            int chance = random.m_188503_(this.totalWeight);
            for (Entry entry : this.decisionTable) {
                if (chance < entry.weight) {
                    return entry.decision;
                }
                chance -= entry.weight;
            }
            return this.decisionTable.get((int)(this.decisionTable.size() - 1)).decision;
        }

        private class Entry {
            public SpeciesSelection decision;
            public int weight;

            public Entry(SpeciesSelection d, int w) {
                this.decision = d;
                this.weight = w;
            }
        }
    }

    public static class StaticSpeciesSelector
    implements SpeciesSelector {
        final SpeciesSelection decision;

        public StaticSpeciesSelector(SpeciesSelection decision) {
            this.decision = decision;
        }

        public StaticSpeciesSelector(@Nonnull Species species) {
            this(new SpeciesSelection(species));
        }

        public StaticSpeciesSelector() {
            this(new SpeciesSelection());
        }

        @Override
        public SpeciesSelection getSpecies(BlockPos pos, BlockState dirt, RandomSource random) {
            return this.decision;
        }
    }

    public static class SpeciesSelection {
        private final boolean handled;
        private final Species species;

        public SpeciesSelection() {
            this.handled = false;
            this.species = Species.NULL_SPECIES;
        }

        public SpeciesSelection(@Nonnull Species species) {
            this.species = species;
            this.handled = true;
        }

        public boolean isHandled() {
            return this.handled;
        }

        public Species getSpecies() {
            return this.species;
        }
    }

    public static final class NormalFeatureCancellation
    implements FeatureCancellation {
        private final Set<FeatureCanceller> cancellers;
        private final Set<String> namespaces;
        private final Collection<GenerationStep.Decoration> decorationSteps;

        public NormalFeatureCancellation() {
            this(Sets.newHashSet(), Sets.newHashSet(), Sets.newHashSet());
        }

        public NormalFeatureCancellation(Set<FeatureCanceller> cancellers, Set<String> namespaces, Set<GenerationStep.Decoration> decorationSteps) {
            this.cancellers = cancellers;
            this.namespaces = namespaces;
            this.decorationSteps = decorationSteps;
        }

        @Override
        public void cancelFeatures(BiomeGenerationSettingsBuilder generationSettingsBuilder) {
            this.decorationSteps.stream().map(arg_0 -> ((BiomeGenerationSettingsBuilder)generationSettingsBuilder).getFeatures(arg_0)).forEach(features -> features.removeIf(placedFeatureHolder -> this.shouldRemovePlacedFeature((PlacedFeature)placedFeatureHolder.m_203334_())));
        }

        private boolean shouldRemovePlacedFeature(PlacedFeature placedFeature) {
            return placedFeature.m_191781_().anyMatch(configuredFeature -> this.cancellers.stream().anyMatch(canceller -> canceller.shouldCancel((ConfiguredFeature<?, ?>)configuredFeature, this)));
        }

        @Override
        public void cancelUsing(FeatureCanceller featureCanceller) {
            this.cancellers.add(featureCanceller);
        }

        @Override
        public void cancelWithNamespace(String namespace) {
            this.namespaces.add(namespace);
        }

        @Override
        public void cancelDuring(GenerationStep.Decoration generationStep) {
            this.decorationSteps.add(generationStep);
        }

        public void cancelDuringDefaultIfNoneSpecified() {
            if (this.decorationSteps.isEmpty()) {
                this.decorationSteps.add(GenerationStep.Decoration.VEGETAL_DECORATION);
            }
        }

        public void addFrom(NormalFeatureCancellation other) {
            this.cancellers.addAll(other.cancellers);
            this.namespaces.addAll(other.namespaces);
            this.decorationSteps.addAll(other.decorationSteps);
        }

        public void replaceFrom(NormalFeatureCancellation other) {
            this.cancellers.clear();
            this.namespaces.clear();
            this.decorationSteps.clear();
            this.addFrom(other);
        }

        public void reset() {
            this.cancellers.clear();
            this.namespaces.clear();
            this.decorationSteps.clear();
        }

        public Set<FeatureCanceller> getCancellers() {
            return this.cancellers;
        }

        public Set<String> getNamespaces() {
            return this.namespaces;
        }

        public Collection<GenerationStep.Decoration> getDecorationSteps() {
            return this.decorationSteps;
        }

        public boolean shouldCancelNamespace(String namespace) {
            return this.namespaces.contains(namespace);
        }
    }

    public static final class NoFeatureCancellation
    implements FeatureCancellation {
        public static final NoFeatureCancellation INSTANCE = new NoFeatureCancellation();

        private NoFeatureCancellation() {
        }

        @Override
        public void cancelFeatures(BiomeGenerationSettingsBuilder generationSettingsBuilder) {
        }

        @Override
        public void cancelUsing(FeatureCanceller featureCanceller) {
        }

        @Override
        public void cancelWithNamespace(String namespace) {
        }

        @Override
        public void cancelDuring(GenerationStep.Decoration generationStep) {
        }
    }

    public static interface FeatureCancellation {
        public void cancelFeatures(BiomeGenerationSettingsBuilder var1);

        public void cancelUsing(FeatureCanceller var1);

        public void cancelWithNamespace(String var1);

        public void cancelDuring(GenerationStep.Decoration var1);
    }

    @FunctionalInterface
    public static interface SpeciesSelector {
        public SpeciesSelection getSpecies(BlockPos var1, BlockState var2, RandomSource var3);
    }

    @FunctionalInterface
    public static interface DensitySelector {
        public double getDensity(RandomSource var1, double var2);
    }

    @FunctionalInterface
    public static interface ChanceSelector {
        public Chance getChance(RandomSource var1, @Nonnull Species var2, int var3);
    }
}

