/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.resource;

import com.ferreusveritas.dynamictrees.api.resource.DTResource;
import com.ferreusveritas.dynamictrees.api.resource.ResourceAccessor;
import com.ferreusveritas.dynamictrees.api.resource.ResourceCollector;
import com.ferreusveritas.dynamictrees.api.resource.SimpleResourceAccessor;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

final class SimpleResourceCollector<R>
implements ResourceCollector<R> {
    private final Supplier<Map> mapSupplier;
    public Map<ResourceLocation, DTResource<R>> resources;

    public SimpleResourceCollector(Supplier<Map> mapSupplier) {
        this.mapSupplier = mapSupplier;
        this.resources = mapSupplier.get();
    }

    @Override
    public DTResource<R> put(DTResource<R> resource) {
        return this.resources.put(resource.getLocation(), resource);
    }

    @Override
    public DTResource<R> computeIfAbsent(ResourceLocation key, Supplier<DTResource<R>> resourceSupplier) {
        return this.resources.computeIfAbsent(key, (? super K k) -> (DTResource)resourceSupplier.get());
    }

    @Override
    public ResourceAccessor<R> createAccessor() {
        return new SimpleResourceAccessor<R>(this.resources, this::newMap);
    }

    @Override
    public void clear() {
        this.resources = this.newMap();
    }

    private <N> Map<ResourceLocation, DTResource<N>> newMap() {
        return this.mapSupplier.get();
    }
}

