/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.statue.animation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.iglee42.createqualityoflife.statue.animation.StatuePartTable;
import net.minecraft.network.FriendlyByteBuf;

public class StatueAnimationFrame {
    public static final Codec<StatueAnimationFrame> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("tick").forGetter(frame -> frame.tick), (App)StatuePartTable.CODEC.fieldOf("global").forGetter(frame -> frame.global), (App)StatuePartTable.CODEC.fieldOf("head").forGetter(frame -> frame.head), (App)StatuePartTable.CODEC.fieldOf("leftArm").forGetter(frame -> frame.leftArm), (App)StatuePartTable.CODEC.fieldOf("rightArm").forGetter(frame -> frame.rightArm), (App)StatuePartTable.CODEC.fieldOf("leftLeg").forGetter(frame -> frame.leftLeg), (App)StatuePartTable.CODEC.fieldOf("rightLeg").forGetter(frame -> frame.rightLeg)).apply((Applicative)instance, StatueAnimationFrame::new));
    private final int tick;
    private StatuePartTable global = new StatuePartTable();
    private StatuePartTable head = new StatuePartTable();
    private StatuePartTable leftArm = new StatuePartTable();
    private StatuePartTable rightArm = new StatuePartTable();
    private StatuePartTable leftLeg = new StatuePartTable();
    private StatuePartTable rightLeg = new StatuePartTable();

    public static void encode(FriendlyByteBuf buf, StatueAnimationFrame frame) {
        buf.writeInt(frame.tick);
        StatuePartTable.encode(buf, frame.global);
        StatuePartTable.encode(buf, frame.head);
        StatuePartTable.encode(buf, frame.leftArm);
        StatuePartTable.encode(buf, frame.rightArm);
        StatuePartTable.encode(buf, frame.leftLeg);
        StatuePartTable.encode(buf, frame.rightLeg);
    }

    public static StatueAnimationFrame decode(FriendlyByteBuf buf) {
        int ticks = buf.readInt();
        StatuePartTable global = StatuePartTable.decode(buf);
        StatuePartTable head = StatuePartTable.decode(buf);
        StatuePartTable leftArm = StatuePartTable.decode(buf);
        StatuePartTable rightArm = StatuePartTable.decode(buf);
        StatuePartTable leftLeg = StatuePartTable.decode(buf);
        StatuePartTable rightLeg = StatuePartTable.decode(buf);
        return new StatueAnimationFrame(ticks, global, head, leftArm, rightArm, leftLeg, rightLeg);
    }

    protected StatueAnimationFrame(int tick, StatuePartTable global, StatuePartTable head, StatuePartTable leftArm, StatuePartTable rightArm, StatuePartTable leftLeg, StatuePartTable rightLeg) {
        this.tick = tick;
        this.global = global;
        this.head = head;
        this.leftArm = leftArm;
        this.rightArm = rightArm;
        this.leftLeg = leftLeg;
        this.rightLeg = rightLeg;
    }

    public StatueAnimationFrame(int tick) {
        this.tick = tick;
    }

    public StatueAnimationFrame withGlobalRotation(float x, float y, float z) {
        this.global = new StatuePartTable(x, y, z);
        return this;
    }

    public StatueAnimationFrame withHeadRotation(float x, float y, float z) {
        this.head = new StatuePartTable(x, y, z);
        return this;
    }

    public StatueAnimationFrame withLeftArmRotation(float x, float y, float z) {
        this.leftArm = new StatuePartTable(x, y, z);
        return this;
    }

    public StatueAnimationFrame withRightArmRotation(float x, float y, float z) {
        this.rightArm = new StatuePartTable(x, y, z);
        return this;
    }

    public StatueAnimationFrame withLeftLegRotation(float x, float y, float z) {
        this.leftLeg = new StatuePartTable(x, y, z);
        return this;
    }

    public StatueAnimationFrame withRightLegRotation(float x, float y, float z) {
        this.rightLeg = new StatuePartTable(x, y, z);
        return this;
    }

    public StatuePartTable getGlobal() {
        return this.global;
    }

    public StatuePartTable getHead() {
        return this.head;
    }

    public StatuePartTable getLeftArm() {
        return this.leftArm;
    }

    public StatuePartTable getRightArm() {
        return this.rightArm;
    }

    public StatuePartTable getLeftLeg() {
        return this.leftLeg;
    }

    public StatuePartTable getRightLeg() {
        return this.rightLeg;
    }

    public int getTick() {
        return this.tick;
    }
}

