/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.registries;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.packets.ChangeArmorTagPacket;
import fr.iglee42.createqualityoflife.packets.ConfigureDisplayBoardPacket;
import fr.iglee42.createqualityoflife.packets.DeleteAnimationPacket;
import fr.iglee42.createqualityoflife.packets.PublishAnimationPacket;
import fr.iglee42.createqualityoflife.packets.SaveStatueConfigPacket;
import fr.iglee42.createqualityoflife.packets.SyncAnimationsConfigPacket;
import fr.iglee42.createqualityoflife.packets.ToggleElytraPacket;
import fr.iglee42.createqualityoflife.packets.ToggleFansPacket;
import fr.iglee42.createqualityoflife.packets.ToggleHoverPacket;
import fr.iglee42.createqualityoflife.packets.UpdateInputsPacket;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public enum ModPackets {
    CONFIGURE_DISPLAY_BOARD(ConfigureDisplayBoardPacket.class, ConfigureDisplayBoardPacket::new, NetworkDirection.PLAY_TO_SERVER),
    TOGGLE_FANS(ToggleFansPacket.class, ToggleFansPacket::new, NetworkDirection.PLAY_TO_SERVER),
    TOGGLE_HOVER(ToggleHoverPacket.class, ToggleHoverPacket::new, NetworkDirection.PLAY_TO_SERVER),
    TOGGLE_ELYTRA(ToggleElytraPacket.class, ToggleElytraPacket::new, NetworkDirection.PLAY_TO_SERVER),
    INPUTS_UPDATE(UpdateInputsPacket.class, UpdateInputsPacket::new, NetworkDirection.PLAY_TO_SERVER),
    CHANGE_ARMOR_TAG(ChangeArmorTagPacket.class, ChangeArmorTagPacket::new, NetworkDirection.PLAY_TO_SERVER),
    SAVE_STATUE_CONFIG(SaveStatueConfigPacket.class, SaveStatueConfigPacket::new, NetworkDirection.PLAY_TO_SERVER),
    PUBLISH_ANIMATION(PublishAnimationPacket.class, PublishAnimationPacket::new, NetworkDirection.PLAY_TO_SERVER),
    DELETE_ANIMATION(DeleteAnimationPacket.class, DeleteAnimationPacket::new, NetworkDirection.PLAY_TO_SERVER),
    SYNC_ANIMATIONS(SyncAnimationsConfigPacket.class, SyncAnimationsConfigPacket::new, NetworkDirection.PLAY_TO_CLIENT);

    public static final ResourceLocation CHANNEL_NAME;
    public static final int NETWORK_VERSION = 1;
    public static final String NETWORK_VERSION_STR;
    private static SimpleChannel channel;
    private PacketType<?> packetType;

    private <T extends SimplePacketBase> ModPackets(Class<T> type, Function<FriendlyByteBuf, T> factory, NetworkDirection direction) {
        this.packetType = new PacketType<T>(type, factory, direction);
    }

    public static void registerPackets() {
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)CHANNEL_NAME).serverAcceptedVersions(NETWORK_VERSION_STR::equals).clientAcceptedVersions(NETWORK_VERSION_STR::equals).networkProtocolVersion(() -> NETWORK_VERSION_STR).simpleChannel();
        for (ModPackets packet : ModPackets.values()) {
            packet.packetType.register();
        }
    }

    public static SimpleChannel getChannel() {
        return channel;
    }

    public static void sendToNear(Level world, BlockPos pos, int range, Object message) {
        ModPackets.getChannel().send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)range, (ResourceKey)world.m_46472_())), message);
    }

    public static <MSG> void sendToPlayer(ServerPlayer player, MSG message) {
        ModPackets.getChannel().send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    static {
        CHANNEL_NAME = CreateQOL.asResource("main");
        NETWORK_VERSION_STR = String.valueOf(1);
    }

    private static class PacketType<T extends SimplePacketBase> {
        private static int index = 0;
        private BiConsumer<T, FriendlyByteBuf> encoder = SimplePacketBase::write;
        private Function<FriendlyByteBuf, T> decoder;
        private BiConsumer<T, Supplier<NetworkEvent.Context>> handler;
        private Class<T> type;
        private NetworkDirection direction;

        private PacketType(Class<T> type, Function<FriendlyByteBuf, T> factory, NetworkDirection direction) {
            this.decoder = factory;
            this.handler = (packet, contextSupplier) -> {
                NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
                if (packet.handle(context)) {
                    context.setPacketHandled(true);
                }
            };
            this.type = type;
            this.direction = direction;
        }

        private void register() {
            ModPackets.getChannel().messageBuilder(this.type, index++, this.direction).encoder(this.encoder).decoder(this.decoder).consumerNetworkThread(this.handler).add();
        }
    }
}

