/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.packets;

import com.simibubi.create.content.trains.display.FlapDisplayBlockEntity;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import fr.iglee42.createqualityoflife.utils.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.DyeColor;

public class ConfigureDisplayBoardPacket
extends BlockEntityConfigurationPacket<FlapDisplayBlockEntity> {
    private int lineIndex;
    private int dyeColor;
    private String text;
    private boolean glowing;

    public ConfigureDisplayBoardPacket(BlockPos pos, int lineIndex, String text, boolean glowing, int dyeColor) {
        super(pos);
        this.lineIndex = lineIndex;
        this.dyeColor = dyeColor;
        this.text = text;
        this.glowing = glowing;
    }

    public ConfigureDisplayBoardPacket(FriendlyByteBuf buffer) {
        super(buffer);
    }

    protected void readSettings(FriendlyByteBuf buffer) {
        this.lineIndex = buffer.readInt();
        this.text = Utils.readStringFromBuffer(buffer);
        this.glowing = buffer.readBoolean();
        this.dyeColor = buffer.readInt();
    }

    protected void writeSettings(FriendlyByteBuf buffer) {
        buffer.writeInt(this.lineIndex);
        Utils.saveStringToBuffer(buffer, this.text);
        buffer.writeBoolean(this.glowing);
        buffer.writeInt(this.dyeColor);
    }

    protected void applySettings(FlapDisplayBlockEntity be) {
        be.setColour(this.lineIndex, DyeColor.m_41053_((int)this.dyeColor));
        be.glowingLines[this.lineIndex] = this.glowing;
        be.applyTextManually(this.lineIndex, this.text);
        be.notifyUpdate();
    }
}

