/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.mixins.liquidblazeburners;

import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.utils.Features;
import fr.iglee42.createqualityoflife.utils.IHaveTankMixin;
import fr.iglee42.createqualityoflife.utils.liquidblazeburners.LiquidBlazeBurnerManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlazeBurnerBlockEntity.class}, remap=false)
public abstract class BlazeBurnerBlockEntityMixin
extends SmartBlockEntity
implements IHaveTankMixin {
    @Shadow
    protected int remainingBurnTime;
    @Shadow
    protected BlazeBurnerBlockEntity.FuelType activeFuel;
    @Unique
    protected SmartFluidTank createQOL$tank;

    public BlazeBurnerBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Shadow
    protected abstract void setBlockHeat(BlazeBurnerBlock.HeatLevel var1);

    @Shadow
    public abstract int getRemainingBurnTime();

    @Shadow
    protected abstract void playSound();

    @Shadow
    public abstract void updateBlockState();

    @Shadow
    public abstract BlazeBurnerBlock.HeatLevel getHeatLevelFromBlock();

    @Shadow
    public abstract void spawnParticleBurst(boolean var1);

    @Inject(method={"addBehaviours"}, at={@At(value="TAIL")})
    private void createQOL$addTank(List<BlockEntityBehaviour> behaviours, CallbackInfo ci) {
        this.createQOL$tank = new SmartFluidTank(1000, stack -> {}){

            public boolean isFluidValid(FluidStack stack) {
                return LiquidBlazeBurnerManager.BLAZE_BURNER_LIQUIDS.containsKey(stack.getFluid());
            }
        };
    }

    @Override
    public SmartFluidTank createQOL$tank() {
        return this.createQOL$tank;
    }

    @Inject(method={"read"}, at={@At(value="TAIL")})
    public void createQOL$read(CompoundTag nbt, boolean clientPacket, CallbackInfo ci) {
        if (this.createQOL$tank != null && nbt.m_128441_("tank")) {
            this.createQOL$tank.readFromNBT(nbt.m_128469_("tank"));
        }
    }

    @Inject(method={"write"}, at={@At(value="TAIL")})
    public void createQOL$write(CompoundTag nbt, boolean clientPacket, CallbackInfo ci) {
        if (this.createQOL$tank != null) {
            nbt.m_128365_("tank", (Tag)this.createQOL$tank.writeToNBT(new CompoundTag()));
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void createQOL$tick(CallbackInfo info) {
        if (!CreateQOL.isActivate(Features.LIQUID_BLAZE_BURNER)) {
            return;
        }
        if (this.createQOL$tank == null) {
            return;
        }
        if (this.createQOL$tank.getFluid().getAmount() <= 0) {
            return;
        }
        LiquidBlazeBurnerManager.LiquidEntry fluidProperties = LiquidBlazeBurnerManager.BLAZE_BURNER_LIQUIDS.getOrDefault(this.createQOL$tank.getFluid().getFluid(), null);
        if (fluidProperties == null) {
            return;
        }
        boolean superHeated = fluidProperties.superHeated();
        int consumption = fluidProperties.consumption();
        if (this.createQOL$tank.getFluid().getAmount() < consumption) {
            return;
        }
        if (superHeated) {
            this.setBlockHeat(BlazeBurnerBlock.HeatLevel.SEETHING);
        } else {
            this.setBlockHeat(BlazeBurnerBlock.HeatLevel.FADING);
        }
        int newBurnTime = this.getRemainingBurnTime() + fluidProperties.burnTime();
        if (newBurnTime > 10000) {
            return;
        }
        this.remainingBurnTime = newBurnTime;
        this.createQOL$tank.drain(consumption, IFluidHandler.FluidAction.EXECUTE);
    }

    @Inject(method={"tryUpdateFuel"}, at={@At(value="HEAD")}, cancellable=true)
    private void createQOL$tryUpdateFuel(ItemStack itemStack, boolean forceOverflow, boolean simulate, CallbackInfoReturnable<Boolean> cir) {
        BlazeBurnerBlockEntity be;
        Level level;
        if (!CreateQOL.isActivate(Features.LIQUID_BLAZE_BURNER)) {
            return;
        }
        if (this.createQOL$tank == null) {
            return;
        }
        if (itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM) == null || !itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            return;
        }
        IFluidHandlerItem handler = itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve().orElse(null);
        if (handler == null) {
            return;
        }
        if (!this.createQOL$tank.getFluid().isEmpty() && handler.getFluidInTank(0).getFluid() != this.createQOL$tank.getFluid().getFluid()) {
            return;
        }
        if (handler.getTanks() != 1) {
            return;
        }
        FluidStack fluidStack = handler.getFluidInTank(0);
        if (fluidStack.isEmpty()) {
            return;
        }
        if (!LiquidBlazeBurnerManager.BLAZE_BURNER_LIQUIDS.containsKey(fluidStack.getFluid())) {
            return;
        }
        if (this.createQOL$tank.getFluid().getAmount() + fluidStack.getAmount() > this.createQOL$tank.getCapacity() && !forceOverflow) {
            return;
        }
        if (!simulate) {
            if (this.createQOL$tank.getFluid().isEmpty()) {
                this.createQOL$tank.setFluid(fluidStack.copy());
            } else {
                this.createQOL$tank.getFluid().grow(fluidStack.getAmount());
            }
        }
        if ((level = (be = (BlazeBurnerBlockEntity)this).m_58904_()) == null) {
            cir.setReturnValue((Object)true);
            return;
        }
        BlockPos worldPosition = be.m_58899_();
        if (level.f_46443_) {
            this.spawnParticleBurst(this.activeFuel == BlazeBurnerBlockEntity.FuelType.SPECIAL);
            cir.setReturnValue((Object)true);
        }
        BlazeBurnerBlock.HeatLevel prev = this.getHeatLevelFromBlock();
        this.playSound();
        this.updateBlockState();
        if (prev != this.getHeatLevelFromBlock()) {
            level.m_5594_(null, worldPosition, SoundEvents.f_11701_, SoundSource.BLOCKS, 0.125f + level.f_46441_.m_188501_() * 0.125f, 1.15f - level.f_46441_.m_188501_() * 0.25f);
        }
        cir.setReturnValue((Object)true);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.isFluidHandlerCap(cap)) {
            return LazyOptional.of(() -> this.createQOL$tank).cast();
        }
        return super.getCapability(cap, side);
    }
}

