/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.utils.CommonKeysHandler;
import fr.iglee42.createqualityoflife.utils.NBTConstants;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class ShadowRadianceChestplate
extends BacktankItem.Layered {
    private static final double FANS_ACCELERATION = 0.15;
    private static final double FANS_SPEED = 0.25;
    private static final double FANS_HOVER_SPEED = 0.2;

    public ShadowRadianceChestplate(ArmorMaterial material, Item.Properties properties, ResourceLocation textureLoc, Supplier<BacktankItem.BacktankBlockItem> placeable) {
        super(material, properties, textureLoc, placeable);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot p_40390_) {
        if (p_40390_.equals((Object)EquipmentSlot.CHEST)) {
            ImmutableMultimap.Builder attributes = ImmutableMultimap.builder();
            attributes.putAll(super.m_7167_(p_40390_));
            String reference = "shadow_radiance_" + p_40390_.name().toLowerCase();
            UUID uuidBlock = UUID.nameUUIDFromBytes((reference + "_block").getBytes());
            UUID uuidEntity = UUID.nameUUIDFromBytes((reference + "_entity").getBytes());
            attributes.put((Object)((Attribute)ForgeMod.BLOCK_REACH.get()), (Object)new AttributeModifier(uuidBlock, reference + "_block", 1.0, AttributeModifier.Operation.ADDITION));
            attributes.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(uuidEntity, reference + "_entity", 1.0, AttributeModifier.Operation.ADDITION));
            return attributes.build();
        }
        return super.m_7167_(p_40390_);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return ShadowRadianceChestplate.hasElytra(stack) && ShadowRadianceChestplate.isElytraEnable(stack) && (!ShadowRadianceChestplate.hasPropeller(stack) || !ShadowRadianceChestplate.isFansEnable(stack)) && !BacktankUtil.getAllWithAir((LivingEntity)entity).isEmpty() && (Boolean)CreateQOLConfigs.server().elytraAllowed.get() != false;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        return true;
    }

    private static boolean hasPlayerStackInInventory(Player player, Item item) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack currentStack = player.m_150109_().m_8020_(i);
            if (currentStack.m_41619_() || !currentStack.m_150930_(item)) continue;
            return true;
        }
        return false;
    }

    private static int getFirstInventoryIndex(Player player, Item item) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack currentStack = player.m_150109_().m_8020_(i);
            if (currentStack.m_41619_() || !currentStack.m_150930_(item)) continue;
            return i;
        }
        return -1;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.m_6883_(stack, level, entity, slot, offHand);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_6844_(EquipmentSlot.CHEST).equals(stack)) {
            boolean second;
            boolean bl = second = level.m_46467_() % 20L == 0L;
            if (BacktankUtil.getAllWithAir((LivingEntity)player).isEmpty()) {
                return;
            }
            if (NBTConstants.getOrDefault(stack, "effects", true) && ((Boolean)CreateQOLConfigs.server().armorEffects.get()).booleanValue()) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 20, 1, false, false));
            }
            if (player.m_21255_() && ShadowRadianceChestplate.isElytraEnable(stack) && !BacktankUtil.getAllWithAir((LivingEntity)player).isEmpty() && ((Boolean)CreateQOLConfigs.server().elytraAllowed.get()).booleanValue() && ((Boolean)CreateQOLConfigs.server().elytraBoostAllowed.get()).booleanValue() && CommonKeysHandler.isHoldingUp(player)) {
                if (((Boolean)CreateQOLConfigs.server().useFireworksForBoost.get()).booleanValue()) {
                    if (ShadowRadianceChestplate.hasPlayerStackInInventory(player, Items.f_42688_)) {
                        int rocketSlot = ShadowRadianceChestplate.getFirstInventoryIndex(player, Items.f_42688_);
                        ItemStack firework = player.m_150109_().m_8020_(rocketSlot);
                        if (player.m_21256_() % (Integer)CreateQOLConfigs.server().fireworkDuration.get() == 0 || player.m_21256_() == 0) {
                            FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(level, firework, (LivingEntity)player);
                            level.m_7967_((Entity)fireworkrocketentity);
                            player.m_150109_().m_7407_(rocketSlot, 1);
                        }
                    }
                } else if (level.m_46467_() % 10L == 0L) {
                    Vec3 vec31 = player.m_20154_();
                    double d0 = 1.5;
                    double d1 = 0.1;
                    Vec3 vec32 = player.m_20184_();
                    player.m_20256_(vec32.m_82520_(vec31.f_82479_ * d1 + (vec31.f_82479_ * d0 - vec32.f_82479_) * 0.5, vec31.f_82480_ * d1 + (vec31.f_82480_ * d0 - vec32.f_82480_) * 0.5, vec31.f_82481_ * d1 + (vec31.f_82481_ * d0 - vec32.f_82481_) * 0.5));
                    if (!player.m_7500_()) {
                        BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)stack, (float)1.0f);
                    }
                }
            }
            if (player.m_7500_() || player.m_5833_()) {
                return;
            }
            if (ShadowRadianceChestplate.isFansEnable(stack) && !BacktankUtil.getAllWithAir((LivingEntity)player).isEmpty() && ShadowRadianceChestplate.hasPropeller(stack) && ((Boolean)CreateQOLConfigs.server().propellerAllowed.get()).booleanValue()) {
                boolean hover = ShadowRadianceChestplate.isHoverEnable(stack) && (Boolean)CreateQOLConfigs.server().hoverAllowed.get() != false;
                boolean jumpKeyActive = CommonKeysHandler.isHoldingUp(player);
                boolean shiftKeyActive = CommonKeysHandler.isHoldingDown(player);
                player.m_183634_();
                if (player instanceof ServerPlayer) {
                    ((ServerPlayer)player).f_8906_.f_9737_ = 0;
                }
                if (!player.m_6069_()) {
                    if (jumpKeyActive) {
                        if (!hover) {
                            if (shiftKeyActive) {
                                this.pushVertically(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + 0.15, -0.0));
                            } else {
                                this.pushVertically(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + 0.15, 0.25));
                            }
                        } else if (((Boolean)CreateQOLConfigs.server().hoverAllowed.get()).booleanValue()) {
                            this.pushVertically(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + 0.15, 0.2));
                        }
                        if (second) {
                            BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)stack, (float)1.0f);
                        }
                    } else if (hover) {
                        if (((Boolean)CreateQOLConfigs.server().hoverAllowed.get()).booleanValue()) {
                            if (shiftKeyActive) {
                                this.pushVertically(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + 0.15, -0.4));
                            } else {
                                this.pushVertically(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + 0.15, -0.0));
                                if (second) {
                                    BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)stack, (float)1.0f);
                                }
                            }
                        }
                    } else if (shiftKeyActive) {
                        this.pushVertically(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + 0.15, -0.4));
                    } else {
                        this.pushVertically(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + 0.15, -0.30000000000000004));
                    }
                    if (CommonKeysHandler.isHoldingForwards(player)) {
                        player.m_19920_(1.0f, new Vec3(0.0, 0.0, player.m_20142_() ? 0.05625 : 0.05));
                    }
                    if (CommonKeysHandler.isHoldingBackwards(player)) {
                        player.m_19920_(1.0f, new Vec3(0.0, 0.0, -0.037500000000000006));
                    }
                    if (CommonKeysHandler.isHoldingLeft(player)) {
                        player.m_19920_(1.0f, new Vec3(0.05, 0.0, 0.0));
                    }
                    if (CommonKeysHandler.isHoldingRight(player)) {
                        player.m_19920_(1.0f, new Vec3(-0.05, 0.0, 0.0));
                    }
                } else if (jumpKeyActive) {
                    player.m_19920_(1.0f, new Vec3(0.0, 0.0, 0.05625));
                    if (second) {
                        BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)stack, (float)1.0f);
                    }
                }
            }
        }
    }

    private void pushVertically(Player p, double y) {
        Vec3 motion = p.m_20184_();
        p.m_20334_(motion.m_82507_(Direction.Axis.X), y, motion.m_82507_(Direction.Axis.Z));
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> components, TooltipFlag p_41424_) {
        components.add((Component)Component.m_237113_((String)"Air : ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)String.valueOf(BacktankUtil.getAir((ItemStack)stack))).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)("/" + BacktankUtil.maxAir((ItemStack)stack))).m_130940_(ChatFormatting.GOLD)));
        components.add((Component)Component.m_237113_((String)"Propeller : ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)ShadowRadianceChestplate.chooseState((Boolean)CreateQOLConfigs.server().propellerAllowed.get(), ShadowRadianceChestplate.hasPropeller(stack), true, false, false)).m_130940_((Boolean)CreateQOLConfigs.server().propellerAllowed.get() == false ? ChatFormatting.RED : ChatFormatting.YELLOW)));
        if (ShadowRadianceChestplate.hasPropeller(stack) && ((Boolean)CreateQOLConfigs.server().propellerAllowed.get()).booleanValue()) {
            components.add((Component)Component.m_237119_());
            components.add((Component)Component.m_237113_((String)"Fan : ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)ShadowRadianceChestplate.chooseState(true, true, ShadowRadianceChestplate.isFansEnable(stack), false, true)).m_130940_(ChatFormatting.YELLOW)));
            components.add((Component)Component.m_237113_((String)"Hover : ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)ShadowRadianceChestplate.chooseState((Boolean)CreateQOLConfigs.server().hoverAllowed.get(), true, ShadowRadianceChestplate.isHoverEnable(stack), false, true)).m_130940_((Boolean)CreateQOLConfigs.server().hoverAllowed.get() == false ? ChatFormatting.RED : ChatFormatting.YELLOW)));
        }
        components.add((Component)Component.m_237113_((String)"Elytra : ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)ShadowRadianceChestplate.chooseState((Boolean)CreateQOLConfigs.server().elytraAllowed.get(), ShadowRadianceChestplate.hasElytra(stack), ShadowRadianceChestplate.isElytraEnable(stack), true, false)).m_130940_((Boolean)CreateQOLConfigs.server().elytraAllowed.get() == false ? ChatFormatting.RED : ChatFormatting.YELLOW)));
        super.m_7373_(stack, p_41422_, components, p_41424_);
    }

    private static String chooseState(boolean config, boolean installed, boolean active, boolean activeReplaceInstall, boolean activeOnly) {
        if (activeOnly) {
            return !config ? "Disabled By Config" : (active ? "Enable" : "Disable");
        }
        return !config ? "Disabled By Config" : (installed ? (activeReplaceInstall ? (active ? "Enable" : "Disable") : "Installed") : "Not Installed");
    }

    public static void toggleFans(ItemStack chestplate, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().propellerAllowed.get()).booleanValue()) {
            p.m_5661_((Component)Component.m_237113_((String)"Propeller is disabled by the config").m_130940_(ChatFormatting.RED), true);
            return;
        }
        if (ShadowRadianceChestplate.isElytraEnable(chestplate)) {
            p.m_5661_((Component)Component.m_237113_((String)"Fan can't be enabled if the elytra are enabled").m_130940_(ChatFormatting.RED), true);
            return;
        }
        chestplate.m_41784_().m_128379_("fans", chestplate.m_41784_().m_128441_("fans") && !chestplate.m_41784_().m_128471_("fans"));
        boolean fans = chestplate.m_41784_().m_128471_("fans");
        p.m_5661_((Component)Component.m_237113_((String)"Fan : ").m_7220_((Component)Component.m_237113_((String)ShadowRadianceChestplate.chooseState(true, true, fans, false, true)).m_130940_(fans ? ChatFormatting.GREEN : ChatFormatting.RED)), true);
    }

    public static void toggleHover(ItemStack chestplate, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().propellerAllowed.get()).booleanValue()) {
            p.m_5661_((Component)Component.m_237113_((String)"Propeller is disabled by the config").m_130940_(ChatFormatting.RED), true);
            return;
        }
        if (!((Boolean)CreateQOLConfigs.server().hoverAllowed.get()).booleanValue()) {
            p.m_5661_((Component)Component.m_237113_((String)"Hover is disabled by the config").m_130940_(ChatFormatting.RED), true);
            return;
        }
        chestplate.m_41784_().m_128379_("hover", chestplate.m_41784_().m_128441_("hover") && !chestplate.m_41784_().m_128471_("hover"));
        boolean hover = chestplate.m_41784_().m_128471_("hover");
        p.m_5661_((Component)Component.m_237113_((String)"Hover : ").m_7220_((Component)Component.m_237113_((String)ShadowRadianceChestplate.chooseState(true, true, hover, false, true)).m_130940_(hover ? ChatFormatting.GREEN : ChatFormatting.RED)), true);
    }

    public static void toggleElytra(ItemStack chestplate, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().elytraAllowed.get()).booleanValue()) {
            p.m_5661_((Component)Component.m_237113_((String)"Elytra are disabled by the config").m_130940_(ChatFormatting.RED), true);
            return;
        }
        if (ShadowRadianceChestplate.isFansEnable(chestplate)) {
            p.m_5661_((Component)Component.m_237113_((String)"Elytra can't be enabled if the fans is enabled").m_130940_(ChatFormatting.RED), true);
            return;
        }
        chestplate.m_41784_().m_128379_("elytraState", chestplate.m_41784_().m_128441_("elytraState") && !chestplate.m_41784_().m_128471_("elytraState"));
        boolean elytra = ShadowRadianceChestplate.isElytraEnable(chestplate);
        p.m_5661_((Component)Component.m_237113_((String)"Elytra : ").m_7220_((Component)Component.m_237113_((String)ShadowRadianceChestplate.chooseState(true, true, elytra, false, true)).m_130940_(elytra ? ChatFormatting.GREEN : ChatFormatting.RED)), true);
    }

    public static boolean hasPropeller(ItemStack chestplate) {
        return chestplate.m_41784_().m_128441_("propellers") && chestplate.m_41784_().m_128471_("propellers");
    }

    public static boolean hasElytra(ItemStack chestplate) {
        return chestplate.m_41784_().m_128441_("elytra") && chestplate.m_41784_().m_128471_("elytra");
    }

    public static boolean isElytraEnable(ItemStack chestplate) {
        return !chestplate.m_41784_().m_128441_("elytraState") ? !ShadowRadianceChestplate.isFansEnable(chestplate) : chestplate.m_41784_().m_128471_("elytraState");
    }

    public static boolean isFansEnable(ItemStack chestplate) {
        if (!ShadowRadianceChestplate.hasPropeller(chestplate)) {
            return false;
        }
        return !chestplate.m_41784_().m_128441_("fans") || chestplate.m_41784_().m_128471_("fans");
    }

    public static boolean isHoverEnable(ItemStack chestplate) {
        if (!ShadowRadianceChestplate.hasPropeller(chestplate)) {
            return false;
        }
        return chestplate.m_41784_().m_128441_("hover") && chestplate.m_41784_().m_128471_("hover");
    }
}

