/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.widgets;

import com.simibubi.create.AllKeys;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.function.Consumer;
import java.util.function.Function;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;

public class FloatScrollInput
extends AbstractSimiWidget {
    protected Consumer<Float> onScroll;
    protected float state = 0.0f;
    protected Component title = CreateLang.translateDirect((String)"gui.scrollInput.defaultTitle", (Object[])new Object[0]);
    protected final Component scrollToModify = CreateLang.translateDirect((String)"gui.scrollInput.scrollToModify", (Object[])new Object[0]);
    protected final Component shiftScrollsFaster = CreateLang.translateDirect((String)"gui.scrollInput.shiftScrollsFaster", (Object[])new Object[0]);
    protected Component hint = null;
    protected Label displayLabel;
    protected boolean inverted;
    protected boolean soundPlayed = false;
    protected Function<Float, Component> formatter;
    protected float min = 0.0f;
    protected float max = 1.0f;
    protected float shiftStep = 1.0f;
    Function<StepContext, Float> step = this.standardStep();

    public FloatScrollInput(int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
        this.formatter = i -> Component.m_237113_((String)String.valueOf(i));
    }

    public Function<StepContext, Float> standardStep() {
        return c -> Float.valueOf(c.shift ? this.shiftStep : 0.5f);
    }

    public FloatScrollInput inverted() {
        this.inverted = true;
        return this;
    }

    public FloatScrollInput withRange(float min, float max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public FloatScrollInput calling(Consumer<Float> onScroll) {
        this.onScroll = onScroll;
        return this;
    }

    public FloatScrollInput format(Function<Float, Component> formatter) {
        this.formatter = formatter;
        return this;
    }

    public FloatScrollInput removeCallback() {
        this.onScroll = null;
        return this;
    }

    public FloatScrollInput titled(MutableComponent title) {
        this.title = title;
        this.m_257936_();
        return this;
    }

    public FloatScrollInput addHint(MutableComponent hint) {
        this.hint = hint;
        this.m_257936_();
        return this;
    }

    public FloatScrollInput withStepFunction(Function<StepContext, Float> step) {
        this.step = step;
        return this;
    }

    public FloatScrollInput writingTo(Label label) {
        this.displayLabel = label;
        if (label != null) {
            this.writeToLabel();
        }
        return this;
    }

    public void tick() {
        super.tick();
        this.soundPlayed = false;
    }

    public float getState() {
        return this.state;
    }

    public FloatScrollInput setState(float state) {
        this.state = state;
        this.clampState();
        this.m_257936_();
        if (this.displayLabel != null) {
            this.writeToLabel();
        }
        return this;
    }

    public FloatScrollInput withShiftStep(float step) {
        this.shiftStep = step;
        return this;
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pScrollY) {
        if (this.inverted) {
            pScrollY *= -1.0;
        }
        StepContext context = new StepContext();
        context.control = AllKeys.ctrlDown();
        context.shift = AllKeys.shiftDown();
        context.currentValue = this.state;
        context.forward = pScrollY > 0.0;
        float priorState = this.state;
        float step = (float)(Math.signum(pScrollY) * (double)this.step.apply(context).floatValue());
        this.state += step;
        this.clampState();
        if (priorState != this.state) {
            if (!this.soundPlayed) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)AllSoundEvents.SCROLL_VALUE.getMainEvent(), (float)(1.5f + 0.1f * (this.state - this.min) / (this.max - this.min))));
            }
            this.soundPlayed = true;
            this.onChanged();
        }
        return priorState != this.state;
    }

    protected void clampState() {
        if ((double)this.state >= (double)this.max + 0.001) {
            this.state = this.max - 1.0f;
        }
        if (this.state < this.min) {
            this.state = this.min;
        }
    }

    public void onChanged() {
        if (this.displayLabel != null) {
            this.writeToLabel();
        }
        if (this.onScroll != null) {
            this.onScroll.accept(Float.valueOf(this.state));
        }
        this.m_257936_();
    }

    protected void writeToLabel() {
        this.displayLabel.text = this.formatter.apply(Float.valueOf(this.state));
    }

    protected void m_257936_() {
        this.toolTip.clear();
        if (this.title == null) {
            return;
        }
        this.toolTip.add(this.title.m_6879_().m_130938_(s -> s.m_178520_(HEADER_RGB.getRGB())));
        if (this.hint != null) {
            this.toolTip.add(this.hint.m_6879_().m_130938_(s -> s.m_178520_(HINT_RGB.getRGB())));
        }
        this.toolTip.add(this.scrollToModify.m_6879_().m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY}));
        this.toolTip.add(this.shiftScrollsFaster.m_6879_().m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY}));
    }

    public void m_5716_(double mouseX, double mouseY) {
        double clickedX = mouseX - (double)this.m_252754_();
        double progress = clickedX / (double)this.f_93618_;
        float newValue = (float)(progress * (double)(this.max + Math.abs(this.min)));
        this.setState(newValue - Math.abs(this.min));
        this.onChanged();
    }

    public static class StepContext {
        public float currentValue;
        public boolean forward;
        public boolean shift;
        public boolean control;
    }
}

