/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.tabs;

import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import fr.iglee42.createqualityoflife.client.screens.ConfigureStatueScreen;
import fr.iglee42.createqualityoflife.client.screens.tabs.StatueTab;
import fr.iglee42.createqualityoflife.client.screens.widgets.StatueAnimationWidget;
import fr.iglee42.createqualityoflife.statue.animation.PublishedAnimationsManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.world.item.Items;

public class PublishedAnimationsTab
extends StatueTab {
    private int selected = 6;
    private List<StatueAnimationWidget> animations;
    private IconButton previousButton;
    private IconButton nextButton;

    public PublishedAnimationsTab(int index, ConfigureStatueScreen parent) {
        super(index, Items.f_41997_, parent, "statue.publishedAnimationTab");
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial, int x, int y) {
        this.animations.forEach(p -> {
            p.f_93624_ = this.animations.indexOf(p) >= this.selected - 6 && this.animations.indexOf(p) < this.selected;
        });
        this.previousButton.f_93623_ = this.selected > 6;
        this.nextButton.f_93623_ = this.selected < this.animations.size();
    }

    @Override
    public void forEachWidgets(Consumer<AbstractWidget> function) {
        this.animations.forEach(function);
        function.accept((AbstractWidget)this.nextButton);
        function.accept((AbstractWidget)this.previousButton);
    }

    @Override
    public void initWidgets(int x, int y) {
        this.animations = new ArrayList<StatueAnimationWidget>();
        for (PublishedAnimationsManager.PublishedAnimation anim : PublishedAnimationsManager.CLIENT_ANIMATIONS) {
            int index = this.animations.size() % 6;
            int indexInPos = index % 3;
            this.animations.add(new StatueAnimationWidget(x + indexInPos * 45, y + (index > 2 ? 80 : 0), anim, this));
        }
        this.previousButton = new IconButton(this.getParent().getGuiLeft() + this.getParent().f_97726_ - 95, this.getParent().getGuiTop() + this.getParent().f_97727_ - 24, (ScreenElement)AllIcons.I_CONFIG_BACK);
        this.previousButton.withCallback(() -> {
            if (this.selected > 6) {
                this.selected -= 6;
            }
        });
        this.nextButton = new IconButton(this.getParent().getGuiLeft() + this.getParent().f_97726_ - 75, this.getParent().getGuiTop() + this.getParent().f_97727_ - 24, (ScreenElement)AllIcons.I_CONFIG_OPEN);
        this.nextButton.withCallback(() -> {
            int maxIndex = (this.animations.size() - 1) / 6 * 6;
            if (this.selected + 6 <= maxIndex + 6) {
                this.selected += 6;
            }
        });
    }

    public void updateAnimationsPos(int x, int y) {
        for (int index = 0; index < this.animations.size(); ++index) {
            int indexInPos = index % 3;
            this.animations.get(index).m_252865_(x + indexInPos * 45);
            this.animations.get(index).m_253211_(y + (index > 2 ? 80 : 0));
        }
    }

    public List<StatueAnimationWidget> getAnimations() {
        return this.animations;
    }

    @Override
    public void onQuit() {
        super.onQuit();
    }
}

