/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import fr.iglee42.createqualityoflife.client.screens.widgets.ArmorConfigScreenList;
import fr.iglee42.createqualityoflife.client.screens.widgets.ItemConfigButton;
import fr.iglee42.createqualityoflife.client.screens.widgets.entries.BooleanEntry;
import fr.iglee42.createqualityoflife.client.screens.widgets.entries.EnumEntry;
import fr.iglee42.createqualityoflife.client.screens.widgets.entries.ValueEntry;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.items.ShadowRadianceChestplate;
import fr.iglee42.createqualityoflife.registries.ModArmorMaterials;
import fr.iglee42.createqualityoflife.utils.ArmorRenderType;
import fr.iglee42.createqualityoflife.utils.NBTConstants;
import fr.iglee42.createqualityoflife.utils.PreferredRender;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.createmod.catnip.animation.Force;
import net.createmod.catnip.animation.PhysicalFloat;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.DelegatedStencilElement;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ArmorConfigScreen
extends AbstractSimiScreen {
    public static final PhysicalFloat cogSpin = PhysicalFloat.create().withLimit(10.0f).withDrag(0.3).addForce((Force)new Force.Static(0.2f));
    public static DelegatedStencilElement shadowElement = new DelegatedStencilElement((graphics, x, y, alpha) -> ArmorConfigScreen.renderCog(graphics), (graphics, x, y, alpha) -> graphics.m_280509_(-200, -200, 200, 200, 0x60000000));
    protected ArmorConfigScreenList list;
    protected int listWidth;
    private int selectedItem = -1;
    private List<Integer> armors;

    protected void m_7856_() {
        super.m_7856_();
        this.listWidth = Math.min(this.f_96543_ - 80, 300);
        int yCenter = this.f_96544_ / 2;
        int listL = this.f_96543_ / 2 - this.listWidth / 2;
        int listR = this.f_96543_ / 2 + this.listWidth / 2;
        this.list = new ArmorConfigScreenList(this.f_96541_, this.listWidth, this.f_96544_ - 80, 35, this.f_96544_ - 45, 40, this);
        this.list.m_93507_(listL);
        this.m_142416_((GuiEventListener)this.list);
        this.armors = new ArrayList<Integer>();
        Minecraft.m_91087_().f_91074_.m_150109_().f_35975_.forEach(it -> {
            if (!(it.m_41720_() instanceof ArmorItem)) {
                return;
            }
            if (((ArmorItem)it.m_41720_()).m_40401_().equals((Object)ModArmorMaterials.SHADOW_RADIANCE)) {
                this.armors.add(Minecraft.m_91087_().f_91074_.m_150109_().f_35975_.indexOf(it));
            }
        });
        this.armors = Lists.reverse(this.armors);
        for (int index = 0; index < this.armors.size(); ++index) {
            int finalIndex = index;
            this.m_142416_((GuiEventListener)new ItemConfigButton(listL - 24, 35 + this.list.getHeight() / 2 + (index - 2) * 30, btn -> this.onSelectedChange(finalIndex), finalIndex).showing(Minecraft.m_91087_().f_91074_.m_150109_().m_36052_(this.armors.get(index).intValue())));
        }
    }

    public void m_86600_() {
        super.m_86600_();
        cogSpin.tick();
        this.m_6702_().stream().filter(w -> w instanceof ItemConfigButton).forEach(btn -> ((ItemConfigButton)((Object)btn)).setActive(((ItemConfigButton)((Object)btn)).getIndex() != this.selectedItem));
        this.list.m_6702_().stream().filter(e -> e instanceof ValueEntry).map(e -> (ValueEntry)((Object)e)).forEach(entry -> {
            boolean flag;
            if (entry.getNbtKey().equals("goggles")) {
                if (!((Boolean)CreateQOLConfigs.server().helmetHaveGoggles.get()).booleanValue() && entry.isEditable()) {
                    ((BooleanEntry)((Object)entry)).setValue(false);
                }
                entry.setEditable((Boolean)CreateQOLConfigs.server().helmetHaveGoggles.get());
            }
            if (entry.getNbtKey().equals("fans")) {
                if (!((Boolean)CreateQOLConfigs.server().propellerAllowed.get()).booleanValue() && entry.isEditable()) {
                    ((BooleanEntry)((Object)entry)).setValue(false);
                }
                flag = this.list.m_6702_().stream().noneMatch(e -> {
                    BooleanEntry oEntry;
                    return e instanceof BooleanEntry && (oEntry = (BooleanEntry)((Object)((Object)e))).getNbtKey().equals("elytraState") && (Boolean)oEntry.getValue() != false;
                });
                entry.setEditable((Boolean)CreateQOLConfigs.server().propellerAllowed.get() != false && flag);
            }
            if (entry.getNbtKey().equals("hover")) {
                if (!(((Boolean)CreateQOLConfigs.server().hoverAllowed.get()).booleanValue() && ((Boolean)CreateQOLConfigs.server().propellerAllowed.get()).booleanValue() || !entry.isEditable())) {
                    ((BooleanEntry)((Object)entry)).setValue(false);
                }
                entry.setEditable((Boolean)CreateQOLConfigs.server().propellerAllowed.get() != false && (Boolean)CreateQOLConfigs.server().hoverAllowed.get() != false);
            }
            if (entry.getNbtKey().equals("elytraState")) {
                if (!((Boolean)CreateQOLConfigs.server().elytraAllowed.get()).booleanValue() && entry.isEditable()) {
                    ((BooleanEntry)((Object)entry)).setValue(false);
                }
                flag = this.list.m_6702_().stream().noneMatch(e -> {
                    BooleanEntry oEntry;
                    return e instanceof BooleanEntry && (oEntry = (BooleanEntry)((Object)((Object)e))).getNbtKey().equals("fans") && (Boolean)oEntry.getValue() != false;
                });
                entry.setEditable((Boolean)CreateQOLConfigs.server().elytraAllowed.get() != false && flag);
            }
            if (entry.getNbtKey().equals("effects")) {
                if (!((Boolean)CreateQOLConfigs.server().armorEffects.get()).booleanValue() && entry.isEditable()) {
                    ((BooleanEntry)((Object)entry)).setValue(false);
                }
                entry.setEditable((Boolean)CreateQOLConfigs.server().armorEffects.get());
            }
            if (entry.getNbtKey().equals("diving")) {
                if (!((Boolean)CreateQOLConfigs.server().bootsDiving.get()).booleanValue() && entry.isEditable()) {
                    ((BooleanEntry)((Object)entry)).setValue(false);
                }
                entry.setEditable((Boolean)CreateQOLConfigs.server().bootsDiving.get());
            }
            if (entry.getNbtKey().equals("lava")) {
                if (!((Boolean)CreateQOLConfigs.server().bootsLavaWalking.get()).booleanValue() && entry.isEditable()) {
                    ((BooleanEntry)((Object)entry)).setValue(false);
                }
                entry.setEditable((Boolean)CreateQOLConfigs.server().bootsLavaWalking.get());
            }
        });
    }

    public void m_280273_(GuiGraphics p_283688_) {
        super.m_280273_(p_283688_);
    }

    protected void renderWindowBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, -1339544524);
        shadowElement.at((float)this.f_96543_ * 0.5f, (float)this.f_96544_ * 0.5f, 0.0f).render(graphics);
        super.renderWindowBackground(graphics, mouseX, mouseY, partialTicks);
    }

    protected void prepareFrame() {
        UIRenderHelper.swapAndBlitColor((RenderTarget)this.f_96541_.m_91385_(), (RenderTarget)UIRenderHelper.framebuffer);
        RenderSystem.clear((int)1280, (boolean)Minecraft.f_91002_);
    }

    protected void endFrame() {
        UIRenderHelper.swapAndBlitColor((RenderTarget)UIRenderHelper.framebuffer, (RenderTarget)this.f_96541_.m_91385_());
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.f_96543_ / 2;
        graphics.m_280137_(this.f_96541_.f_91062_, "Configure Shadow Radiance Armor", x, 15, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        cogSpin.bump(3, -delta * 5.0);
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7043_() {
        return false;
    }

    protected static void renderCog(GuiGraphics graphics) {
        float partialTicks = Minecraft.m_91087_().m_91296_();
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(-100.0f, 100.0f, -100.0f);
        poseStack.m_85841_(200.0f, 200.0f, 1.0f);
        GuiGameElement.of((BlockState)((BlockState)AllBlocks.LARGE_COGWHEEL.getDefaultState().m_61124_((Property)CogWheelBlock.AXIS, (Comparable)Direction.Axis.Y))).rotateBlock(22.5, (double)cogSpin.getValue(partialTicks), 22.5).render(graphics);
        poseStack.m_85849_();
    }

    public List<Integer> getArmors() {
        return this.armors;
    }

    public int getSelectedItem() {
        return this.selectedItem;
    }

    public void onSelectedChange(int index) {
        this.selectedItem = index;
        this.list.m_6702_().clear();
        if (this.selectedItem == -1) {
            return;
        }
        ItemStack armor = Minecraft.m_91087_().f_91074_.m_150109_().m_36052_(this.armors.get(this.selectedItem).intValue());
        switch (((ArmorItem)armor.m_41720_()).m_266204_()) {
            case HELMET: {
                this.list.m_6702_().add(new BooleanEntry("Enable Goggles", NBTConstants.getOrDefault(armor, "goggles", true), "goggles", "Should engineer's goggle's information be displayed"));
                break;
            }
            case CHESTPLATE: {
                this.list.m_6702_().add(new BooleanEntry("Enable Custom Arms", NBTConstants.getOrDefault(armor, "arms", true), "arms", "Should the player's arms be replaced with the armor in first person"));
                if (ShadowRadianceChestplate.hasPropeller(armor)) {
                    this.list.m_6702_().add(new BooleanEntry("Enable Fans", NBTConstants.getOrDefault(armor, "fans", true), "fans", "Activate the propeller on the backtank", "_Can't be enabled if the elytra are enabled_"));
                    this.list.m_6702_().add(new BooleanEntry("Enable Hover", NBTConstants.getOrDefault(armor, "hover", false), "hover", "Activate the hover mode"));
                }
                if (ShadowRadianceChestplate.hasElytra(armor)) {
                    this.list.m_6702_().add(new BooleanEntry("Enable Elytra", NBTConstants.getOrDefault(armor, "elytraState", false), "elytraState", "Activate the elytra on the backtank", "_Can't be enabled if the fan is enabled_"));
                }
                this.list.m_6702_().add(new EnumEntry("Preferred Render", NBTConstants.getOrDefault("preferredRender", armor), "preferredRender", new String[]{"Define how the additions should be rendered.", "\"Elytra\" renders only the elytra", "\"Backtank\" renders only the backtank"}){

                    @Override
                    protected void cycleValue(int direction) {
                        List<Integer> armors = ((ArmorConfigScreen)Minecraft.m_91087_().f_91080_).getArmors();
                        int selected = ((ArmorConfigScreen)Minecraft.m_91087_().f_91080_).getSelectedItem();
                        ArmorItem item = (ArmorItem)Minecraft.m_91087_().f_91074_.m_150109_().m_36052_(armors.get(selected).intValue()).m_41720_();
                        PreferredRender e = (PreferredRender)((Object)this.getValue());
                        PreferredRender[] options = (PreferredRender[])Arrays.stream(PreferredRender.values()).filter(it -> it.canBeSelected(item)).toArray(PreferredRender[]::new);
                        e = options[Math.floorMod(e.ordinal() + direction, options.length)];
                        this.setValue(e);
                        this.bumpCog((float)direction * 15.0f);
                    }
                });
                break;
            }
            case BOOTS: {
                this.list.m_6702_().add(new BooleanEntry("Enable Belt Blocking", NBTConstants.getOrDefault(armor, "belt", true), "belt", "You won't be pushed by belt if enabled"));
                this.list.m_6702_().add(new BooleanEntry("Enable Diving", NBTConstants.getOrDefault(armor, "diving", false), "diving", "Enable diving, which makes the player descends quicker in liquids"));
                this.list.m_6702_().add(new BooleanEntry("Enable Lava Walking", NBTConstants.getOrDefault(armor, "lava", true), "lava", "Enable walking under lava, which makes the player walks normally under lava"));
                break;
            }
        }
        MobEffect effect = switch (((ArmorItem)armor.m_41720_()).m_266204_()) {
            case ArmorItem.Type.BOOTS -> MobEffects.f_19603_;
            case ArmorItem.Type.LEGGINGS -> MobEffects.f_19596_;
            case ArmorItem.Type.CHESTPLATE -> MobEffects.f_19600_;
            case ArmorItem.Type.HELMET -> MobEffects.f_19611_;
            default -> MobEffects.f_19599_;
        };
        this.list.m_6702_().add(new BooleanEntry("Apply Potion Effect", NBTConstants.getOrDefault(armor, "effects", true), "effects", "Enable the potion effect granted by the armor piece", "For this piece, the effect is " + Component.m_237115_((String)effect.m_19481_()).getString()));
        this.list.m_6702_().add(new EnumEntry("Render Type", NBTConstants.getOrDefault(armor, "renderType"), "renderType", new String[]{"Define how the armor piece should be rendered.", "\"Armor only\" renders only the armor", "\"Addition only\" renders only the additions (E.g. Backtank, Goggles)"}){

            @Override
            protected void cycleValue(int direction) {
                List<Integer> armors = ((ArmorConfigScreen)Minecraft.m_91087_().f_91080_).getArmors();
                int selected = ((ArmorConfigScreen)Minecraft.m_91087_().f_91080_).getSelectedItem();
                ArmorItem item = (ArmorItem)Minecraft.m_91087_().f_91074_.m_150109_().m_36052_(armors.get(selected).intValue()).m_41720_();
                ArmorRenderType e = (ArmorRenderType)((Object)this.getValue());
                ArmorRenderType[] options = (ArmorRenderType[])Arrays.stream(ArmorRenderType.values()).filter(it -> it.canBeSelected(item)).toArray(ArmorRenderType[]::new);
                e = options[Math.floorMod(e.ordinal() + direction, options.length)];
                this.setValue(e);
                this.bumpCog((float)direction * 15.0f);
            }
        });
    }

    public void m_6574_(Minecraft p_96575_, int p_96576_, int p_96577_) {
        super.m_6574_(p_96575_, p_96576_, p_96577_);
        this.selectedItem = -1;
    }
}

