/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.datagen.recipes;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.datagen.recipes.TFMGRecipeProvider;
import com.drmangotea.tfmg.datagen.recipes.values.create.TFMGCompactingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.create.TFMGCrushingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.create.TFMGDeployingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.create.TFMGFillingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.create.TFMGItemApplicationRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.create.TFMGMixingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.create.TFMGPressingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.tfmg.CokingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.tfmg.DistillationRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.tfmg.HotBlastRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.tfmg.PolarizingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.tfmg.WindingRecipeGen;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public abstract class TFMGProcessingRecipeGen
extends TFMGRecipeProvider {
    protected static final List<TFMGProcessingRecipeGen> GENERATORS = new ArrayList<TFMGProcessingRecipeGen>();

    public static void registerAll(DataGenerator gen, PackOutput output) {
        GENERATORS.add(new CokingRecipeGen(output));
        GENERATORS.add(new DistillationRecipeGen(output));
        GENERATORS.add(new WindingRecipeGen(output));
        GENERATORS.add(new PolarizingRecipeGen(output));
        GENERATORS.add(new HotBlastRecipeGen(output));
        GENERATORS.add(new TFMGItemApplicationRecipeGen(output));
        GENERATORS.add(new TFMGFillingRecipeGen(output));
        GENERATORS.add(new TFMGMixingRecipeGen(output));
        GENERATORS.add(new TFMGCompactingRecipeGen(output));
        GENERATORS.add(new TFMGPressingRecipeGen(output));
        GENERATORS.add(new TFMGCrushingRecipeGen(output));
        GENERATORS.add(new TFMGDeployingRecipeGen(output));
        gen.addProvider(true, new DataProvider(){

            public String m_6055_() {
                return "TFMG's Processing Recipes";
            }

            public CompletableFuture<?> m_213708_(CachedOutput dc) {
                return CompletableFuture.allOf((CompletableFuture[])GENERATORS.stream().map(gen -> gen.m_213708_(dc)).toArray(CompletableFuture[]::new));
            }
        });
    }

    public TFMGProcessingRecipeGen(PackOutput generator) {
        super(generator);
    }

    public <T extends ProcessingRecipe<?>> TFMGRecipeProvider.GeneratedRecipe create(String namespace, Supplier<ItemLike> singleIngredient, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        ProcessingRecipeSerializer serializer = this.getSerializer();
        TFMGRecipeProvider.GeneratedRecipe generatedRecipe = c -> {
            ItemLike itemLike = (ItemLike)singleIngredient.get();
            ((ProcessingRecipeBuilder)transform.apply(new ProcessingRecipeBuilder(serializer.getFactory(), new ResourceLocation(namespace, CatnipServices.REGISTRIES.getKeyOrThrow(itemLike.m_5456_()).m_135815_())).withItemIngredients(new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike})}))).build(c);
        };
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    public <T extends ProcessingRecipe<?>> TFMGRecipeProvider.GeneratedRecipe create(Supplier<ItemLike> singleIngredient, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        return this.create("tfmg", singleIngredient, transform);
    }

    protected <T extends ProcessingRecipe<?>> TFMGRecipeProvider.GeneratedRecipe createWithDeferredId(Supplier<ResourceLocation> name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        ProcessingRecipeSerializer serializer = this.getSerializer();
        TFMGRecipeProvider.GeneratedRecipe generatedRecipe = c -> ((ProcessingRecipeBuilder)transform.apply(new ProcessingRecipeBuilder(serializer.getFactory(), (ResourceLocation)name.get()))).build(c);
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    public <T extends ProcessingRecipe<?>> TFMGRecipeProvider.GeneratedRecipe create(ResourceLocation name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        return this.createWithDeferredId(() -> name, transform);
    }

    public <T extends ProcessingRecipe<?>> TFMGRecipeProvider.GeneratedRecipe create(String name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        return this.create(TFMG.asResource(name), transform);
    }

    protected abstract IRecipeTypeInfo getRecipeType();

    protected <T extends ProcessingRecipe<?>> ProcessingRecipeSerializer<T> getSerializer() {
        return (ProcessingRecipeSerializer)this.getRecipeType().getSerializer();
    }

    protected Supplier<ResourceLocation> idWithSuffix(Supplier<ItemLike> item, String suffix) {
        return () -> {
            ResourceLocation registryName = CatnipServices.REGISTRIES.getKeyOrThrow(((ItemLike)item.get()).m_5456_());
            return TFMG.asResource(registryName.m_135815_() + suffix);
        };
    }
}

