/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.items.weapons.flamethrover;

import com.drmangotea.tfmg.TFMGClient;
import com.drmangotea.tfmg.base.spark.Spark;
import com.drmangotea.tfmg.registry.TFMGEntityTypes;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.item.CustomArmPoseItem;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FlamethrowerItem
extends Item
implements CustomArmPoseItem {
    public static final int FUEL_CAPACITY = 4000;

    public FlamethrowerItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int time) {
        Spark spark = (Spark)TFMGEntityTypes.SPARK.create(level);
        spark.m_6034_(entity.m_20185_(), entity.m_20186_() + (double)1.2f, entity.m_20189_());
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128451_("amount") == 0) {
            nbt.m_128359_("fuel", "");
            return;
        }
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11937_, SoundSource.NEUTRAL, 0.1f, 0.04f);
        FlamethrowerFuel fuel = Enum.valueOf(FlamethrowerFuel.class, nbt.m_128461_("fuel").toUpperCase());
        for (int i = 0; i < fuel.amount; ++i) {
            if (nbt.m_128451_("amount") == 0) {
                nbt.m_128359_("fuel", "");
                return;
            }
            nbt.m_128405_("amount", nbt.m_128451_("amount") - 1);
            spark.m_6686_(entity.m_20154_().f_82479_, entity.m_20154_().f_82480_, entity.m_20154_().f_82481_, fuel.speed, fuel.spread);
            level.m_7967_((Entity)spark);
        }
    }

    public int m_8105_(ItemStack p_77626_1_) {
        return 696969;
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41784_().m_128451_("amount") != 0;
    }

    public int m_142159_(ItemStack stack) {
        return stack.m_41784_().m_128461_("fuel").isEmpty() ? 0xFFFFFF : Enum.valueOf(FlamethrowerFuel.class, (String)stack.m_41784_().m_128461_((String)"fuel").toUpperCase()).color;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * ((float)stack.m_41784_().m_128451_("amount") / 4000.0f));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        if (level.f_46443_) {
            TFMGClient.FLAMETHROWER_RENDER_HANDLER.dontAnimateItem(hand);
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockEntity blockEntity;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        CompoundTag nbt = stack.m_41784_();
        if (level.m_7702_(pos) != null && (blockEntity = level.m_7702_(pos)) instanceof FluidTankBlockEntity) {
            FluidTankBlockEntity fluidTankBe = (FluidTankBlockEntity)blockEntity;
            FluidTankBlockEntity be = fluidTankBe.isController() ? fluidTankBe : fluidTankBe.getControllerBE();
            for (FlamethrowerFuel fuel : FlamethrowerFuel.values()) {
                String fluid = be.getFluid(0).getFluid().getFluidType().toString().replaceFirst("tfmg:", "");
                if (!fluid.equals(fuel.name().toLowerCase()) || !nbt.m_128461_("fuel").equals(fluid) && nbt.m_128451_("amount") != 0) continue;
                int toDrain = Math.min(4000 - nbt.m_128451_("amount"), be.getFluid(0).getAmount());
                nbt.m_128359_("fuel", fluid);
                be.getTankInventory().drain(toDrain, IFluidHandler.FluidAction.EXECUTE);
                nbt.m_128405_("amount", nbt.m_128451_("amount") + toDrain);
                context.m_43723_().m_36335_().m_41524_(stack.m_41720_(), 20);
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public HumanoidModel.ArmPose getArmPose(ItemStack stack, AbstractClientPlayer player, InteractionHand hand) {
        if (!player.f_20911_) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return null;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.NONE;
    }

    static enum FlamethrowerFuel {
        GASOLINE(15.0f, 1.0f, 3, 12888694),
        DIESEL(7.0f, 2.0f, 3, 12226935),
        KEROSENE(10.0f, 1.3f, 4, 7894741),
        NAPHTHA(20.0f, 0.8f, 1, 6167306),
        LPG(35.0f, 0.6f, 15, 14728008),
        NAPALM(20.0f, 1.8f, 15, 10733129),
        MOLTEN_SLAG(15.0f, 0.3f, 15, 16750113);

        public final float spread;
        public final float speed;
        public final int amount;
        public final int color;

        private FlamethrowerFuel(float spread, float speed, int amount, int color) {
            this.spread = spread;
            this.speed = speed;
            this.amount = amount;
            this.color = color;
        }
    }
}

