/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.fuse_block;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.base.UpdateInFrontPacket;
import com.drmangotea.tfmg.content.electricity.utilities.diode.ElectricDiodeBlockEntity;
import com.drmangotea.tfmg.registry.TFMGPackets;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;

public class FuseBlockEntity
extends ElectricDiodeBlockEntity {
    public ItemStack fuse = ItemStack.f_41583_;
    boolean testFuse = false;

    public FuseBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void updateInFront() {
        IElectric be;
        if (!this.f_58857_.f_46443_) {
            TFMGPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new UpdateInFrontPacket(BlockPos.m_122022_((long)this.getPos())));
        }
        Direction facing = this.m_58900_().m_61138_((Property)DirectionalBlock.f_52588_) ? (Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_) : ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122428_();
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId() && be.hasElectricitySlot(facing.m_122424_())) {
            be.updateNextTick();
        }
        this.sendStuff();
        this.m_6596_();
    }

    @Override
    public float resistance() {
        IElectric be;
        if (!this.hasFuse()) {
            return 0.0f;
        }
        Direction facing = ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122428_();
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId() && be.hasElectricitySlot(facing.m_122424_())) {
            return Math.max(be.getNetworkResistance(), 0);
        }
        return 0.0f;
    }

    @Override
    public void onNetworkChanged(int oldVoltage, int oldPower) {
        super.onNetworkChanged(oldVoltage, oldPower);
        if (this.hasFuse() && this.getData().highestCurrent >= (float)this.fuse.m_41784_().m_128451_("AmpRating")) {
            this.blowFuse();
            this.updateNetwork();
            this.updateInFront();
        }
        Direction facing = ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122428_();
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric) {
            IElectric be = (IElectric)blockEntity;
            if (this.hasFuse() && be.getData().highestCurrent >= (float)this.fuse.m_41784_().m_128451_("AmpRating")) {
                this.blowFuse();
                this.updateNetwork();
                this.updateInFront();
            }
        }
    }

    @Override
    public void setVoltage(int newVoltage) {
        super.setVoltage(newVoltage);
        Direction facing = ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122428_();
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric) {
            IElectric be = (IElectric)blockEntity;
            if (this.hasFuse() && be.getData().highestCurrent >= (float)this.fuse.m_41784_().m_128451_("AmpRating")) {
                this.blowFuse();
                this.updateNetwork();
                this.updateInFront();
            }
        }
        if (this.hasFuse() && this.getData().highestCurrent >= (float)this.fuse.m_41784_().m_128451_("AmpRating")) {
            this.blowFuse();
            this.updateNetwork();
            this.updateInFront();
        }
        this.testFuse = true;
    }

    public void testFuse() {
        Direction facing = ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122428_();
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric) {
            IElectric be = (IElectric)blockEntity;
            if (this.hasFuse() && be.getData().highestCurrent >= (float)this.fuse.m_41784_().m_128451_("AmpRating")) {
                this.blowFuse();
                this.updateNetwork();
                this.updateInFront();
            }
        }
        if (this.hasFuse() && this.getData().highestCurrent >= (float)this.fuse.m_41784_().m_128451_("AmpRating")) {
            this.blowFuse();
            this.updateNetwork();
            this.updateInFront();
        }
        this.testFuse = true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.testFuse) {
            this.testFuse();
            this.testFuse = false;
        }
        Direction facing = ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122428_();
    }

    @Override
    public void updateNextTick() {
        super.updateNextTick();
    }

    @Override
    public int getOutputVoltage() {
        return this.fuse.m_41619_() ? 0 : super.getOutputVoltage();
    }

    @Override
    public int getOutputPower() {
        return this.fuse.m_41619_() ? 0 : super.getOutputPower();
    }

    public boolean hasFuse() {
        return !this.fuse.m_41619_();
    }

    public void blowFuse() {
        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11983_, SoundSource.BLOCKS, 2.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 0.8f);
        this.fuse = ItemStack.f_41583_;
        TFMGUtils.spawnElectricParticles(this.f_58857_, this.m_58899_());
        this.sendStuff();
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122427_();
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToTooltip(tooltip, isPlayerSneaking);
        return true;
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("Fuse", (Tag)this.fuse.serializeNBT());
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.fuse = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Fuse"));
    }
}

