/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.vanillin.visuals;

import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.vanillin.visuals.MinecartVisual;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class TntMinecartVisual<T extends MinecartTNT>
extends MinecartVisual<T> {
    private static final int WHITE_OVERLAY = OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)1.0f), (int)10);

    public TntMinecartVisual(VisualizationContext ctx, T entity, float partialTick) {
        super(ctx, entity, partialTick, ModelLayers.f_171253_);
    }

    @Override
    protected void updateContents(TransformedInstance contents, Matrix4f pose, float partialTick) {
        int fuseTime = ((MinecartTNT)this.entity).m_38694_();
        if (fuseTime > -1 && (float)fuseTime - partialTick + 1.0f < 10.0f) {
            float f = 1.0f - ((float)fuseTime - partialTick + 1.0f) / 10.0f;
            f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            float scale = 1.0f + f * 0.3f;
            pose.scale(scale);
        }
        int overlay = fuseTime > -1 && fuseTime / 5 % 2 == 0 ? WHITE_OVERLAY : OverlayTexture.f_118083_;
        contents.setTransform((Matrix4fc)pose).overlay(overlay).setChanged();
    }
}

