/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.vanillin.visuals;

import dev.engine_room.flywheel.api.instance.InstancerProvider;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.TickableVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.material.SimpleMaterial;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.part.InstanceTree;
import dev.engine_room.flywheel.lib.model.part.ModelTree;
import dev.engine_room.flywheel.lib.model.part.ModelTrees;
import dev.engine_room.flywheel.lib.visual.AbstractEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.engine_room.flywheel.lib.visual.SimpleTickableVisual;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public class MinecartVisual<T extends AbstractMinecart>
extends AbstractEntityVisual<T>
implements SimpleTickableVisual,
SimpleDynamicVisual {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/minecart.png");
    private static final Material MATERIAL = SimpleMaterial.builder().texture(TEXTURE).mipmap(false).build();
    private final InstanceTree instances;
    @Nullable
    private TransformedInstance contents;
    private final Matrix4fStack stack = new Matrix4fStack(2);
    private BlockState blockState;

    public MinecartVisual(VisualizationContext ctx, T entity, float partialTick, ModelLayerLocation layerLocation) {
        super(ctx, entity, partialTick);
        this.instances = InstanceTree.create((InstancerProvider)this.instancerProvider(), (ModelTree)ModelTrees.of((ModelLayerLocation)layerLocation, (Material)MATERIAL));
        this.blockState = entity.m_38178_();
        this.contents = this.createContentsInstance();
        this.updateInstances(partialTick);
        this.updateLight(partialTick);
    }

    @Nullable
    private TransformedInstance createContentsInstance() {
        RenderShape shape = this.blockState.m_60799_();
        if (shape == RenderShape.ENTITYBLOCK_ANIMATED) {
            this.instances.visible(false);
            return null;
        }
        if (shape == RenderShape.INVISIBLE) {
            return null;
        }
        return (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.block((BlockState)this.blockState)).createInstance();
    }

    public void tick(TickableVisual.Context context) {
        BlockState displayBlockState = ((AbstractMinecart)this.entity).m_38178_();
        if (displayBlockState != this.blockState) {
            this.blockState = displayBlockState;
            if (this.contents != null) {
                this.contents.delete();
            }
            this.contents = this.createContentsInstance();
        }
    }

    public void beginFrame(DynamicVisual.Context context) {
        if (!this.isVisible(context.frustum())) {
            return;
        }
        if (!this.instances.visible()) {
            return;
        }
        this.updateInstances(context.partialTick());
    }

    private void updateInstances(float partialTick) {
        this.stack.identity();
        double posX = Mth.m_14139_((double)partialTick, (double)((AbstractMinecart)this.entity).f_19790_, (double)((AbstractMinecart)this.entity).m_20185_());
        double posY = Mth.m_14139_((double)partialTick, (double)((AbstractMinecart)this.entity).f_19791_, (double)((AbstractMinecart)this.entity).m_20186_());
        double posZ = Mth.m_14139_((double)partialTick, (double)((AbstractMinecart)this.entity).f_19792_, (double)((AbstractMinecart)this.entity).m_20189_());
        Vec3i renderOrigin = this.renderOrigin();
        this.stack.translate((float)(posX - (double)renderOrigin.m_123341_()), (float)(posY - (double)renderOrigin.m_123342_()), (float)(posZ - (double)renderOrigin.m_123343_()));
        float yaw = Mth.m_14179_((float)partialTick, (float)((AbstractMinecart)this.entity).f_19859_, (float)((AbstractMinecart)this.entity).m_146908_());
        long randomBits = (long)((AbstractMinecart)this.entity).m_19879_() * 493286711L;
        randomBits = randomBits * randomBits * 4392167121L + randomBits * 98761L;
        float nudgeX = (((float)(randomBits >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float nudgeY = (((float)(randomBits >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float nudgeZ = (((float)(randomBits >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        this.stack.translate(nudgeX, nudgeY, nudgeZ);
        Vec3 pos = ((AbstractMinecart)this.entity).m_38179_(posX, posY, posZ);
        float pitch = Mth.m_14179_((float)partialTick, (float)((AbstractMinecart)this.entity).f_19860_, (float)((AbstractMinecart)this.entity).m_146909_());
        if (pos != null) {
            Vec3 offset1 = ((AbstractMinecart)this.entity).m_38096_(posX, posY, posZ, (double)0.3f);
            Vec3 offset2 = ((AbstractMinecart)this.entity).m_38096_(posX, posY, posZ, (double)-0.3f);
            if (offset1 == null) {
                offset1 = pos;
            }
            if (offset2 == null) {
                offset2 = pos;
            }
            this.stack.translate((float)(pos.f_82479_ - posX), (float)((offset1.f_82480_ + offset2.f_82480_) / 2.0 - posY), (float)(pos.f_82481_ - posZ));
            Vec3 vec = offset2.m_82520_(-offset1.f_82479_, -offset1.f_82480_, -offset1.f_82481_);
            if (vec.m_82553_() != 0.0) {
                vec = vec.m_82541_();
                yaw = (float)(Math.atan2(vec.f_82481_, vec.f_82479_) * 180.0 / Math.PI);
                pitch = (float)(Math.atan(vec.f_82480_) * 73.0);
            }
        }
        this.stack.translate(0.0f, 0.375f, 0.0f);
        this.stack.rotateY((180.0f - yaw) * ((float)Math.PI / 180));
        this.stack.rotateZ(-pitch * ((float)Math.PI / 180));
        float hurtTime = (float)((AbstractMinecart)this.entity).m_38176_() - partialTick;
        float damage = ((AbstractMinecart)this.entity).m_38169_() - partialTick;
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        if (hurtTime > 0.0f) {
            this.stack.rotateX(Mth.m_14031_((float)hurtTime) * hurtTime * damage / 10.0f * (float)((AbstractMinecart)this.entity).m_38177_() * ((float)Math.PI / 180));
        }
        if (this.contents != null) {
            int displayOffset = ((AbstractMinecart)this.entity).m_38183_();
            this.stack.pushMatrix();
            this.stack.scale(0.75f, 0.75f, 0.75f);
            this.stack.translate(-0.5f, (float)(displayOffset - 8) / 16.0f, 0.5f);
            this.stack.rotateY(1.5707964f);
            this.updateContents(this.contents, (Matrix4f)this.stack, partialTick);
            this.stack.popMatrix();
        }
        this.stack.scale(-1.0f, -1.0f, 1.0f);
        this.instances.updateInstances((Matrix4fc)this.stack);
        this.updateLight(partialTick);
    }

    protected void updateContents(TransformedInstance contents, Matrix4f pose, float partialTick) {
        contents.setTransform((Matrix4fc)pose).setChanged();
    }

    public void updateLight(float partialTick) {
        int packedLight = this.computePackedLight(partialTick);
        this.instances.traverse(instance -> instance.light(packedLight).setChanged());
        FlatLit.relight((int)packedLight, (FlatLit[])new FlatLit[]{this.contents});
    }

    protected void _delete() {
        this.instances.delete();
        if (this.contents != null) {
            this.contents.delete();
        }
    }

    public static boolean shouldSkipRender(AbstractMinecart minecart) {
        return minecart.m_38178_().m_60799_() != RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

