/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.vanillin.visuals;

import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.InstancerProvider;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.SectionTrackedVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.material.CutoutShaders;
import dev.engine_room.flywheel.lib.material.SimpleMaterial;
import dev.engine_room.flywheel.lib.model.part.InstanceTree;
import dev.engine_room.flywheel.lib.model.part.ModelTree;
import dev.engine_room.flywheel.lib.model.part.ModelTrees;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ChestVisual<T extends BlockEntity>
extends AbstractBlockEntityVisual<T>
implements SimpleDynamicVisual {
    private static final Material MATERIAL = SimpleMaterial.builder().cutout(CutoutShaders.ONE_TENTH).texture(Sheets.f_110740_).mipmap(false).build();
    private static final Map<ChestType, ModelLayerLocation> LAYER_LOCATIONS = new EnumMap<ChestType, ModelLayerLocation>(ChestType.class);
    @Nullable
    private final InstanceTree instances;
    @Nullable
    private final InstanceTree lid;
    @Nullable
    private final InstanceTree lock;
    @Nullable
    private final Matrix4fc initialPose;
    private final BrightnessCombiner brightnessCombiner = new BrightnessCombiner();
    @Nullable
    private final DoubleBlockCombiner.NeighborCombineResult<? extends ChestBlockEntity> neighborCombineResult;
    @Nullable
    private final Float2FloatFunction lidProgress;
    private float lastProgress = Float.NaN;

    public ChestVisual(VisualizationContext ctx, T blockEntity, float partialTick) {
        super(ctx, blockEntity, partialTick);
        Block block = this.blockState.m_60734_();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock chestBlock = (AbstractChestBlock)block;
            ChestType chestType = this.blockState.m_61138_((Property)ChestBlock.f_51479_) ? (ChestType)this.blockState.m_61143_((Property)ChestBlock.f_51479_) : ChestType.SINGLE;
            net.minecraft.client.resources.model.Material texture = Sheets.m_110767_(blockEntity, (ChestType)chestType, (boolean)ChestVisual.isChristmas());
            this.instances = InstanceTree.create((InstancerProvider)this.instancerProvider(), (ModelTree)ModelTrees.of((ModelLayerLocation)LAYER_LOCATIONS.get(chestType), (net.minecraft.client.resources.model.Material)texture, (Material)MATERIAL));
            this.lid = this.instances.childOrThrow("lid");
            this.lock = this.instances.childOrThrow("lock");
            this.initialPose = this.createInitialPose();
            this.neighborCombineResult = chestBlock.m_5641_(this.blockState, this.level, this.pos, true);
            this.lidProgress = (Float2FloatFunction)this.neighborCombineResult.m_5649_(ChestBlock.m_51517_((LidBlockEntity)((LidBlockEntity)blockEntity)));
            this.lastProgress = this.lidProgress.get(partialTick);
            this.applyLidTransform(this.lastProgress);
        } else {
            this.instances = null;
            this.lid = null;
            this.lock = null;
            this.initialPose = null;
            this.neighborCombineResult = null;
            this.lidProgress = null;
        }
    }

    private static boolean isChristmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
    }

    private Matrix4f createInitialPose() {
        BlockPos visualPos = this.getVisualPosition();
        float horizontalAngle = ((Direction)this.blockState.m_61143_((Property)ChestBlock.f_51478_)).m_122435_();
        return new Matrix4f().translate((float)visualPos.m_123341_(), (float)visualPos.m_123342_(), (float)visualPos.m_123343_()).translate(0.5f, 0.5f, 0.5f).rotateY(-horizontalAngle * ((float)Math.PI / 180)).translate(-0.5f, -0.5f, -0.5f);
    }

    public void setSectionCollector(SectionTrackedVisual.SectionCollector sectionCollector) {
        this.lightSections = sectionCollector;
        if (this.neighborCombineResult != null) {
            this.lightSections.sections((LongSet)this.neighborCombineResult.m_5649_((DoubleBlockCombiner.Combiner)new SectionPosCombiner()));
        } else {
            this.lightSections.sections(LongSet.of((long)SectionPos.m_175568_((BlockPos)this.pos)));
        }
    }

    public void beginFrame(DynamicVisual.Context context) {
        if (this.instances == null) {
            return;
        }
        if (this.doDistanceLimitThisFrame(context) || !this.isVisible(context.frustum())) {
            return;
        }
        float progress = this.lidProgress.get(context.partialTick());
        if (this.lastProgress == progress) {
            return;
        }
        this.lastProgress = progress;
        this.applyLidTransform(progress);
    }

    private void applyLidTransform(float progress) {
        progress = 1.0f - progress;
        progress = 1.0f - progress * progress * progress;
        this.lid.xRot(-(progress * 1.5707964f));
        this.lock.xRot(this.lid.xRot());
        this.instances.updateInstancesStatic(this.initialPose);
    }

    public void updateLight(float partialTick) {
        if (this.instances != null) {
            int packedLight = (Integer)this.neighborCombineResult.m_5649_((DoubleBlockCombiner.Combiner)this.brightnessCombiner);
            this.instances.traverse(instance -> instance.light(packedLight).setChanged());
        }
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        if (this.instances != null) {
            this.instances.traverse(consumer);
        }
    }

    protected void _delete() {
        if (this.instances != null) {
            this.instances.delete();
        }
    }

    static {
        LAYER_LOCATIONS.put(ChestType.SINGLE, ModelLayers.f_171275_);
        LAYER_LOCATIONS.put(ChestType.LEFT, ModelLayers.f_171133_);
        LAYER_LOCATIONS.put(ChestType.RIGHT, ModelLayers.f_171134_);
    }

    private class BrightnessCombiner
    implements DoubleBlockCombiner.Combiner<BlockEntity, Integer> {
        private BrightnessCombiner() {
        }

        public Integer acceptDouble(BlockEntity first, BlockEntity second) {
            int firstLight = LevelRenderer.m_109541_((BlockAndTintGetter)first.m_58904_(), (BlockPos)first.m_58899_());
            int secondLight = LevelRenderer.m_109541_((BlockAndTintGetter)second.m_58904_(), (BlockPos)second.m_58899_());
            int firstBlockLight = LightTexture.m_109883_((int)firstLight);
            int secondBlockLight = LightTexture.m_109883_((int)secondLight);
            int firstSkyLight = LightTexture.m_109894_((int)firstLight);
            int secondSkyLight = LightTexture.m_109894_((int)secondLight);
            return LightTexture.m_109885_((int)Math.max(firstBlockLight, secondBlockLight), (int)Math.max(firstSkyLight, secondSkyLight));
        }

        public Integer acceptSingle(BlockEntity single) {
            return LevelRenderer.m_109541_((BlockAndTintGetter)single.m_58904_(), (BlockPos)single.m_58899_());
        }

        public Integer acceptNone() {
            return LevelRenderer.m_109541_((BlockAndTintGetter)ChestVisual.this.level, (BlockPos)ChestVisual.this.pos);
        }
    }

    private class SectionPosCombiner
    implements DoubleBlockCombiner.Combiner<BlockEntity, LongSet> {
        private SectionPosCombiner() {
        }

        public LongSet acceptDouble(BlockEntity first, BlockEntity second) {
            long secondSection;
            long firstSection = SectionPos.m_175568_((BlockPos)first.m_58899_());
            if (firstSection == (secondSection = SectionPos.m_175568_((BlockPos)second.m_58899_()))) {
                return LongSet.of((long)firstSection);
            }
            return LongSet.of((long)firstSection, (long)secondSection);
        }

        public LongSet acceptSingle(BlockEntity single) {
            return LongSet.of((long)SectionPos.m_175568_((BlockPos)single.m_58899_()));
        }

        public LongSet acceptNone() {
            return LongSet.of((long)SectionPos.m_175568_((BlockPos)ChestVisual.this.pos));
        }
    }
}

