/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.vanillin;

import dev.engine_room.vanillin.VanillinXplat;
import dev.engine_room.vanillin.VisualElements;
import dev.engine_room.vanillin.compose.ComposableEntityVisual;
import dev.engine_room.vanillin.compose.ConfiguredElement;
import dev.engine_room.vanillin.compose.ConfiguredElementImpl;
import dev.engine_room.vanillin.compose.VisualElement;
import dev.engine_room.vanillin.compose.VisualizationPredicate;
import dev.engine_room.vanillin.config.BlockEntityVisualizerBuilder;
import dev.engine_room.vanillin.config.Configurator;
import dev.engine_room.vanillin.config.EntityVisualizerBuilder;
import dev.engine_room.vanillin.elements.ShadowElement;
import dev.engine_room.vanillin.visuals.BellVisual;
import dev.engine_room.vanillin.visuals.BlockDisplayVisual;
import dev.engine_room.vanillin.visuals.ChestVisual;
import dev.engine_room.vanillin.visuals.ItemDisplayVisual;
import dev.engine_room.vanillin.visuals.ItemFrameVisual;
import dev.engine_room.vanillin.visuals.ItemVisual;
import dev.engine_room.vanillin.visuals.MinecartVisual;
import dev.engine_room.vanillin.visuals.ShulkerBoxVisual;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public class VanillaVisuals {
    public static final Configurator CONFIGURATOR = new Configurator();
    public static final boolean STABLE = true;
    public static final boolean EXPERIMENTAL = VanillinXplat.INSTANCE.isDevelopmentEnvironment();

    public static void init() {
        VanillaVisuals.builder(BlockEntityType.f_58918_).factory(ChestVisual::new).apply(true);
        VanillaVisuals.builder(BlockEntityType.f_58920_).factory(ChestVisual::new).apply(true);
        VanillaVisuals.builder(BlockEntityType.f_58919_).factory(ChestVisual::new).apply(true);
        VanillaVisuals.builder(BlockEntityType.f_58909_).factory(BellVisual::new).apply(true);
        VanillaVisuals.builder(BlockEntityType.f_58939_).factory(ShulkerBoxVisual::new).apply(true);
        VanillaVisuals.builder(EntityType.f_268573_).factory(BlockDisplayVisual::new).apply(true);
        VanillaVisuals.composable(EntityType.f_268643_).with(VanillaVisuals.element(VisualElements.ITEM_DISPLAY).build()).shouldVisualize((ctx, e) -> ItemDisplayVisual.shouldVisualize(e)).build().skipVanillaRender(ItemDisplayVisual::shouldVisualize).apply(EXPERIMENTAL);
        VanillaVisuals.minecart(EntityType.f_20470_, ModelLayers.f_171276_).apply(true);
        VanillaVisuals.minecart(EntityType.f_20471_, ModelLayers.f_171279_).apply(true);
        VanillaVisuals.minecart(EntityType.f_20472_, ModelLayers.f_171149_).apply(true);
        VanillaVisuals.minecart(EntityType.f_20473_, ModelLayers.f_171185_).apply(true);
        VanillaVisuals.minecart(EntityType.f_20469_, ModelLayers.f_171198_).apply(true);
        VanillaVisuals.minecart(EntityType.f_20474_, ModelLayers.f_171244_).apply(true);
        VanillaVisuals.composable(EntityType.f_20475_).apply(VanillaVisuals::commonElements).with(VanillaVisuals.element(VisualElements.SHADOW).configure(new ShadowElement.Config(0.7f, 1.0f)).build()).with(VanillaVisuals.element(VisualElements.FIRE).build()).with(VanillaVisuals.element(VisualElements.TNT_MINECART).build()).build().skipVanillaRender(MinecartVisual::shouldSkipRender).apply(true);
        VanillaVisuals.itemFrame(EntityType.f_20462_).apply(EXPERIMENTAL);
        VanillaVisuals.itemFrame(EntityType.f_147033_).apply(EXPERIMENTAL);
        VanillaVisuals.composable(EntityType.f_20461_).apply(VanillaVisuals::commonElements).with(VanillaVisuals.element(VisualElements.FIRE).build()).with(VanillaVisuals.element(VisualElements.SHADOW).configure(new ShadowElement.Config(0.15f, 0.75f)).build()).with(VanillaVisuals.element(VisualElements.ITEM_ENTITY).build()).shouldVisualize((ctx, entity) -> ItemVisual.isSupported(entity)).build().skipVanillaRender(ItemVisual::isSupported).apply(EXPERIMENTAL);
    }

    public static <T extends Entity> void commonElements(EntityBuilder<T> builder) {
        builder.with(VanillaVisuals.element(VisualElements.HITBOX).configure(false).build());
    }

    public static <T extends ItemFrame> EntityVisualizerBuilder<T> itemFrame(EntityType<T> type) {
        return VanillaVisuals.composable(type).apply(VanillaVisuals::commonElements).with(VanillaVisuals.element(VisualElements.ITEM_FRAME).build()).shouldVisualize((ctx, entity) -> ItemFrameVisual.shouldVisualize(entity)).build().skipVanillaRender(ItemFrameVisual::shouldVisualize);
    }

    public static <T extends AbstractMinecart> EntityVisualizerBuilder<T> minecart(EntityType<T> type, ModelLayerLocation variant) {
        return VanillaVisuals.composable(type).apply(VanillaVisuals::commonElements).with(VanillaVisuals.element(VisualElements.SHADOW).configure(new ShadowElement.Config(0.7f, 1.0f)).build()).with(VanillaVisuals.element(VisualElements.FIRE).build()).with(VanillaVisuals.element(VisualElements.MINECART).configure(variant).build()).build().skipVanillaRender(MinecartVisual::shouldSkipRender);
    }

    public static <T extends Entity> EntityBuilder<T> composable(EntityType<T> entityType) {
        return new EntityBuilder<T>(entityType);
    }

    public static <T, C> ConfiguredElementImpl.ConfiguredElementBuilder<T, C> element(VisualElement<T, C> element) {
        return new ConfiguredElementImpl.ConfiguredElementBuilder<T, C>(element);
    }

    public static <T extends BlockEntity> BlockEntityVisualizerBuilder<T> builder(BlockEntityType<T> type) {
        return new BlockEntityVisualizerBuilder<T>(CONFIGURATOR, type);
    }

    public static <T extends Entity> EntityVisualizerBuilder<T> builder(EntityType<T> type) {
        return new EntityVisualizerBuilder<T>(CONFIGURATOR, type);
    }

    public static class EntityBuilder<T extends Entity> {
        private final List<ConfiguredElement<? super T>> elements = new ArrayList<ConfiguredElement<? super T>>();
        private final EntityType<T> entityType;
        @Nullable
        private VisualizationPredicate<T> predicate;

        public EntityBuilder(EntityType<T> entityType) {
            this.entityType = entityType;
        }

        public EntityBuilder<T> shouldVisualize(VisualizationPredicate<T> predicate) {
            this.predicate = predicate;
            return this;
        }

        public EntityBuilder<T> with(ConfiguredElement<? super T> element) {
            this.elements.add(element);
            return this;
        }

        public EntityBuilder<T> apply(Consumer<EntityBuilder<T>> mutate) {
            mutate.accept(this);
            return this;
        }

        public EntityVisualizerBuilder<T> build() {
            ConfiguredElement[] elementsArray = this.elements.toArray(new ConfiguredElement[0]);
            if (this.predicate == null) {
                this.predicate = VisualizationPredicate.alwaysTrue();
            }
            ComposableEntityVisual.Controller controller = new ComposableEntityVisual.Controller(elementsArray, this.predicate);
            return VanillaVisuals.builder(this.entityType).factory((ctx, entity, partialTick) -> new ComposableEntityVisual<Entity>(ctx, entity, partialTick, controller));
        }
    }
}

