/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.bogey_menu.handler;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.api.bogeymenu.v0.entry.BogeyEntry;
import com.railwayteam.railways.registry.CRBogeyStyles;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.foundation.gui.widget.Indicator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.data.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BogeyMenuHandlerClient {
    private static final Map<BogeyStyle, List<Pair<BogeyStyle, BogeySizes.BogeySize>>> CACHED_RENDER_CYCLES = new HashMap<BogeyStyle, List<Pair<BogeyStyle, BogeySizes.BogeySize>>>();
    private static final Map<BogeyEntry, Indicator.State[]> CACHED_COMPATS = new HashMap<BogeyEntry, Indicator.State[]>();
    @Nullable
    private static List<BogeyStyle> favorites = null;

    public static void addFavorite(BogeyStyle style) {
        if (favorites == null) {
            BogeyMenuHandlerClient.loadFavorites();
        }
        if (favorites.contains(style)) {
            return;
        }
        favorites.add(style);
        BogeyMenuHandlerClient.saveFavorites();
    }

    public static void removeFavorite(BogeyStyle style) {
        if (favorites == null) {
            BogeyMenuHandlerClient.loadFavorites();
        }
        if (!favorites.contains(style)) {
            return;
        }
        favorites.remove(style);
        BogeyMenuHandlerClient.saveFavorites();
    }

    public static void toggleFavorite(BogeyStyle style) {
        if (favorites == null) {
            BogeyMenuHandlerClient.loadFavorites();
        }
        if (favorites.contains(style)) {
            BogeyMenuHandlerClient.removeFavorite(style);
        } else {
            BogeyMenuHandlerClient.addFavorite(style);
        }
    }

    public static boolean isFavorited(BogeyStyle style) {
        if (favorites == null) {
            BogeyMenuHandlerClient.loadFavorites();
        }
        return favorites.contains(style);
    }

    @NotNull
    public static List<BogeyStyle> getFavorites() {
        if (favorites == null) {
            BogeyMenuHandlerClient.loadFavorites();
        }
        return favorites;
    }

    private static void optimizeFavorites() {
        ArrayList<BogeyStyle> newFavorites = new ArrayList<BogeyStyle>();
        for (BogeyStyle style : BogeyMenuHandlerClient.getFavorites()) {
            if (newFavorites.contains(style)) continue;
            newFavorites.add(style);
        }
        favorites = newFavorites;
        BogeyMenuHandlerClient.saveFavorites();
    }

    private static void loadFavorites() {
        favorites = new ArrayList<BogeyStyle>();
        try {
            Minecraft mc = Minecraft.m_91087_();
            File file = new File(mc.f_91069_, "snr_favorite_styles.nbt");
            CompoundTag tag = NbtIo.m_128953_((File)file);
            if (tag == null) {
                return;
            }
            if (tag.m_128425_("Favorites", 9)) {
                ListTag favoritesList = tag.m_128437_("Favorites", 8);
                if (favorites == null) {
                    favorites = new ArrayList<BogeyStyle>();
                }
                favorites.clear();
                for (Tag favoriteTag : favoritesList) {
                    StringTag stringTag;
                    ResourceLocation loc;
                    if (!(favoriteTag instanceof StringTag) || (loc = ResourceLocation.m_135820_((String)(stringTag = (StringTag)favoriteTag).m_7916_())) == null || !AllBogeyStyles.BOGEY_STYLES.containsKey(loc)) continue;
                    favorites.add((BogeyStyle)AllBogeyStyles.BOGEY_STYLES.get(loc));
                }
            }
            BogeyMenuHandlerClient.optimizeFavorites();
        }
        catch (Exception e) {
            Railways.LOGGER.error("Failed to load favorite styles", (Throwable)e);
        }
    }

    private static void saveFavorites() {
        if (favorites == null) {
            return;
        }
        try {
            CompoundTag tag = new CompoundTag();
            ListTag listTag = new ListTag();
            for (BogeyStyle style : favorites) {
                listTag.add((Object)StringTag.m_129297_((String)style.displayName.toString()));
            }
            tag.m_128365_("Favorites", (Tag)listTag);
            NbtIo.m_128955_((CompoundTag)tag, (File)new File(Minecraft.m_91087_().f_91069_, "snr_favorite_styles.nbt"));
        }
        catch (Exception e) {
            Railways.LOGGER.error("Failed to save favorite styles", (Throwable)e);
        }
    }

    @Nullable
    public static BogeySizes.BogeySize getSize(BogeyStyle style) {
        Iterator iterator = style.validSizes().iterator();
        if (iterator.hasNext()) {
            BogeySizes.BogeySize size = (BogeySizes.BogeySize)iterator.next();
            return size;
        }
        return null;
    }

    public static List<Pair<BogeyStyle, BogeySizes.BogeySize>> getRenderCycle(BogeyStyle style) {
        return CACHED_RENDER_CYCLES.computeIfAbsent(style, s -> {
            ArrayList<Pair> cycle = new ArrayList<Pair>();
            for (BogeySizes.BogeySize size : style.validSizes()) {
                cycle.add(Pair.of((Object)style, (Object)size));
            }
            for (BogeyStyle subStyle : CRBogeyStyles.getSubStyles(style)) {
                for (BogeySizes.BogeySize size : subStyle.validSizes()) {
                    cycle.add(Pair.of((Object)subStyle, (Object)size));
                }
            }
            return cycle;
        });
    }

    public static Indicator.State[] getTrackCompat(BogeyEntry bogeyEntry) {
        return CACHED_COMPATS.computeIfAbsent(bogeyEntry, k -> new Indicator.State[]{BogeyMenuHandlerClient.styleFits(bogeyEntry, CRTrackMaterials.CRTrackType.NARROW_GAUGE), BogeyMenuHandlerClient.styleFits(bogeyEntry, TrackMaterial.TrackType.STANDARD), BogeyMenuHandlerClient.styleFits(bogeyEntry, CRTrackMaterials.CRTrackType.WIDE_GAUGE)});
    }

    private static Indicator.State styleFits(BogeyEntry bogeyEntry, TrackMaterial.TrackType trackType) {
        if (CRBogeyStyles.styleFitsTrack(bogeyEntry.bogeyStyle(), trackType)) {
            return Indicator.State.GREEN;
        }
        for (BogeyStyle subStyle : CRBogeyStyles.getSubStyles(bogeyEntry.bogeyStyle())) {
            if (!CRBogeyStyles.styleFitsTrack(subStyle, trackType)) continue;
            return Indicator.State.GREEN;
        }
        return Indicator.State.RED;
    }
}

