/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.NaturalistAnimal;
import com.starfish_studios.naturalist.common.entity.core.NaturalistGeoEntity;
import com.starfish_studios.naturalist.common.entity.core.SleepingAnimal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BabyHurtByTargetGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BabyPanicGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.DistancedFollowParentGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.SearchForItemsGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.SleepGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.MMPathNavigatorGround;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.SmartBodyHelper;
import com.starfish_studios.naturalist.core.platform.CommonPlatformHelper;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistRegistry;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Containers;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Bear
extends NaturalistAnimal
implements NeutralMob,
NaturalistGeoEntity,
SleepingAnimal,
Shearable {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(NaturalistTags.ItemTags.BEAR_TEMPT_ITEMS);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(Bear.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SNIFFING = SynchedEntityData.m_135353_(Bear.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(Bear.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(Bear.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> EAT_COUNTER = SynchedEntityData.m_135353_(Bear.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private static final EntityDataAccessor<Integer> REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(Bear.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private UUID persistentAngerTarget;
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.sf_nba.bear.idle");
    protected static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.sf_nba.bear.walk");
    protected static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.sf_nba.bear.run");
    protected static final RawAnimation SIT = RawAnimation.begin().thenLoop("animation.sf_nba.bear.sit");
    protected static final RawAnimation SLEEP = RawAnimation.begin().thenLoop("animation.sf_nba.bear.sleep");
    protected static final RawAnimation SNIFF = RawAnimation.begin().thenLoop("animation.sf_nba.bear.sniff");
    protected static final RawAnimation EAT = RawAnimation.begin().thenLoop("animation.sf_nba.bear.eat");
    protected static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("animation.sf_nba.bear.attack");

    public Bear(@NotNull EntityType<? extends NaturalistAnimal> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
        this.m_21553_(true);
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper((Mob)this);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new MMPathNavigatorGround((Mob)this, level);
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            this.m_6858_(this.m_21566_().m_24999_() >= 1.25);
        } else {
            this.m_6858_(false);
        }
        super.m_8024_();
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob mob) {
        return (AgeableMob)NaturalistEntityTypes.BEAR.get().m_20615_((Level)level);
    }

    public boolean m_6898_(@NotNull ItemStack pStack) {
        return FOOD_ITEMS.test(pStack);
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pSpawnData == null) {
            pSpawnData = new AgeableMob.AgeableMobGroupData(1.0f);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22278_, 0.6);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new BearFloatGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new BearMeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.f_21345_.m_25352_(3, (Goal)new BearSleepGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new BearTemptGoal(this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new BabyPanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(5, (Goal)new DistancedFollowParentGoal(this, 1.25, 48.0, 8.0, 12.0));
        this.f_21345_.m_25352_(5, (Goal)new SearchForItemsGoal((PathfinderMob)this, 1.2f, FOOD_ITEMS, 8.0, 2.0));
        this.f_21345_.m_25352_(6, (Goal)new BearHarvestFoodGoal(this, 1.2f, 12, 3));
        this.f_21345_.m_25352_(7, (Goal)new BearPickupFoodAndSitGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new BabyHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new BearAttackPlayerNearBabiesGoal(this, Player.class, 20, false, true, null));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Bear)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, PathfinderMob.class, 10, true, false, entity -> entity.m_6095_().m_204039_(NaturalistTags.EntityTypes.BEAR_HOSTILES) && !this.m_5803_() && !this.m_6162_()));
        this.f_21346_.m_25352_(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.m_5803_() || this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        }
        this.handleEating();
        if (!this.m_21205_().m_41619_()) {
            if (this.m_21660_()) {
                this.m_21662_();
            }
            this.setSniffing(false);
        }
        this.m_9236_().m_46473_().m_6180_("looting");
        if (!this.m_9236_().f_46443_ && this.m_21531_() && this.m_6084_() && !this.f_20890_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            for (ItemEntity itementity : this.m_9236_().m_45976_(ItemEntity.class, this.m_20191_().m_82377_(1.0, 0.0, 1.0))) {
                if (itementity.m_213877_() || itementity.m_32055_().m_41619_() || !this.m_7243_(itementity.m_32055_())) continue;
                this.m_7581_(itementity);
            }
        }
        this.m_9236_().m_46473_().m_7238_();
    }

    public boolean m_6673_(DamageSource pSource) {
        return pSource.equals(this.m_269291_().m_269555_()) || super.m_6673_(pSource);
    }

    protected float m_6431_(@NotNull Pose pPose, @NotNull EntityDimensions pSize) {
        return pSize.f_20378_ * 0.75f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(SNIFFING, (Object)false);
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(SHEARED, (Object)false);
        this.f_19804_.m_135372_(EAT_COUNTER, (Object)0);
        this.f_19804_.m_135372_(REMAINING_ANGER_TIME, (Object)0);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_147285_(this.m_9236_(), pCompound);
        if (pCompound.m_128441_("Sheared")) {
            this.setSheared(pCompound.m_128471_("Sheared"));
        }
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.m_21678_(pCompound);
        pCompound.m_128379_("Sheared", this.isSheared());
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    @Override
    public boolean canSleep() {
        long dayTime = this.m_9236_().m_46468_();
        return (dayTime < 12000L || dayTime > 18000L) && dayTime < 23000L && dayTime > 6000L && !this.m_21660_() && !this.m_9236_().m_46801_(this.m_20183_());
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)sleeping);
    }

    public boolean isSniffing() {
        return (Boolean)this.f_19804_.m_135370_(SNIFFING);
    }

    public void setSniffing(boolean sniffing) {
        this.f_19804_.m_135381_(SNIFFING, (Object)sniffing);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public void setSitting(boolean sitting) {
        this.f_19804_.m_135381_(SITTING, (Object)sitting);
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(SHEARED, (Object)sheared);
    }

    public boolean isEating() {
        return (Integer)this.f_19804_.m_135370_(EAT_COUNTER) > 0;
    }

    public void eat(boolean eat) {
        this.f_19804_.m_135381_(EAT_COUNTER, (Object)(eat ? 1 : 0));
    }

    private int getEatCounter() {
        return (Integer)this.f_19804_.m_135370_(EAT_COUNTER);
    }

    private void setEatCounter(int amount) {
        this.f_19804_.m_135381_(EAT_COUNTER, (Object)amount);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int pTime) {
        this.f_19804_.m_135381_(REMAINING_ANGER_TIME, (Object)pTime);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(REMAINING_ANGER_TIME);
    }

    public void m_6925_(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    private void handleEating() {
        if (!this.isEating() && this.isSitting() && !this.m_5803_() && !this.m_21205_().m_41619_() && this.f_19796_.m_188503_(80) == 1) {
            this.eat(true);
        } else if (this.m_21205_().m_41619_() || !this.isSitting()) {
            this.eat(false);
        }
        if (this.isEating()) {
            this.addEatingParticles();
            if (!this.m_9236_().f_46443_ && this.getEatCounter() > 40) {
                if (this.m_6898_(this.m_6844_(EquipmentSlot.MAINHAND))) {
                    if (!this.m_9236_().f_46443_) {
                        this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                        this.m_146850_(GameEvent.f_157806_);
                        this.setSheared(false);
                    }
                    this.setSitting(false);
                }
                this.eat(false);
                return;
            }
            this.setEatCounter(this.getEatCounter() + 1);
        }
    }

    private void addEatingParticles() {
        if (this.getEatCounter() % 5 == 0 || this.getEatCounter() == 0) {
            this.m_5496_(NaturalistSoundEvents.BEAR_EAT.get(), 0.5f + 0.5f * (float)this.f_19796_.m_188503_(2), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            for (int i = 0; i < 6; ++i) {
                Vec3 speedVec = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.f_19796_.m_188501_() - 0.5) * 0.1);
                speedVec = speedVec.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
                speedVec = speedVec.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                double y = (double)(-this.f_19796_.m_188501_()) * 0.6 - 0.3;
                Vec3 posVec = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.8, y, 1.0 + ((double)this.f_19796_.m_188501_() - 0.5) * 0.4);
                posVec = posVec.m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
                posVec = posVec.m_82520_(this.m_20185_(), this.m_20188_() - 0.2, this.m_20189_() - 0.1);
                this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_6844_(EquipmentSlot.MAINHAND)), posVec.f_82479_, posVec.f_82480_, posVec.f_82481_, speedVec.f_82479_, speedVec.f_82480_ + 0.05, speedVec.f_82481_);
            }
        }
    }

    public boolean m_7066_(@NotNull ItemStack pItemstack) {
        EquipmentSlot slot = Mob.m_147233_((ItemStack)pItemstack);
        if (!this.m_6844_(slot).m_41619_() || this.m_6162_()) {
            return false;
        }
        return slot == EquipmentSlot.MAINHAND && super.m_7066_(pItemstack);
    }

    protected void m_7581_(@NotNull ItemEntity pItemEntity) {
        ItemStack stack = pItemEntity.m_32055_();
        if (this.m_21205_().m_41619_() && FOOD_ITEMS.test(stack) && !this.m_6162_()) {
            this.m_21053_(pItemEntity);
            this.m_8061_(EquipmentSlot.MAINHAND, stack);
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)pItemEntity, stack.m_41613_());
            pItemEntity.m_146870_();
        }
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        if (!this.m_21205_().m_41619_() && !this.m_9236_().f_46443_) {
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, this.m_21205_());
            itemEntity.m_32010_(80);
            itemEntity.m_32052_(this.m_20148_());
            this.m_5496_(NaturalistSoundEvents.BEAR_SPIT.get(), 1.0f, 1.0f);
            this.m_9236_().m_7967_((Entity)itemEntity);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
        return super.m_6469_(pSource, pAmount);
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        TagKey<Item> tag;
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_204117_(tag = CommonPlatformHelper.getShearsTag()) && this.m_6220_()) {
            if (!this.m_5803_()) {
                this.m_6703_((LivingEntity)player);
            }
            this.m_5851_(SoundSource.PLAYERS);
            this.m_146852_(GameEvent.f_157781_, (Entity)player);
            if (!this.m_9236_().f_46443_) {
                itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public void m_5851_(@NotNull SoundSource source) {
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, source, 1.0f, 1.0f);
        this.setSheared(true);
        int amount = 1 + this.f_19796_.m_188503_(2);
        for (int j = 0; j < amount; ++j) {
            ItemEntity itemEntity = this.m_20000_((ItemLike)NaturalistRegistry.FUR.get(), 1);
            if (itemEntity == null) continue;
            itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.isSheared() && !this.m_6162_();
    }

    protected float m_6108_() {
        return 0.98f;
    }

    void tryToSit() {
        if (!this.isTouchingWater()) {
            this.m_21564_(0.0f);
            this.m_21573_().m_26573_();
            this.setSitting(true);
        }
    }

    boolean isTouchingWater() {
        return this.m_9236_().m_46801_(this.m_20183_());
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return this.m_6162_() ? NaturalistSoundEvents.BEAR_HURT_BABY.get() : NaturalistSoundEvents.BEAR_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return NaturalistSoundEvents.BEAR_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.m_5803_() ? NaturalistSoundEvents.BEAR_SLEEP.get() : (this.m_6162_() ? NaturalistSoundEvents.BEAR_AMBIENT_BABY.get() : NaturalistSoundEvents.BEAR_AMBIENT.get());
    }

    public float m_6100_() {
        return this.m_5803_() ? super.m_6100_() * 0.3f : (this.m_6162_() ? super.m_6100_() * 0.4f : super.m_6100_());
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_12284_, 0.15f, 1.0f);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected <E extends Bear> PlayState predicate(AnimationState<E> event) {
        if (this.m_5803_()) {
            event.getController().setAnimation(SLEEP);
            return PlayState.CONTINUE;
        }
        if (this.isSitting()) {
            event.getController().setAnimation(SIT);
            return PlayState.CONTINUE;
        }
        if (this.m_20184_().m_165925_() > 1.0E-6) {
            if (this.m_20142_()) {
                event.getController().setAnimation(RUN);
                event.getController().setAnimationSpeed(2.0);
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(WALK);
            event.getController().setAnimationSpeed(1.4);
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(IDLE);
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    protected <E extends Bear> PlayState sniffPredicate(@NotNull AnimationState<E> event) {
        if (this.isSniffing()) {
            event.getController().setAnimation(SNIFF);
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    protected <E extends Bear> PlayState attackPredicate(AnimationState<E> event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimationSpeed((double)1.3f);
            event.setAnimation(ATTACK);
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    @NotNull
    protected <E extends Bear> PlayState eatPredicate(AnimationState<E> event) {
        if (this.isEating()) {
            event.getController().setAnimation(EAT);
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "sniffController", 2, this::sniffPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "swingController", 2, this::attackPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "eatController", 5, this::eatPredicate)});
    }

    static class BearFloatGoal
    extends FloatGoal {
        private final Bear bear;

        public BearFloatGoal(Bear pMob) {
            super((Mob)pMob);
            this.bear = pMob;
        }

        public boolean m_8036_() {
            if (!this.bear.m_6162_()) {
                return (this.bear.m_9236_().m_46801_(this.bear.m_20183_().m_7495_()) || this.bear.m_9236_().m_46801_(this.bear.m_20183_().m_7494_())) && super.m_8036_();
            }
            return super.m_8036_();
        }
    }

    static class BearMeleeAttackGoal
    extends MeleeAttackGoal {
        public BearMeleeAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        }

        public boolean m_8036_() {
            return this.f_25540_.m_21205_().m_41619_() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.f_25540_.m_21205_().m_41619_() && super.m_8045_();
        }

        protected double m_6639_(LivingEntity pAttackTarget) {
            return pAttackTarget instanceof AbstractSchoolingFish ? super.m_6639_(pAttackTarget) : (double)(4.0f + pAttackTarget.m_20205_());
        }
    }

    class BearSleepGoal
    extends SleepGoal<Bear> {
        public BearSleepGoal(Bear animal) {
            super(animal);
        }

        @Override
        public void m_8056_() {
            Bear.this.setSniffing(false);
            super.m_8056_();
        }
    }

    static class BearTemptGoal
    extends TemptGoal {
        private final Bear bear;

        public BearTemptGoal(Bear pMob, double pSpeedModifier, Ingredient pItems, boolean pCanScare) {
            super((PathfinderMob)pMob, pSpeedModifier, pItems, pCanScare);
            this.bear = pMob;
        }

        public boolean m_8036_() {
            return this.bear.m_21205_().m_41619_() && super.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.bear.setSniffing(true);
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.bear.m_217043_().m_188501_() < 0.05f) {
                this.bear.m_5496_(NaturalistSoundEvents.BEAR_SNIFF.get(), 1.0f, 1.0f);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.bear.setSniffing(false);
        }
    }

    static class BearHarvestFoodGoal
    extends MoveToBlockGoal {
        protected int ticksWaited;
        @NotNull
        private final Bear bear;

        public BearHarvestFoodGoal(Bear pMob, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
            super((PathfinderMob)pMob, pSpeedModifier, pSearchRange, pVerticalSearchRange);
            this.bear = pMob;
        }

        public double m_8052_() {
            return 3.0;
        }

        public boolean m_8064_() {
            return this.f_25601_ % 100 == 0;
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            BlockEntity blockEntity;
            BlockState state = pLevel.m_8055_(pPos);
            if (state.m_60734_() instanceof BeehiveBlock) {
                return (Integer)state.m_61143_((Property)BeehiveBlock.f_49564_) >= 5;
            }
            if (state.m_60713_(Blocks.f_50685_)) {
                return (Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_) >= 2;
            }
            if (state.m_60713_(Blocks.f_50683_) && (blockEntity = pLevel.m_7702_(pPos)) instanceof CampfireBlockEntity) {
                CampfireBlockEntity campfire = (CampfireBlockEntity)blockEntity;
                return this.campfireIsTempting(campfire);
            }
            return false;
        }

        public void m_8037_() {
            if (this.m_25625_()) {
                if (this.ticksWaited >= 40) {
                    this.onReachedTarget();
                } else {
                    ++this.ticksWaited;
                }
            } else if (!this.m_25625_() && this.bear.m_217043_().m_188501_() < 0.05f) {
                this.bear.m_5496_(NaturalistSoundEvents.BEAR_SNIFF.get(), 1.0f, 1.0f);
                this.bear.setSniffing(true);
            }
            this.bear.m_21563_().m_24950_((double)this.f_25602_.m_123341_() + 0.5, (double)this.f_25602_.m_123342_(), (double)this.f_25602_.m_123343_() + 0.5, 10.0f, (float)this.bear.m_8132_());
            super.m_8037_();
        }

        protected void onReachedTarget() {
            if (this.bear.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                CampfireBlockEntity campfire;
                BlockEntity blockEntity;
                BlockState state = this.bear.m_9236_().m_8055_(this.f_25602_);
                this.bear.setSniffing(false);
                if (state.m_60734_() instanceof BeehiveBlock && (Integer)state.m_61143_((Property)BeehiveBlock.f_49564_) >= 5) {
                    this.harvestHoney(state);
                } else if (state.m_60713_(Blocks.f_50685_) && (Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_) >= 2) {
                    this.pickSweetBerries(state);
                } else if (state.m_60713_(Blocks.f_50683_) && (blockEntity = this.bear.m_9236_().m_7702_(this.f_25602_)) instanceof CampfireBlockEntity && this.campfireIsTempting(campfire = (CampfireBlockEntity)blockEntity)) {
                    this.stealCampfireFood(state, campfire);
                }
            }
        }

        private void stealCampfireFood(BlockState state, @NotNull CampfireBlockEntity campfire) {
            for (int i = 0; i < campfire.m_59065_().size(); ++i) {
                if (!FOOD_ITEMS.test((ItemStack)campfire.m_59065_().get(i))) continue;
                Containers.m_18992_((Level)this.bear.m_9236_(), (double)this.f_25602_.m_123341_(), (double)this.f_25602_.m_123342_(), (double)this.f_25602_.m_123343_(), (ItemStack)((ItemStack)campfire.m_59065_().get(i)));
                campfire.m_59065_().set(i, (Object)ItemStack.f_41583_);
                this.bear.m_9236_().m_7260_(this.f_25602_, state, state, 3);
                campfire.m_6596_();
                break;
            }
        }

        private boolean campfireIsTempting(@NotNull CampfireBlockEntity campfire) {
            for (int i = 0; i < campfire.m_59065_().size(); ++i) {
                if (!FOOD_ITEMS.test((ItemStack)campfire.m_59065_().get(i))) continue;
                return true;
            }
            return false;
        }

        private void harvestHoney(BlockState state) {
            state.m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(0));
            BeehiveBlock.m_49600_((Level)this.bear.m_9236_(), (BlockPos)this.f_25602_);
            this.bear.m_5496_(SoundEvents.f_11697_, 1.0f, 1.0f);
            this.bear.m_9236_().m_7731_(this.f_25602_, (BlockState)state.m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(0)), 2);
            this.bear.m_6674_(InteractionHand.MAIN_HAND);
        }

        private void pickSweetBerries(@NotNull BlockState state) {
            int age = (Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_);
            state.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1));
            int berryAmount = 1 + this.bear.m_9236_().f_46441_.m_188503_(2) + (age == 3 ? 1 : 0);
            Block.m_49840_((Level)this.bear.m_9236_(), (BlockPos)this.f_25602_, (ItemStack)new ItemStack((ItemLike)Items.f_42780_, berryAmount));
            this.bear.m_5496_(SoundEvents.f_12457_, 1.0f, 1.0f);
            this.bear.m_9236_().m_7731_(this.f_25602_, (BlockState)state.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1)), 2);
            this.bear.m_6674_(InteractionHand.MAIN_HAND);
        }

        public boolean m_8036_() {
            return !this.bear.m_6162_() && this.bear.m_21205_().m_41619_() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.bear.m_21205_().m_41619_() && super.m_8045_();
        }

        public void m_8056_() {
            this.ticksWaited = 0;
            super.m_8056_();
        }

        protected BlockPos m_6669_() {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)this.f_25602_);
            while (this.bear.m_9236_().m_8055_(mutable.m_7495_()).m_60795_()) {
                mutable.m_122173_(Direction.DOWN);
            }
            return mutable;
        }
    }

    static class BearPickupFoodAndSitGoal
    extends Goal {
        private int cooldown;
        private final Bear bear;

        public BearPickupFoodAndSitGoal(Bear bear) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.bear = bear;
        }

        public boolean m_8036_() {
            if (!(this.cooldown > this.bear.f_19797_ || this.bear.m_6162_() || this.bear.isTouchingWater() || this.bear.m_5803_() || this.bear.isSitting())) {
                return !this.bear.m_21205_().m_41619_();
            }
            return false;
        }

        public boolean m_8045_() {
            return !this.bear.isTouchingWater();
        }

        public void m_8037_() {
            if (!this.bear.isSitting() && !this.bear.m_21205_().m_41619_()) {
                this.bear.tryToSit();
            }
        }

        public void m_8056_() {
            if (!this.bear.m_21205_().m_41619_()) {
                this.bear.tryToSit();
            }
            this.cooldown = 0;
        }

        public void m_8041_() {
            ItemStack stack = this.bear.m_6844_(EquipmentSlot.MAINHAND);
            if (!stack.m_41619_()) {
                this.bear.m_19983_(stack);
                this.bear.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                int cooldownSeconds = this.bear.f_19796_.m_188503_(150) + 10;
                this.cooldown = this.bear.f_19797_ + cooldownSeconds * 20;
            }
            this.bear.setSitting(false);
        }
    }

    static class BearAttackPlayerNearBabiesGoal
    extends NearestAttackableTargetGoal<Player> {
        private final Bear bear;

        public BearAttackPlayerNearBabiesGoal(Bear pMob, Class<Player> pTargetType, int pRandomInterval, boolean pMustSee, boolean pMustReach, @Nullable Predicate<LivingEntity> pTargetPredicate) {
            super((Mob)pMob, pTargetType, pRandomInterval, pMustSee, pMustReach, pTargetPredicate);
            this.bear = pMob;
        }

        public boolean m_8036_() {
            if (!this.bear.m_6162_() && !this.bear.m_5803_() && super.m_8036_()) {
                for (Bear bear : this.bear.m_9236_().m_45976_(Bear.class, this.bear.m_20191_().m_82377_(8.0, 4.0, 8.0))) {
                    if (!bear.m_6162_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double m_7623_() {
            return super.m_7623_() * 0.5;
        }
    }
}

