/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import xaeroplus.Globals;
import xaeroplus.event.ChunkBlockUpdateEvent;
import xaeroplus.event.ChunkBlocksUpdateEvent;
import xaeroplus.event.ChunkDataEvent;
import xaeroplus.feature.highlights.SavableHighlightCacheInstance;
import xaeroplus.feature.render.DrawFeatureFactory;
import xaeroplus.module.Module;
import xaeroplus.settings.Settings;
import xaeroplus.shadow.lambdaevents.EventHandler;
import xaeroplus.util.ChunkScanner;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class Portals
extends Module {
    public final SavableHighlightCacheInstance portalsCache = new SavableHighlightCacheInstance("XaeroPlusPortals");
    private int portalsColor = ColorHelper.getColor(0, 255, 0, 100);
    private static final ReferenceSet<Block> PORTAL_BLOCKS = ReferenceOpenHashSet.of((Object[])new Block[]{Blocks.f_50257_, Blocks.f_50446_, Blocks.f_50142_, Blocks.f_50258_});

    public void setDiskCache(boolean disk) {
        this.portalsCache.setDiskCache(disk, this.isEnabled());
    }

    @Override
    public void onEnable() {
        Globals.drawManager.registry().register(DrawFeatureFactory.chunkHighlights(this.getClass().getName(), this::getHighlightsState, this::getPortalsColor, 250));
        this.portalsCache.onEnable();
        this.searchAllLoadedChunks();
    }

    @Override
    public void onDisable() {
        this.portalsCache.onDisable();
        Globals.drawManager.registry().unregister(this.getClass().getName());
    }

    @EventHandler
    public void onChunkData(ChunkDataEvent event) {
        this.findPortalInChunk((ChunkAccess)event.chunk());
    }

    @EventHandler
    public void onMultiBlockUpdate(ChunkBlocksUpdateEvent event) {
        switch (event.phase()) {
            case PRE: {
                event.packet().m_132992_(this::handleBlockChange);
                break;
            }
            case POST: {
                this.handleMultiBlockChangePost(event);
            }
        }
    }

    private void handleMultiBlockChangePost(ChunkBlocksUpdateEvent event) {
        ClientLevel level = this.mc.f_91073_;
        if (level == null) {
            return;
        }
        event.packet().m_132992_((blockPos, blockState) -> {
            if (!blockState.m_60795_()) {
                return;
            }
            int chunkX = ChunkUtils.posToChunkPos(blockPos.m_123341_());
            int chunkZ = ChunkUtils.posToChunkPos(blockPos.m_123343_());
            if (!this.portalsCache.get().isHighlighted(chunkX, chunkZ, ChunkUtils.getActualDimension())) {
                return;
            }
            LevelChunk chunk = level.m_7726_().m_62227_(chunkX, chunkZ, false);
            if (chunk instanceof EmptyLevelChunk || chunk == null) {
                return;
            }
            this.findPortalInChunk((ChunkAccess)chunk);
        });
    }

    @EventHandler
    public void onBlockUpdate(ChunkBlockUpdateEvent event) {
        switch (event.phase()) {
            case PRE: {
                this.handleBlockChange(event.packet().m_131749_(), event.packet().m_131746_());
                break;
            }
            case POST: {
                this.handleBlockChangePost(event);
            }
        }
    }

    private void handleBlockChangePost(ChunkBlockUpdateEvent event) {
        ClientLevel level = this.mc.f_91073_;
        if (level == null) {
            return;
        }
        BlockPos blockPos = event.packet().m_131749_();
        BlockState blockState = event.packet().m_131746_();
        if (!blockState.m_60795_()) {
            return;
        }
        int chunkX = ChunkUtils.posToChunkPos(blockPos.m_123341_());
        int chunkZ = ChunkUtils.posToChunkPos(blockPos.m_123343_());
        if (!this.portalsCache.get().isHighlighted(chunkX, chunkZ, ChunkUtils.getActualDimension())) {
            return;
        }
        LevelChunk chunk = level.m_7726_().m_62227_(chunkX, chunkZ, false);
        if (chunk instanceof EmptyLevelChunk || chunk == null) {
            return;
        }
        this.findPortalInChunk((ChunkAccess)chunk);
    }

    private void findPortalInChunk(ChunkAccess chunk) {
        boolean chunkHadPortal = this.portalsCache.get().isHighlighted(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_, ChunkUtils.getActualDimension());
        boolean hasPortal = ChunkScanner.chunkContainsBlocks(chunk, PORTAL_BLOCKS, this.mc.f_91073_.m_141937_());
        if (hasPortal) {
            this.portalsCache.get().addHighlight(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_);
        } else if (chunkHadPortal) {
            this.portalsCache.get().removeHighlight(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_);
        }
    }

    private void searchAllLoadedChunks() {
        if (this.mc.f_91073_ == null) {
            return;
        }
        int renderDist = (Integer)this.mc.f_91066_.m_231984_().m_231551_();
        int xMin = ChunkUtils.actualPlayerChunkX() - renderDist;
        int xMax = ChunkUtils.actualPlayerChunkX() + renderDist;
        int zMin = ChunkUtils.actualPlayerChunkZ() - renderDist;
        int zMax = ChunkUtils.actualPlayerChunkZ() + renderDist;
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                LevelChunk chunk = this.mc.f_91073_.m_7726_().m_62227_(x, z, false);
                if (chunk instanceof EmptyLevelChunk || chunk == null) continue;
                this.findPortalInChunk((ChunkAccess)chunk);
            }
        }
    }

    private void handleBlockChange(BlockPos pos, BlockState state) {
        int chunkX = ChunkUtils.posToChunkPos(pos.m_123341_());
        int chunkZ = ChunkUtils.posToChunkPos(pos.m_123343_());
        if (!(state.m_60734_() instanceof NetherPortalBlock) && !(state.m_60734_() instanceof EndPortalBlock)) {
            return;
        }
        this.portalsCache.get().addHighlight(chunkX, chunkZ);
    }

    public int getPortalsColor() {
        return this.portalsColor;
    }

    public void setRgbColor(int color) {
        this.portalsColor = ColorHelper.getColorWithAlpha(color, Settings.REGISTRY.portalsAlphaSetting.getAsInt());
    }

    public void setAlpha(double a) {
        this.portalsColor = ColorHelper.getColorWithAlpha(this.portalsColor, (int)a);
    }

    public boolean isPortalChunk(int chunkPosX, int chunkPosZ, ResourceKey<Level> dimensionId) {
        return this.portalsCache.get().isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }

    public Long2LongMap getHighlightsState(ResourceKey<Level> dimension) {
        return this.portalsCache.get().getCacheMap(dimension);
    }
}

