/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.line;

public record Line(int x1, int z1, int x2, int z2) {
    public double length() {
        return Math.sqrt(Math.pow(this.x2 - this.x1, 2.0) + Math.pow(this.z2 - this.z1, 2.0));
    }

    public Line extrapolateToWorldBorder() {
        return this.extrapolateToMaxCoord(30000000);
    }

    public Line extrapolateToMaxCoord(int coord) {
        int dx = this.x2() - this.x1();
        if (dx == 0) {
            return new Line(this.x1(), -coord, this.x2(), coord);
        }
        int dz = this.z2() - this.z1();
        if (dz == 0) {
            return new Line(-coord, this.z1(), coord, this.z2());
        }
        double slope = (double)dz / (double)dx;
        double x1 = -coord;
        double intercept = (double)this.z1() - slope * (double)this.x1();
        double z1 = slope * x1 + intercept;
        if (z1 < (double)(-coord)) {
            z1 = -coord;
            x1 = (z1 - intercept) / slope;
        } else if (z1 > (double)coord) {
            z1 = coord;
            x1 = (z1 - intercept) / slope;
        }
        double x2 = coord;
        double z2 = slope * x2 + intercept;
        if (z2 < (double)(-coord)) {
            z2 = -coord;
            x2 = (z2 - intercept) / slope;
        } else if (z2 > (double)coord) {
            z2 = coord;
            x2 = (z2 - intercept) / slope;
        }
        return new Line((int)Math.round(x1), (int)Math.round(z1), (int)Math.round(x2), (int)Math.round(z2));
    }
}

