/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.beacon;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import xaero.common.HudMod;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointVisibilityType;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointPurpose;
import xaero.hud.minimap.world.MinimapWorld;
import xaeroplus.settings.Settings;
import xaeroplus.util.ColorHelper;

public class WaypointBeaconRenderer {
    public static final WaypointBeaconRenderer INSTANCE = new WaypointBeaconRenderer();
    private final List<Waypoint> waypointList = new ArrayList<Waypoint>();
    private long lastWaypointRenderListUpdate = -1L;

    public void updateWaypointRenderList(MinimapSession session, ModSettings settings) {
        this.waypointList.clear();
        session.getWaypointSession().getCollector().collect(this.waypointList);
        this.waypointList.removeIf(w -> {
            if (w.isDisabled() || w.getVisibility() == WaypointVisibilityType.WORLD_MAP_LOCAL || w.getVisibility() == WaypointVisibilityType.WORLD_MAP_GLOBAL) {
                return true;
            }
            return !settings.getDeathpoints() && w.getPurpose().isDeath();
        });
        this.waypointList.sort(Waypoint::compareTo);
    }

    public void renderWaypointBeacons(float tickDelta, PoseStack matrixStack) {
        MinimapSession session = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        if (session == null) {
            return;
        }
        ModSettings settings = HudMod.INSTANCE.getSettings();
        if (settings == null) {
            return;
        }
        if (!settings.getShowIngameWaypoints()) {
            return;
        }
        MinimapWorld currentWorld = session.getWorldManager().getCurrentWorld();
        if (currentWorld == null) {
            return;
        }
        if (System.currentTimeMillis() - this.lastWaypointRenderListUpdate > 50L) {
            this.updateWaypointRenderList(session, settings);
            this.lastWaypointRenderListUpdate = System.currentTimeMillis();
        }
        double dimDiv = session.getDimensionHelper().getDimensionDivision(currentWorld);
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91075_ == null) {
            return;
        }
        Vec3 cameraPos = mc.f_91075_.m_20182_();
        double distanceScale = settings.dimensionScaledMaxWaypointDistance ? mc.f_91073_.m_6042_().f_63859_() : 1.0;
        double waypointsDistance = settings.getMaxWaypointsDistance();
        double waypointsDistanceMin = settings.waypointsDistanceMin;
        for (int i = 0; i < this.waypointList.size(); ++i) {
            boolean shouldRender;
            WaypointPurpose purpose;
            Waypoint w = this.waypointList.get(i);
            double offX = (double)w.getX(dimDiv) - cameraPos.f_82479_ + 0.5;
            double offZ = (double)w.getZ(dimDiv) - cameraPos.f_82481_ + 0.5;
            double unscaledDistance2D = Math.sqrt(offX * offX + offZ * offZ);
            double distance2D = unscaledDistance2D * distanceScale;
            if (Settings.REGISTRY.limitDeathpointsRenderDistance.get() && (purpose = w.getPurpose()) == WaypointPurpose.DEATH && Settings.REGISTRY.limitDeathpointsRenderDistance.get() && waypointsDistance != 0.0 && distance2D > waypointsDistance) continue;
            boolean bl = shouldRender = w.isDestination() || (w.getPurpose().isDeath() || w.isGlobal() || w.isTemporary() && settings.temporaryWaypointsGlobal || waypointsDistance == 0.0 || !(distance2D > waypointsDistance)) && (waypointsDistanceMin == 0.0 || !(unscaledDistance2D < waypointsDistanceMin));
            if (!shouldRender) continue;
            this.renderWaypointBeacon(w, dimDiv, tickDelta, matrixStack);
        }
    }

    public void renderWaypointBeacon(Waypoint waypoint, double dimDiv, float tickDelta, PoseStack matrixStack) {
        Vec3 waypointVec;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91075_ == null) {
            return;
        }
        Vec3 playerVec = mc.f_91075_.m_20182_();
        double xzDistance = playerVec.m_82554_(waypointVec = new Vec3((double)waypoint.getX(dimDiv), playerVec.f_82480_, (double)waypoint.getZ(dimDiv)));
        if (xzDistance < (double)Settings.REGISTRY.waypointBeaconDistanceMin.getAsInt()) {
            return;
        }
        int farScale = Settings.REGISTRY.waypointBeaconScaleMin.getAsInt();
        double maxRenderDistance = Math.min((Integer)mc.f_91066_.m_231984_().m_231551_() << 4, farScale == 0 ? Integer.MAX_VALUE : farScale << 4);
        if (xzDistance > maxRenderDistance) {
            Vec3 delta = waypointVec.m_82546_(playerVec).m_82541_();
            waypointVec = playerVec.m_82549_(new Vec3(delta.f_82479_ * maxRenderDistance, delta.f_82480_ * maxRenderDistance, delta.f_82481_ * maxRenderDistance));
        }
        EntityRenderDispatcher entityRenderDispatcher = mc.m_91290_();
        Camera camera = entityRenderDispatcher.f_114358_;
        Frustum frustum = mc.f_91060_.f_172938_;
        if (camera == null || frustum == null) {
            return;
        }
        double viewX = camera.m_90583_().m_7096_();
        double viewZ = camera.m_90583_().m_7094_();
        double x = waypointVec.f_82479_ - viewX;
        double z = waypointVec.f_82481_ - viewZ;
        double y = -100.0;
        if (!frustum.m_113029_(new AABB(waypointVec.f_82479_ - 1.0, -100.0, waypointVec.f_82481_ - 1.0, waypointVec.f_82479_ + 1.0, 500.0, waypointVec.f_82481_ + 1.0))) {
            return;
        }
        int color = waypoint.getWaypointColor().getHex();
        MultiBufferSource.BufferSource entityVertexConsumers = mc.m_91269_().m_110104_();
        long time = mc.f_91073_.m_46467_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(x, -100.0, z);
        BeaconRenderer.m_112184_((PoseStack)matrixStack, (MultiBufferSource)entityVertexConsumers, (ResourceLocation)BeaconRenderer.f_112102_, (float)tickDelta, (float)1.0f, (long)time, (int)0, (int)355, (float[])ColorHelper.getColorRGBA(color), (float)0.2f, (float)0.25f);
        matrixStack.m_85849_();
    }
}

