/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectRBTreeMap;
import java.util.Comparator;
import java.util.function.Consumer;
import xaeroplus.feature.render.DrawFeature;

public class DrawFeatureRegistry {
    private final Object2ObjectRBTreeMap<String, DrawFeature> features = new Object2ObjectRBTreeMap(Comparator.naturalOrder());

    public synchronized void register(DrawFeature feature) {
        String id = feature.id();
        this.unregister(id);
        this.features.put((Object)id, (Object)feature);
    }

    public synchronized void unregister(String id) {
        this.features.remove((Object)id);
    }

    public synchronized void forEach(Consumer<DrawFeature> action) {
        for (Object2ObjectMap.Entry entry : Object2ObjectMaps.fastIterable(this.features)) {
            DrawFeature feature = (DrawFeature)entry.getValue();
            action.accept(feature);
        }
    }
}

